/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.operationsdesk.peripherals.jobs;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.peripherals.PeripheralJob;
import org.opentcs.operationsdesk.peripherals.jobs.PeripheralJobsContainerListener;
import org.opentcs.util.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PeripheralJobTableModel
extends AbstractTableModel
implements PeripheralJobsContainerListener {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_LOCATION = 1;
    public static final int COLUMN_OPERATION = 2;
    public static final int COLUMN_RELATED_VEHICLE = 3;
    public static final int COLUMN_RELATED_ORDER = 4;
    public static final int COLUMN_STATE = 5;
    public static final int COLUMN_CREATION_TIME = 6;
    private static final Logger LOG = LoggerFactory.getLogger(PeripheralJobTableModel.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("i18n.org.opentcs.plantoverview.operating.panels.peripheralJobs");
    private static final String[] COLUMN_NAMES = new String[]{BUNDLE.getString("peripheralJobTableModel.column_name.headerText"), BUNDLE.getString("peripheralJobTableModel.column_location.headerText"), BUNDLE.getString("peripheralJobTableModel.column_operation.headerText"), BUNDLE.getString("peripheralJobTableModel.column_relatedVehicle.headerText"), BUNDLE.getString("peripheralJobTableModel.column_relatedTransportOrder.headerText"), BUNDLE.getString("peripheralJobTableModel.column_state.headerText"), BUNDLE.getString("peripheralJobTableModel.column_creationTime.headerText")};
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{String.class, String.class, String.class, TCSObjectReference.class, TCSObjectReference.class, String.class, Instant.class};
    private final List<PeripheralJob> entries = new ArrayList<PeripheralJob>();

    PeripheralJobTableModel() {
    }

    @Override
    public int getRowCount() {
        return this.entries.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.getRowCount()) {
            return null;
        }
        PeripheralJob entry = this.entries.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return entry.getName();
            }
            case 1: {
                return entry.getPeripheralOperation().getLocation().getName();
            }
            case 2: {
                return entry.getPeripheralOperation().getOperation();
            }
            case 3: {
                return entry.getRelatedVehicle();
            }
            case 4: {
                return entry.getRelatedTransportOrder();
            }
            case 5: {
                return entry.getState().name();
            }
            case 6: {
                return entry.getCreationTime();
            }
        }
        throw new IllegalArgumentException("Invalid column index: " + columnIndex);
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_CLASSES[columnIndex];
    }

    @Override
    public void containerInitialized(Collection<PeripheralJob> jobs) {
        Objects.requireNonNull(jobs, "jobs");
        SwingUtilities.invokeLater(() -> {
            this.entries.clear();
            this.entries.addAll(jobs);
            this.fireTableDataChanged();
        });
    }

    @Override
    public void peripheralJobAdded(PeripheralJob job) {
        Objects.requireNonNull(job, "job");
        SwingUtilities.invokeLater(() -> {
            this.entries.add(job);
            this.fireTableRowsInserted(this.entries.size() - 1, this.entries.size() - 1);
        });
    }

    @Override
    public void peripheralJobUpdated(PeripheralJob job) {
        Objects.requireNonNull(job, "job");
        SwingUtilities.invokeLater(() -> {
            int jobIndex = this.entries.indexOf(job);
            if (jobIndex == -1) {
                LOG.warn("Unknown job: {}. Ignoring job update.", (Object)job.getName());
                return;
            }
            this.entries.set(jobIndex, job);
            this.fireTableRowsUpdated(jobIndex, jobIndex);
        });
    }

    @Override
    public void peripheralJobRemoved(PeripheralJob job) {
        Objects.requireNonNull(job, "job");
        SwingUtilities.invokeLater(() -> {
            int jobIndex = this.entries.indexOf(job);
            if (jobIndex == -1) {
                LOG.warn("Unknown job: {}. Ignoring job removal.", (Object)job.getName());
                return;
            }
            this.entries.remove(jobIndex);
            this.fireTableRowsDeleted(jobIndex, jobIndex);
        });
    }

    public PeripheralJob getEntryAt(int index) {
        Assertions.checkArgument((index >= 0 && index < this.entries.size() ? 1 : 0) != 0, (String)"index must be in 0..%d: %d", (Object[])new Object[]{this.entries.size(), index});
        return this.entries.get(index);
    }
}

