/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.operationsdesk.peripherals.jobs;

import com.google.inject.assistedinject.Assisted;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.opentcs.components.plantoverview.ObjectHistoryEntryFormatter;
import org.opentcs.data.ObjectHistory;
import org.opentcs.data.peripherals.PeripheralJob;
import org.opentcs.guing.common.components.dialogs.DialogContent;
import org.opentcs.operationsdesk.transport.CompositeObjectHistoryEntryFormatter;
import org.opentcs.operationsdesk.transport.UneditableTableModel;
import org.opentcs.thirdparty.guing.common.jhotdraw.util.ResourceBundleUtil;

public class PeripheralJobView
extends DialogContent {
    private static final DateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private final ObjectHistoryEntryFormatter historyEntryFormatter;
    private final PeripheralJob peripheralJob;
    private JLabel createdLabel;
    private JTextField createdTextField;
    private JLabel finishedLabel;
    private JTextField finishedTextField;
    private JPanel generalPanel;
    private JPanel historyPanel;
    private JScrollPane historyScrollPane;
    private JTable historyTable;
    private JLabel locationLabel;
    private JTextField locationTextField;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JLabel operationLabel;
    private JPanel operationPanel;
    private JTextField operationTextField;
    private JPanel propertiesPanel;
    private JScrollPane propertiesScrollPane;
    private JTable propertiesTable;
    private JLabel relatedTransportOrderLabel;
    private JTextField relatedTransportOrderTextField;
    private JLabel requireCompletionLabel;
    private JTextField requireCompletionTextField;
    private JLabel reservationTokenLabel;
    private JTextField reservationTokenTextField;
    private JLabel stateLabel;
    private JTextField stateTextField;
    private JLabel triggerLabel;
    private JTextField triggerTextField;
    private JLabel vehicleLabel;
    private JTextField vehicleTextField;

    @Inject
    public PeripheralJobView(@Nonnull @Assisted PeripheralJob job, @Nonnull CompositeObjectHistoryEntryFormatter historyEntryFormatter) {
        this.peripheralJob = Objects.requireNonNull(job, "job");
        this.historyEntryFormatter = Objects.requireNonNull(historyEntryFormatter, "historyEntryFormatter");
        this.initComponents();
        this.setDialogTitle(ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.peripheralJobDetail").getString("peripheralJobView.title"));
    }

    public void update() {
    }

    public final void initFields() {
        this.nameTextField.setText(this.peripheralJob.getName());
        this.stateTextField.setText(this.peripheralJob.getState().name());
        this.createdTextField.setText(TIMESTAMP_FORMAT.format(Date.from(this.peripheralJob.getCreationTime())));
        this.finishedTextField.setText(!this.peripheralJob.getFinishedTime().equals(Instant.MAX) ? TIMESTAMP_FORMAT.format(Date.from(this.peripheralJob.getFinishedTime())) : "-");
        if (this.peripheralJob.getRelatedVehicle() != null) {
            this.vehicleTextField.setText(this.peripheralJob.getRelatedVehicle().getName());
        } else {
            this.vehicleTextField.setText("-");
        }
        this.reservationTokenTextField.setText(this.peripheralJob.getReservationToken());
        if (this.peripheralJob.getRelatedTransportOrder() != null) {
            this.relatedTransportOrderTextField.setText(this.peripheralJob.getRelatedTransportOrder().getName());
        } else {
            this.relatedTransportOrderTextField.setText("-");
        }
        this.locationTextField.setText(this.peripheralJob.getPeripheralOperation().getLocation().getName());
        this.operationTextField.setText(this.peripheralJob.getPeripheralOperation().getOperation());
        this.triggerTextField.setText(this.peripheralJob.getPeripheralOperation().getExecutionTrigger().name());
        this.requireCompletionTextField.setText(String.valueOf(this.peripheralJob.getPeripheralOperation().isCompletionRequired()));
        this.propertiesTable.setModel(this.createPropertiesTableModel());
        this.historyTable.setModel(this.createHistoryTableModel());
        this.historyTable.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.historyTable.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.historyTable.getColumnModel().getColumn(1).setCellRenderer(new ToolTipCellRenderer());
    }

    private TableModel createPropertiesTableModel() {
        UneditableTableModel tableModel = new UneditableTableModel();
        tableModel.setColumnIdentifiers(new String[]{ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.peripheralJobDetail").getString("peripheralJobView.table_properties.column_propertiesKey.headerText"), ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.peripheralJobDetail").getString("peripheralJobView.table_properties.column_propertiesValue.headerText")});
        this.peripheralJob.getProperties().entrySet().stream().sorted((e1, e2) -> ((String)e1.getKey()).compareTo((String)e2.getKey())).forEach(entry -> tableModel.addRow(new String[]{(String)entry.getKey(), (String)entry.getValue()}));
        return tableModel;
    }

    private TableModel createHistoryTableModel() {
        UneditableTableModel tableModel = new UneditableTableModel();
        tableModel.setColumnIdentifiers(new String[]{ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.peripheralJobDetail").getString("peripheralJobView.table_history.column_timestamp.headerText"), ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.peripheralJobDetail").getString("peripheralJobView.table_history.column_event.headerText")});
        for (ObjectHistory.Entry entry : this.peripheralJob.getHistory().getEntries()) {
            tableModel.addRow(new String[]{TIMESTAMP_FORMAT.format(Date.from(entry.getTimestamp())), (String)((Optional)this.historyEntryFormatter.apply((Object)entry)).get()});
        }
        return tableModel;
    }

    private void initComponents() {
        this.generalPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.createdLabel = new JLabel();
        this.createdTextField = new JTextField();
        this.finishedLabel = new JLabel();
        this.finishedTextField = new JTextField();
        this.vehicleLabel = new JLabel();
        this.vehicleTextField = new JTextField();
        this.reservationTokenLabel = new JLabel();
        this.reservationTokenTextField = new JTextField();
        this.relatedTransportOrderLabel = new JLabel();
        this.relatedTransportOrderTextField = new JTextField();
        this.stateLabel = new JLabel();
        this.stateTextField = new JTextField();
        this.propertiesPanel = new JPanel();
        this.propertiesScrollPane = new JScrollPane();
        this.propertiesTable = new JTable();
        this.historyPanel = new JPanel();
        this.historyScrollPane = new JScrollPane();
        this.historyTable = new JTable();
        this.operationPanel = new JPanel();
        this.locationLabel = new JLabel();
        this.locationTextField = new JTextField();
        this.triggerLabel = new JLabel();
        this.triggerTextField = new JTextField();
        this.requireCompletionLabel = new JLabel();
        this.requireCompletionTextField = new JTextField();
        this.operationLabel = new JLabel();
        this.operationTextField = new JTextField();
        this.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("i18n/org/opentcs/plantoverview/operating/dialogs/peripheralJobDetail");
        this.generalPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("peripheralJobView.panel_general.border.title")));
        this.generalPanel.setLayout(new GridBagLayout());
        this.nameLabel.setFont(this.nameLabel.getFont());
        this.nameLabel.setText(bundle.getString("peripheralJobView.panel_general.label_name.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.generalPanel.add((Component)this.nameLabel, gridBagConstraints);
        this.nameTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.generalPanel.add((Component)this.nameTextField, gridBagConstraints);
        this.createdLabel.setFont(this.createdLabel.getFont());
        this.createdLabel.setText(bundle.getString("peripheralJobView.panel_general.label_created.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.generalPanel.add((Component)this.createdLabel, gridBagConstraints);
        this.createdTextField.setEditable(false);
        this.createdTextField.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.generalPanel.add((Component)this.createdTextField, gridBagConstraints);
        this.finishedLabel.setFont(this.finishedLabel.getFont());
        this.finishedLabel.setText(bundle.getString("peripheralJobView.panel_general.label_finished.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 4);
        this.generalPanel.add((Component)this.finishedLabel, gridBagConstraints);
        this.finishedTextField.setEditable(false);
        this.finishedTextField.setColumns(12);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.generalPanel.add((Component)this.finishedTextField, gridBagConstraints);
        this.vehicleLabel.setFont(this.vehicleLabel.getFont());
        this.vehicleLabel.setText(bundle.getString("peripheralJobView.panel_general.label_vehicle.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.generalPanel.add((Component)this.vehicleLabel, gridBagConstraints);
        this.vehicleTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.generalPanel.add((Component)this.vehicleTextField, gridBagConstraints);
        this.reservationTokenLabel.setText(bundle.getString("peripheralJobView.panel_general.label_reservationToken.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.generalPanel.add((Component)this.reservationTokenLabel, gridBagConstraints);
        this.reservationTokenTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.generalPanel.add((Component)this.reservationTokenTextField, gridBagConstraints);
        this.relatedTransportOrderLabel.setText(bundle.getString("peripheralJobView.panel_general.label_transportOrder.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.generalPanel.add((Component)this.relatedTransportOrderLabel, gridBagConstraints);
        this.relatedTransportOrderTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.generalPanel.add((Component)this.relatedTransportOrderTextField, gridBagConstraints);
        this.stateLabel.setText(bundle.getString("peripheralJobView.panel_general.label_state.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 4);
        this.generalPanel.add((Component)this.stateLabel, gridBagConstraints);
        this.stateTextField.setEditable(false);
        this.stateTextField.setColumns(14);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.generalPanel.add((Component)this.stateTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        this.add(this.generalPanel, gridBagConstraints);
        this.propertiesPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("peripheralJobView.panel_properties.border.title")));
        this.propertiesPanel.setLayout(new BorderLayout());
        this.propertiesScrollPane.setPreferredSize(new Dimension(150, 100));
        this.propertiesTable.setFont(this.propertiesTable.getFont());
        this.propertiesScrollPane.setViewportView(this.propertiesTable);
        this.propertiesPanel.add((Component)this.propertiesScrollPane, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.add(this.propertiesPanel, gridBagConstraints);
        this.historyPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("peripheralJobView.panel_history.border.title")));
        this.historyPanel.setLayout(new BorderLayout());
        this.historyScrollPane.setPreferredSize(new Dimension(150, 100));
        this.historyTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.historyScrollPane.setViewportView(this.historyTable);
        this.historyPanel.add((Component)this.historyScrollPane, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.add(this.historyPanel, gridBagConstraints);
        this.operationPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("peripheralJobView.panel_operation.border.title")));
        this.operationPanel.setLayout(new GridBagLayout());
        this.locationLabel.setFont(this.locationLabel.getFont());
        this.locationLabel.setText(bundle.getString("peripheralJobView.panel_operation.lable_location.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.operationPanel.add((Component)this.locationLabel, gridBagConstraints);
        this.locationTextField.setEditable(false);
        this.locationTextField.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.operationPanel.add((Component)this.locationTextField, gridBagConstraints);
        this.triggerLabel.setFont(this.triggerLabel.getFont());
        this.triggerLabel.setText(bundle.getString("peripheralJobView.panel_operation.lable_trigger.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.operationPanel.add((Component)this.triggerLabel, gridBagConstraints);
        this.triggerTextField.setEditable(false);
        this.triggerTextField.setColumns(14);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.operationPanel.add((Component)this.triggerTextField, gridBagConstraints);
        this.requireCompletionLabel.setFont(this.requireCompletionLabel.getFont());
        this.requireCompletionLabel.setText(bundle.getString("peripheralJobView.panel_operation.lable_requireCompletion.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 4);
        this.operationPanel.add((Component)this.requireCompletionLabel, gridBagConstraints);
        this.requireCompletionTextField.setEditable(false);
        this.requireCompletionTextField.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.operationPanel.add((Component)this.requireCompletionTextField, gridBagConstraints);
        this.operationLabel.setText(bundle.getString("peripheralJobView.panel_operation.lable_operation.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 0, 4);
        this.operationPanel.add((Component)this.operationLabel, gridBagConstraints);
        this.operationTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.operationPanel.add((Component)this.operationTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        this.add(this.operationPanel, gridBagConstraints);
    }

    private static class ToolTipCellRenderer
    extends DefaultTableCellRenderer {
        ToolTipCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ((JComponent)component).setToolTipText(value.toString());
            return component;
        }
    }
}

