/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.operationsdesk.peripherals.jobs;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import org.opentcs.access.KernelRuntimeException;
import org.opentcs.access.SharedKernelServicePortal;
import org.opentcs.access.SharedKernelServicePortalProvider;
import org.opentcs.components.Lifecycle;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.data.TCSObjectEvent;
import org.opentcs.data.peripherals.PeripheralJob;
import org.opentcs.guing.common.event.OperationModeChangeEvent;
import org.opentcs.guing.common.event.SystemModelTransitionEvent;
import org.opentcs.operationsdesk.event.KernelStateChangeEvent;
import org.opentcs.operationsdesk.peripherals.jobs.PeripheralJobsContainerListener;
import org.opentcs.util.event.EventBus;
import org.opentcs.util.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeripheralJobsContainer
implements EventHandler,
Lifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(PeripheralJobsContainer.class);
    private final EventBus eventBus;
    private final SharedKernelServicePortalProvider portalProvider;
    private final Map<String, PeripheralJob> peripheralJobs = new HashMap<String, PeripheralJob>();
    private final Set<PeripheralJobsContainerListener> listeners = new HashSet<PeripheralJobsContainerListener>();
    private boolean initialized;

    @Inject
    public PeripheralJobsContainer(@ApplicationEventBus EventBus eventBus, SharedKernelServicePortalProvider portalProvider) {
        this.eventBus = Objects.requireNonNull(eventBus, "eventBus");
        this.portalProvider = Objects.requireNonNull(portalProvider, "portalProvider");
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize() {
        if (this.isInitialized()) {
            return;
        }
        this.eventBus.subscribe((EventHandler)this);
        this.initialized = true;
    }

    public void terminate() {
        if (!this.isInitialized()) {
            return;
        }
        this.eventBus.unsubscribe((EventHandler)this);
        this.initialized = false;
    }

    public void onEvent(Object event) {
        if (event instanceof TCSObjectEvent) {
            this.handleObjectEvent((TCSObjectEvent)event);
        } else if (event instanceof OperationModeChangeEvent) {
            this.initJobs();
        } else if (event instanceof SystemModelTransitionEvent) {
            this.initJobs();
        } else if (event instanceof KernelStateChangeEvent) {
            this.initJobs();
        }
    }

    public void addListener(PeripheralJobsContainerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(PeripheralJobsContainerListener listener) {
        this.listeners.remove(listener);
    }

    public Collection<PeripheralJob> getPeripheralJobs() {
        return this.peripheralJobs.values();
    }

    private void initJobs() {
        this.setPeripheralJobs(this.fetchJobsIfOnline());
        this.listeners.forEach(listener -> listener.containerInitialized(this.peripheralJobs.values()));
    }

    private void handleObjectEvent(TCSObjectEvent evt) {
        if (evt.getCurrentOrPreviousObjectState() instanceof PeripheralJob) {
            switch (evt.getType()) {
                case OBJECT_CREATED: {
                    this.peripheralJobAdded((PeripheralJob)evt.getCurrentOrPreviousObjectState());
                    break;
                }
                case OBJECT_MODIFIED: {
                    this.peripheralJobChanged((PeripheralJob)evt.getCurrentOrPreviousObjectState());
                    break;
                }
                case OBJECT_REMOVED: {
                    this.peripheralJobRemoved((PeripheralJob)evt.getCurrentOrPreviousObjectState());
                    break;
                }
                default: {
                    LOG.warn("Unhandled event type: {}", (Object)evt.getType());
                }
            }
        }
    }

    private void peripheralJobAdded(PeripheralJob job) {
        this.peripheralJobs.put(job.getName(), job);
        this.listeners.forEach(listener -> listener.peripheralJobAdded(job));
    }

    private void peripheralJobChanged(PeripheralJob job) {
        this.peripheralJobs.put(job.getName(), job);
        this.listeners.forEach(listener -> listener.peripheralJobUpdated(job));
    }

    private void peripheralJobRemoved(PeripheralJob job) {
        this.peripheralJobs.remove(job.getName());
        this.listeners.forEach(listener -> listener.peripheralJobRemoved(job));
    }

    private void setPeripheralJobs(Set<PeripheralJob> newJobs) {
        this.peripheralJobs.clear();
        for (PeripheralJob job : newJobs) {
            this.peripheralJobs.put(job.getName(), job);
        }
    }

    private Set<PeripheralJob> fetchJobsIfOnline() {
        if (this.portalProvider.portalShared()) {
            Set set;
            block9: {
                SharedKernelServicePortal sharedPortal = this.portalProvider.register();
                try {
                    set = sharedPortal.getPortal().getPeripheralJobService().fetchObjects(PeripheralJob.class);
                    if (sharedPortal == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (sharedPortal != null) {
                            try {
                                sharedPortal.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (KernelRuntimeException exc) {
                        LOG.warn("Exception fetching peripheral jobs", (Throwable)exc);
                    }
                }
                sharedPortal.close();
            }
            return set;
        }
        return new HashSet<PeripheralJob>();
    }
}

