/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.operationsdesk.peripherals.jobs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import org.opentcs.access.KernelRuntimeException;
import org.opentcs.access.SharedKernelServicePortal;
import org.opentcs.access.SharedKernelServicePortalProvider;
import org.opentcs.data.peripherals.PeripheralJob;
import org.opentcs.guing.common.components.dialogs.DialogContent;
import org.opentcs.guing.common.components.dialogs.StandardContentDialog;
import org.opentcs.guing.common.util.IconToolkit;
import org.opentcs.operationsdesk.peripherals.jobs.PeripheralJobTableModel;
import org.opentcs.operationsdesk.peripherals.jobs.PeripheralJobView;
import org.opentcs.operationsdesk.peripherals.jobs.PeripheralJobViewFactory;
import org.opentcs.operationsdesk.peripherals.jobs.PeripheralJobsContainer;
import org.opentcs.thirdparty.guing.common.jhotdraw.util.ResourceBundleUtil;
import org.opentcs.util.gui.StringTableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeripheralJobsContainerPanel
extends JPanel {
    private static final Logger LOG = LoggerFactory.getLogger(PeripheralJobsContainerPanel.class);
    private static final String ICON_PATH = "/org/opentcs/guing/res/symbols/panel/";
    private final SharedKernelServicePortalProvider portalProvider;
    private final PeripheralJobsContainer peripheralJobsContainer;
    private final PeripheralJobViewFactory peripheralJobViewFactory;
    private JTable table;
    private PeripheralJobTableModel tableModel;

    @Inject
    public PeripheralJobsContainerPanel(SharedKernelServicePortalProvider portalProvider, PeripheralJobsContainer peripheralJobsContainer, PeripheralJobViewFactory peripheralJobViewFactory) {
        this.portalProvider = Objects.requireNonNull(portalProvider, "portalProvider");
        this.peripheralJobsContainer = Objects.requireNonNull(peripheralJobsContainer, "peripheralJobsContainer");
        this.peripheralJobViewFactory = Objects.requireNonNull(peripheralJobViewFactory, "peripheralJobViewFactory");
        this.initComponents();
    }

    public void initView() {
        this.tableModel.containerInitialized(this.peripheralJobsContainer.getPeripheralJobs());
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.initPeripheralJobTable();
        this.add((Component)new JScrollPane(this.table), "Center");
        this.add((Component)this.createToolBar(), "North");
    }

    private void initPeripheralJobTable() {
        this.tableModel = new PeripheralJobTableModel();
        this.peripheralJobsContainer.addListener(this.tableModel);
        this.table = new JTable(this.tableModel);
        TableRowSorter<PeripheralJobTableModel> sorter = new TableRowSorter<PeripheralJobTableModel>(this.tableModel);
        sorter.setSortKeys(Arrays.asList(new RowSorter.SortKey(6, SortOrder.DESCENDING)));
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            sorter.setSortable(i, false);
        }
        sorter.setSortsOnUpdates(true);
        this.table.setRowSorter(sorter);
        this.table.removeColumn(this.table.getColumnModel().getColumn(this.table.convertColumnIndexToView(6)));
        StringTableCellRenderer renderer = new StringTableCellRenderer(reference -> {
            if (reference == null) {
                return "-";
            }
            return reference.getName();
        });
        this.table.getColumnModel().getColumn(3).setCellRenderer((TableCellRenderer)renderer);
        this.table.getColumnModel().getColumn(4).setCellRenderer((TableCellRenderer)renderer);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getButton() == 1 && evt.getClickCount() == 2) {
                    PeripheralJobsContainerPanel.this.showSelectedJob();
                }
                if (evt.getButton() == 3 && PeripheralJobsContainerPanel.this.table.getSelectedRow() != -1) {
                    PeripheralJobsContainerPanel.this.showPopupMenuForSelectedJob(evt.getX(), evt.getY());
                }
            }
        });
    }

    private JToolBar createToolBar() {
        JToolBar toolBar = new JToolBar();
        JButton button = new JButton(IconToolkit.instance().getImageIconByFullPath("/org/opentcs/guing/res/symbols/panel/table-row-delete-2.16x16.png"));
        button.addActionListener(e -> this.withdrawSelectedJobs());
        button.setToolTipText(ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.panels.peripheralJobs").getString("peripheralJobsContainerPanel.button_withdrawSelectedJobs.tooltipText"));
        toolBar.add(button);
        return toolBar;
    }

    private void showSelectedJob() {
        this.getSelectedJob().ifPresent(job -> {
            PeripheralJobView content = this.peripheralJobViewFactory.createPeripheralJobView((PeripheralJob)job);
            StandardContentDialog dialog = new StandardContentDialog((Component)JOptionPane.getFrameForComponent(this), (DialogContent)content, true, 12);
            dialog.setVisible(true);
        });
    }

    private Optional<PeripheralJob> getSelectedJob() {
        int rowIndex = this.table.getSelectedRow();
        if (rowIndex == -1) {
            return Optional.empty();
        }
        return Optional.of(this.tableModel.getEntryAt(this.table.convertRowIndexToModel(rowIndex)));
    }

    private void showPopupMenuForSelectedJob(int x, int y) {
        boolean singleRowSelected = this.table.getSelectedRowCount() <= 1;
        ResourceBundleUtil bundle = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.panels.peripheralJobs");
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = menu.add(bundle.getString("peripheralJobsContainerPanel.table_peripheralJobs.popupMenuItem_showDetails.text"));
        item.setEnabled(singleRowSelected);
        item.addActionListener(event -> this.showSelectedJob());
        menu.show(this.table, x, y);
    }

    private void withdrawSelectedJobs() {
        ArrayList<PeripheralJob> toBeWithdrawn = new ArrayList<PeripheralJob>();
        for (int i : this.table.getSelectedRows()) {
            toBeWithdrawn.add(this.tableModel.getEntryAt(this.table.convertRowIndexToModel(i)));
        }
        try (SharedKernelServicePortal sharedPortal = this.portalProvider.register();){
            for (PeripheralJob job : toBeWithdrawn) {
                sharedPortal.getPortal().getPeripheralDispatcherService().withdrawByPeripheralJob(job.getReference());
            }
        }
        catch (IllegalArgumentException | KernelRuntimeException exc) {
            LOG.warn("Exception withdrawing transport order", exc);
        }
    }
}

