/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.operationsdesk.transport;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.opentcs.access.to.peripherals.PeripheralOperationCreationTO;
import org.opentcs.data.model.PeripheralInformation;
import org.opentcs.guing.base.model.elements.LocationModel;
import org.opentcs.guing.common.components.dialogs.DialogContent;
import org.opentcs.guing.common.persistence.ModelManager;
import org.opentcs.util.gui.StringListCellRenderer;

public class CreatePeripheralJobPanel
extends DialogContent {
    private static final Comparator<LocationModel> BY_NAME = (o1, o2) -> o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
    private final ResourceBundle bundle = ResourceBundle.getBundle("i18n.org.opentcs.plantoverview.operating.dialogs.createPeripheralJob");
    private final List<LocationModel> locations;
    private JComboBox<LocationModel> locationCombobox;
    private JLabel locationLabel;
    private JComboBox<String> operationCombobox;
    private JLabel operationLabel;
    private JLabel reservationTokenLabel;
    private JTextField reservationTokenTextField;

    @Inject
    public CreatePeripheralJobPanel(ModelManager modelManager) {
        Objects.requireNonNull(modelManager, "modelManager");
        this.locations = modelManager.getModel().getLocationModels().stream().filter(location -> !Objects.equals(location.getPropertyPeripheralState().getText(), PeripheralInformation.State.NO_PERIPHERAL.name())).sorted(BY_NAME).collect(Collectors.toList());
        this.initComponents();
        this.setDialogTitle(this.bundle.getString("createPeripheralJobPanel.title"));
    }

    public void initFields() {
        this.locations.stream().forEach(this.locationCombobox::addItem);
        this.loadOperations();
    }

    public void update() {
        this.updateFailed = false;
        if (this.reservationTokenTextField.getText().isEmpty()) {
            this.updateFailed = true;
            JOptionPane.showMessageDialog((Component)((Object)this), this.bundle.getString("createPeripheralJobPanel.optionPane_reserveTokenEmpty.message"), this.bundle.getString("createPeripheralJobPanel.optionPane_reserveTokenEmpty.title"), 0);
        }
        if (this.locationCombobox.getSelectedItem() == null || this.operationCombobox.getSelectedItem() == null) {
            this.updateFailed = true;
            JOptionPane.showMessageDialog((Component)((Object)this), this.bundle.getString("createPeripheralJobPanel.optionPane_invalidOperation.message"), this.bundle.getString("createPeripheralJobPanel.optionPane_invalidOperation.title"), 0);
        }
    }

    private void loadOperations() {
        LocationModel location = (LocationModel)this.locationCombobox.getSelectedItem();
        if (location == null) {
            return;
        }
        this.operationCombobox.removeAllItems();
        for (String op : location.getLocationType().getPropertyAllowedPeripheralOperations().getItems()) {
            this.operationCombobox.addItem(op);
        }
    }

    public String getReservationToken() {
        return this.reservationTokenTextField.getText();
    }

    public PeripheralOperationCreationTO getPeripheralOperation() {
        return new PeripheralOperationCreationTO((String)this.operationCombobox.getSelectedItem(), ((LocationModel)this.locationCombobox.getSelectedItem()).getName());
    }

    private void initComponents() {
        this.reservationTokenLabel = new JLabel();
        this.reservationTokenTextField = new JTextField();
        this.locationLabel = new JLabel();
        this.locationCombobox = new JComboBox();
        this.operationLabel = new JLabel();
        this.operationCombobox = new JComboBox();
        ResourceBundle bundle = ResourceBundle.getBundle("i18n/org/opentcs/plantoverview/operating/dialogs/createPeripheralJob");
        this.setBorder(BorderFactory.createTitledBorder(bundle.getString("createPeripheralJobPanel.border.title")));
        this.setLayout(new GridBagLayout());
        this.reservationTokenLabel.setText(bundle.getString("createPeripheralJobPanel.label_reservationToken.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.add(this.reservationTokenLabel, gridBagConstraints);
        this.reservationTokenTextField.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.reservationTokenTextField, gridBagConstraints);
        this.locationLabel.setText(bundle.getString("createPeripheralJobPanel.label_location.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.add(this.locationLabel, gridBagConstraints);
        this.locationCombobox.setPreferredSize(new Dimension(150, 20));
        this.locationCombobox.setRenderer((ListCellRenderer<LocationModel>)new StringListCellRenderer(location -> location != null ? location.getName() : ""));
        this.locationCombobox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                CreatePeripheralJobPanel.this.locationComboboxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.locationCombobox, gridBagConstraints);
        this.operationLabel.setText(bundle.getString("createPeripheralJobPanel.label_operation.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.add(this.operationLabel, gridBagConstraints);
        this.operationCombobox.setPreferredSize(new Dimension(150, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.operationCombobox, gridBagConstraints);
    }

    private void locationComboboxItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.loadOperations();
        }
    }
}

