/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.operationsdesk.transport;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.opentcs.guing.base.model.ModelComponent;
import org.opentcs.guing.base.model.elements.LocationModel;
import org.opentcs.guing.base.model.elements.LocationTypeModel;
import org.opentcs.guing.common.components.dialogs.DialogContent;
import org.opentcs.thirdparty.guing.common.jhotdraw.util.ResourceBundleUtil;

public class LocationActionPanel
extends DialogContent {
    protected List<LocationModel> fLocations;
    protected List<String> fActions;
    private JComboBox<String> actionsComboBox;
    private JLabel actionsLabel;
    private JComboBox<String> locationsComboBox;
    private JLabel locationsLabel;

    public LocationActionPanel(List<LocationModel> locations) {
        this.fLocations = Objects.requireNonNull(locations, "locations");
        this.initComponents();
        this.setDialogTitle(ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.vehiclePopup").getString("locationActionPanel.title"));
        Collections.sort(this.fLocations, this.getComparator());
        List names = this.fLocations.stream().map(location -> location.getName()).collect(Collectors.toList());
        this.locationsComboBox.setModel(new DefaultComboBoxModel(new Vector(names)));
        this.updateActions();
    }

    protected final Comparator<ModelComponent> getComparator() {
        return (item1, item2) -> {
            String s1 = item1.getName();
            String s2 = item2.getName();
            s1 = s1.toLowerCase();
            s2 = s2.toLowerCase();
            return s1.compareTo(s2);
        };
    }

    public LocationModel getSelectedLocation() {
        int index = this.locationsComboBox.getSelectedIndex();
        if (index == -1) {
            return null;
        }
        return this.fLocations.get(index);
    }

    public String getSelectedAction() {
        int index = this.actionsComboBox.getSelectedIndex();
        if (index == -1) {
            return null;
        }
        return this.fActions.get(index);
    }

    private void updateActions() {
        LocationModel selectedLocation = this.getSelectedLocation();
        LocationTypeModel locationType = selectedLocation.getLocationType();
        List actions = locationType.getPropertyAllowedOperations().getItems();
        Collections.sort(actions);
        this.fActions = new ArrayList<String>();
        this.fActions.add("NOP");
        this.fActions.addAll(actions);
        this.actionsComboBox.setModel(new DefaultComboBoxModel<String>(new Vector<String>(this.fActions)));
    }

    public void update() {
    }

    public void initFields() {
    }

    private void initComponents() {
        this.locationsLabel = new JLabel();
        this.locationsComboBox = new JComboBox();
        this.actionsLabel = new JLabel();
        this.actionsComboBox = new JComboBox();
        this.setPreferredSize(new Dimension(150, 40));
        this.setLayout(new GridBagLayout());
        this.locationsLabel.setFont(this.locationsLabel.getFont());
        ResourceBundle bundle = ResourceBundle.getBundle("i18n/org/opentcs/plantoverview/operating/dialogs/vehiclePopup");
        this.locationsLabel.setText(bundle.getString("locationActionPanel.label_location.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add(this.locationsLabel, gridBagConstraints);
        this.locationsComboBox.setFont(this.locationsComboBox.getFont());
        this.locationsComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                LocationActionPanel.this.locationsComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        this.add(this.locationsComboBox, gridBagConstraints);
        this.actionsLabel.setFont(this.actionsLabel.getFont());
        this.actionsLabel.setText(bundle.getString("locationActionPanel.label_action.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add(this.actionsLabel, gridBagConstraints);
        this.actionsComboBox.setFont(this.actionsComboBox.getFont());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.add(this.actionsComboBox, gridBagConstraints);
    }

    private void locationsComboBoxItemStateChanged(ItemEvent evt) {
        this.updateActions();
    }
}

