/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.operationsdesk.transport;

import java.util.Objects;
import java.util.Optional;
import org.opentcs.components.plantoverview.ObjectHistoryEntryFormatter;
import org.opentcs.data.ObjectHistory;
import org.opentcs.thirdparty.guing.common.jhotdraw.util.ResourceBundleUtil;

public class TransportOrderHistoryEntryFormatter
implements ObjectHistoryEntryFormatter {
    private final ResourceBundleUtil bundle = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.transportOrderDetail");

    public Optional<String> apply(ObjectHistory.Entry entry) {
        Objects.requireNonNull(entry, "entry");
        switch (entry.getEventCode()) {
            case "tcsHistory:orderCreated": {
                return Optional.of(this.bundle.getString("transportOrderHistoryEntryFormatter.code_orderCreated.text"));
            }
            case "tcsHistory:orderDispatchingDeferred": {
                return Optional.of(this.bundle.getString("transportOrderHistoryEntryFormatter.code_orderDispatchingDeferred.text") + " " + entry.getSupplement().toString());
            }
            case "tcsHistory:orderDispatchingResumed": {
                return Optional.of(this.bundle.getString("transportOrderHistoryEntryFormatter.code_orderDispatchingResumed.text"));
            }
            case "tcsHistory:orderAssignedToVehicle": {
                return Optional.of(this.bundle.getString("transportOrderHistoryEntryFormatter.code_orderAssignedToVehicle.text") + " '" + entry.getSupplement().toString() + "'");
            }
            case "tcsHistory:orderReservedForVehicle": {
                return Optional.of(this.bundle.getString("transportOrderHistoryEntryFormatter.code_orderReservedForVehicle.text") + " '" + entry.getSupplement().toString() + "'");
            }
            case "tcsHistory:orderProcVehicleChanged": {
                return Optional.of(this.bundle.getString("transportOrderHistoryEntryFormatter.code_orderProcVehicleChanged.text") + " '" + entry.getSupplement().toString() + "'");
            }
            case "tcsHistory:orderFinishedDriveOrder": {
                return Optional.of(this.bundle.getString("transportOrderHistoryEntryFormatter.code_driveOrderFinished.text"));
            }
            case "tcsHistory:orderReachedFinalState": {
                return Optional.of(this.bundle.getString("transportOrderHistoryEntryFormatter.code_orderReachedFinalState.text"));
            }
        }
        return Optional.empty();
    }
}

