/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.operationsdesk.transport.orders;

import java.time.Instant;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.opentcs.data.order.DriveOrder;
import org.opentcs.data.order.TransportOrder;
import org.opentcs.operationsdesk.transport.orders.TransportOrderContainerListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportOrderTableModel
extends AbstractTableModel
implements TransportOrderContainerListener {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_SOURCE = 1;
    public static final int COLUMN_DESTINATION = 2;
    public static final int COLUMN_INTENDED_VEHICLE = 3;
    public static final int COLUMN_EXECUTING_VEHICLE = 4;
    public static final int COLUMN_STATUS = 5;
    public static final int COLUMN_ORDER_SEQUENCE = 6;
    public static final int COLUMN_CREATION_TIME = 7;
    private static final Logger LOG = LoggerFactory.getLogger(TransportOrderTableModel.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("i18n.org.opentcs.plantoverview.operating.panels.transportOrders");
    private static final String[] COLUMN_NAMES = new String[]{"Name", BUNDLE.getString("transportOrderTableModel.column_source.headerText"), BUNDLE.getString("transportOrderTableModel.column_destination.headerText"), BUNDLE.getString("transportOrderTableModel.column_intendedVehicle.headerText"), BUNDLE.getString("transportOrderTableModel.column_executingVehicle.headerText"), "Status", BUNDLE.getString("transportOrderTableModel.column_orderSequence.headerText"), BUNDLE.getString("transportOrderTableModel.column_creationTime.headerText")};
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, Instant.class};
    private final List<TransportOrder> entries = new LinkedList<TransportOrder>();

    @Override
    public int getRowCount() {
        return this.entries.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.getRowCount()) {
            return null;
        }
        TransportOrder entry = this.entries.get(rowIndex);
        Vector driveOrders = new Vector(entry.getAllDriveOrders());
        switch (columnIndex) {
            case 0: {
                return entry.getName();
            }
            case 1: {
                if (driveOrders.size() == 1) {
                    return "";
                }
                return ((DriveOrder)driveOrders.firstElement()).getDestination().getDestination().getName();
            }
            case 2: {
                return ((DriveOrder)driveOrders.lastElement()).getDestination().getDestination().getName();
            }
            case 3: {
                if (entry.getIntendedVehicle() != null) {
                    return entry.getIntendedVehicle().getName();
                }
                return BUNDLE.getString("transportOrderTableModel.column_intendedVehicle.determinedAutomatic.text");
            }
            case 4: {
                if (entry.getProcessingVehicle() != null) {
                    return entry.getProcessingVehicle().getName();
                }
                return "?";
            }
            case 5: {
                return entry.getState().toString();
            }
            case 6: {
                if (entry.getWrappingSequence() != null) {
                    return entry.getWrappingSequence().getName();
                }
                return "-";
            }
            case 7: {
                return entry.getCreationTime();
            }
        }
        throw new IllegalArgumentException("Invalid column index: " + columnIndex);
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_CLASSES[columnIndex];
    }

    @Override
    public void containerInitialized(Collection<TransportOrder> orders) {
        Objects.requireNonNull(orders, "orders");
        SwingUtilities.invokeLater(() -> {
            this.entries.clear();
            this.entries.addAll(orders);
            this.fireTableDataChanged();
        });
    }

    @Override
    public void transportOrderAdded(TransportOrder order) {
        Objects.requireNonNull(order, "order");
        SwingUtilities.invokeLater(() -> {
            this.entries.add(order);
            this.fireTableRowsInserted(this.entries.size() - 1, this.entries.size() - 1);
        });
    }

    @Override
    public void transportOrderUpdated(TransportOrder order) {
        Objects.requireNonNull(order, "order");
        SwingUtilities.invokeLater(() -> {
            int orderIndex = this.entries.indexOf(order);
            if (orderIndex == -1) {
                LOG.warn("Unknown transport order: {}. Ignoring order update.", (Object)order.getName());
                return;
            }
            this.entries.set(orderIndex, order);
            this.fireTableRowsUpdated(orderIndex, orderIndex);
        });
    }

    @Override
    public void transportOrderRemoved(TransportOrder order) {
        Objects.requireNonNull(order, "order");
        SwingUtilities.invokeLater(() -> {
            int orderIndex = this.entries.indexOf(order);
            if (orderIndex == -1) {
                LOG.warn("Unknown transport order: {}. Ignoring order removal.", (Object)order.getName());
                return;
            }
            this.entries.remove(orderIndex);
            this.fireTableRowsDeleted(orderIndex, orderIndex);
        });
    }

    public TransportOrder getEntryAt(int index) {
        if (index < 0 || index >= this.entries.size()) {
            return null;
        }
        return this.entries.get(index);
    }
}

