/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.operationsdesk.transport.sequences;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.opentcs.data.order.OrderSequence;
import org.opentcs.operationsdesk.transport.sequences.OrderSequenceContainerListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderSequenceTableModel
extends AbstractTableModel
implements OrderSequenceContainerListener {
    private static final Logger LOG = LoggerFactory.getLogger(OrderSequenceTableModel.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("i18n.org.opentcs.plantoverview.operating.panels.orderSequences");
    private static final int COLUMN_NAME = 0;
    private static final int COLUMN_INTENDED_VEHICLE = 1;
    private static final int COLUMN_EXECUTING_VEHICLE = 2;
    private static final int COLUMN_INDEX = 3;
    private static final int COLUMN_COMPLETED = 4;
    private static final int COLUMN_FINISHED = 5;
    private static final int COLUMN_FAILURE = 6;
    private static final String[] COLUMN_NAMES = new String[]{"Name", BUNDLE.getString("orderSequenceTableModel.column_intendedVehicle.headerText"), BUNDLE.getString("orderSequenceTableModel.column_executingVehicle.headerText"), "Index", BUNDLE.getString("orderSequenceTableModel.column_complete.headerText"), BUNDLE.getString("orderSequenceTableModel.column_finished.headerText"), BUNDLE.getString("orderSequenceTableModel.column_failureFatal.headerText")};
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class};
    private final List<OrderSequence> entries = new LinkedList<OrderSequence>();

    @Override
    public int getRowCount() {
        return this.entries.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.entries.size()) {
            return null;
        }
        OrderSequence entry = this.entries.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return entry.getName();
            }
            case 1: {
                if (entry.getIntendedVehicle() != null) {
                    return entry.getIntendedVehicle().getName();
                }
                return BUNDLE.getString("orderSequenceTableModel.column_intendedVehicle.determinedAutomatic.text");
            }
            case 2: {
                if (entry.getProcessingVehicle() != null) {
                    return entry.getProcessingVehicle().getName();
                }
                return BUNDLE.getString("orderSequenceTableModel.column_intendedVehicle.determinedAutomatic.text");
            }
            case 3: {
                return entry.getFinishedIndex();
            }
            case 4: {
                return entry.isComplete();
            }
            case 5: {
                return entry.isFinished();
            }
            case 6: {
                return entry.isFailureFatal();
            }
        }
        throw new IllegalArgumentException("Invalid column index: " + columnIndex);
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_CLASSES[columnIndex];
    }

    @Override
    public void containerInitialized(Collection<OrderSequence> sequences) {
        Objects.requireNonNull(sequences, "sequences");
        SwingUtilities.invokeLater(() -> {
            this.entries.clear();
            this.entries.addAll(sequences);
            this.fireTableDataChanged();
        });
    }

    @Override
    public void orderSequenceAdded(OrderSequence sequence) {
        Objects.requireNonNull(sequence, "sequence");
        SwingUtilities.invokeLater(() -> {
            this.entries.add(sequence);
            this.fireTableRowsInserted(this.entries.size() - 1, this.entries.size() - 1);
        });
    }

    @Override
    public void orderSequenceUpdated(OrderSequence sequence) {
        Objects.requireNonNull(sequence, "sequence");
        SwingUtilities.invokeLater(() -> {
            int sequenceIndex = this.entries.indexOf(sequence);
            if (sequenceIndex == -1) {
                LOG.warn("Unknown order sequence: {}. Ignoring order sequence update.", (Object)sequence.getName());
                return;
            }
            this.entries.set(sequenceIndex, sequence);
            this.fireTableRowsUpdated(sequenceIndex, sequenceIndex);
        });
    }

    @Override
    public void orderSequenceRemoved(OrderSequence sequence) {
        Objects.requireNonNull(sequence, "sequence");
        SwingUtilities.invokeLater(() -> {
            int sequenceIndex = this.entries.indexOf(sequence);
            if (sequenceIndex == -1) {
                LOG.warn("Unknown order sequence: {}. Ignoring order sequence removal.", (Object)sequence.getName());
                return;
            }
            this.entries.remove(sequenceIndex);
            this.fireTableRowsDeleted(sequenceIndex, sequenceIndex);
        });
    }

    public OrderSequence getEntryAt(int index) {
        if (index < 0 || index >= this.entries.size()) {
            return null;
        }
        return this.entries.get(index);
    }
}

