/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.operationsdesk.transport.sequences;

import com.google.inject.assistedinject.Assisted;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.opentcs.access.KernelRuntimeException;
import org.opentcs.access.SharedKernelServicePortal;
import org.opentcs.access.SharedKernelServicePortalProvider;
import org.opentcs.components.plantoverview.ObjectHistoryEntryFormatter;
import org.opentcs.data.ObjectHistory;
import org.opentcs.data.TCSObjectReference;
import org.opentcs.data.order.OrderSequence;
import org.opentcs.guing.common.components.dialogs.DialogContent;
import org.opentcs.operationsdesk.transport.CompositeObjectHistoryEntryFormatter;
import org.opentcs.operationsdesk.transport.UneditableTableModel;
import org.opentcs.thirdparty.guing.common.jhotdraw.util.ResourceBundleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderSequenceView
extends DialogContent {
    private static final Logger LOG = LoggerFactory.getLogger(OrderSequenceView.class);
    private static final DateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private final OrderSequence fOrderSequence;
    private final SharedKernelServicePortalProvider portalProvider;
    private final ObjectHistoryEntryFormatter historyEntryFormatter;
    private JCheckBox checkBoxComplete;
    private JCheckBox checkBoxFailureFatal;
    private JCheckBox checkBoxFinished;
    private JPanel generalPanel;
    private JPanel historyPanel;
    private JScrollPane historyScrollPane;
    private JTable historyTable;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel labelFinishedIndex;
    private JLabel labelIntendedVehicle;
    private JLabel labelName;
    private JLabel labelProcessingVehicle;
    private JLabel labelType;
    private JPanel propertiesPanel;
    private JScrollPane propertiesScrollPane;
    private JTable propertiesTable;
    private JTextField textFieldFinishedIndex;
    private JTextField textFieldIntendedVehicle;
    private JTextField textFieldName;
    private JTextField textFieldProcessingVehicle;
    private JTextField textType;
    private JPanel transportOrdersPanel;
    private JScrollPane transportOrdersScrollPane;
    private JTable transportOrdersTable;

    @Inject
    public OrderSequenceView(@Assisted OrderSequence sequence, @Nonnull CompositeObjectHistoryEntryFormatter historyEntryFormatter, SharedKernelServicePortalProvider portalProvider) {
        this.fOrderSequence = Objects.requireNonNull(sequence, "sequence");
        this.historyEntryFormatter = Objects.requireNonNull(historyEntryFormatter, "historyEntryFormatter");
        this.portalProvider = Objects.requireNonNull(portalProvider, "portalProvider");
        this.initComponents();
        this.initFields();
    }

    public OrderSequence getOrderSequence() {
        return this.fOrderSequence;
    }

    public void update() {
    }

    public final void initFields() {
        TCSObjectReference processingVehicle;
        this.setDialogTitle(ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.panels.orderSequences").getString("orderSequenceView.title"));
        String name = this.getOrderSequence().getName();
        this.textFieldName.setText(name);
        boolean complete = this.getOrderSequence().isComplete();
        this.checkBoxComplete.setSelected(complete);
        this.checkBoxComplete.setEnabled(!complete);
        boolean finished = this.getOrderSequence().isFinished();
        this.checkBoxFinished.setSelected(finished);
        boolean failureFatal = this.getOrderSequence().isFailureFatal();
        this.checkBoxFailureFatal.setSelected(failureFatal);
        int finishedIndex = this.getOrderSequence().getFinishedIndex();
        this.textFieldFinishedIndex.setText("" + finishedIndex);
        TCSObjectReference intendedVehicle = this.getOrderSequence().getIntendedVehicle();
        if (intendedVehicle != null) {
            this.textFieldIntendedVehicle.setText(intendedVehicle.getName());
        }
        if ((processingVehicle = this.getOrderSequence().getProcessingVehicle()) != null) {
            this.textFieldProcessingVehicle.setText(processingVehicle.getName());
        }
        this.textType.setText(this.getOrderSequence().getType());
        UneditableTableModel tableModel = new UneditableTableModel();
        tableModel.setColumnIdentifiers(new String[]{"Name"});
        for (TCSObjectReference to : this.getOrderSequence().getOrders()) {
            Object[] row = new String[]{to.getName()};
            tableModel.addRow(row);
        }
        this.transportOrdersTable.setModel(tableModel);
        this.propertiesTable.setModel(this.createPropertiesTableModel());
        this.historyTable.setModel(this.createHistoryTableModel());
        this.historyTable.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.historyTable.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.historyTable.getColumnModel().getColumn(1).setCellRenderer(new ToolTipCellRenderer());
    }

    private TableModel createPropertiesTableModel() {
        UneditableTableModel tableModel = new UneditableTableModel();
        tableModel.setColumnIdentifiers(new String[]{ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.orderSequenceDetail").getString("orderSequenceView.table_properties.column_propertiesKey.headerText"), ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.orderSequenceDetail").getString("orderSequenceView.table_properties.column_propertiesValue.headerText")});
        this.fOrderSequence.getProperties().entrySet().stream().sorted((e1, e2) -> ((String)e1.getKey()).compareTo((String)e2.getKey())).forEach(entry -> tableModel.addRow(new String[]{(String)entry.getKey(), (String)entry.getValue()}));
        return tableModel;
    }

    private TableModel createHistoryTableModel() {
        UneditableTableModel tableModel = new UneditableTableModel();
        tableModel.setColumnIdentifiers(new String[]{ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.orderSequenceDetail").getString("orderSequenceView.table_history.column_timestamp.headerText"), ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.orderSequenceDetail").getString("orderSequenceView.table_history.column_event.headerText")});
        for (ObjectHistory.Entry entry : this.fOrderSequence.getHistory().getEntries()) {
            tableModel.addRow(new String[]{TIMESTAMP_FORMAT.format(Date.from(entry.getTimestamp())), (String)((Optional)this.historyEntryFormatter.apply((Object)entry)).get()});
        }
        return tableModel;
    }

    private void initComponents() {
        this.generalPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.labelName = new JLabel();
        this.textFieldName = new JTextField();
        this.labelFinishedIndex = new JLabel();
        this.textFieldFinishedIndex = new JTextField();
        this.labelIntendedVehicle = new JLabel();
        this.textFieldIntendedVehicle = new JTextField();
        this.labelProcessingVehicle = new JLabel();
        this.textFieldProcessingVehicle = new JTextField();
        this.labelType = new JLabel();
        this.textType = new JTextField();
        this.jPanel2 = new JPanel();
        this.checkBoxComplete = new JCheckBox();
        this.checkBoxFinished = new JCheckBox();
        this.checkBoxFailureFatal = new JCheckBox();
        this.transportOrdersPanel = new JPanel();
        this.transportOrdersScrollPane = new JScrollPane();
        this.transportOrdersTable = new JTable();
        this.propertiesPanel = new JPanel();
        this.propertiesScrollPane = new JScrollPane();
        this.propertiesTable = new JTable();
        this.historyPanel = new JPanel();
        this.historyScrollPane = new JScrollPane();
        this.historyTable = new JTable();
        this.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("i18n/org/opentcs/plantoverview/operating/dialogs/orderSequenceDetail");
        this.generalPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("orderSequenceView.panel_general.border.title")));
        this.generalPanel.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.labelName.setFont(this.labelName.getFont());
        this.labelName.setText(bundle.getString("orderSequenceView.panel_general.label_name.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel1.add((Component)this.labelName, gridBagConstraints);
        this.textFieldName.setEditable(false);
        this.textFieldName.setColumns(10);
        this.textFieldName.setFont(this.textFieldName.getFont());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        this.jPanel1.add((Component)this.textFieldName, gridBagConstraints);
        this.labelFinishedIndex.setFont(this.labelFinishedIndex.getFont());
        this.labelFinishedIndex.setText(bundle.getString("orderSequenceView.panel_general.label_finishedIndex.text"));
        this.labelFinishedIndex.setToolTipText(bundle.getString("orderSequenceView.panel_general.label_finishedIndex.tooltipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel1.add((Component)this.labelFinishedIndex, gridBagConstraints);
        this.textFieldFinishedIndex.setEditable(false);
        this.textFieldFinishedIndex.setColumns(10);
        this.textFieldFinishedIndex.setFont(this.textFieldFinishedIndex.getFont());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        this.jPanel1.add((Component)this.textFieldFinishedIndex, gridBagConstraints);
        this.labelIntendedVehicle.setFont(this.labelIntendedVehicle.getFont());
        this.labelIntendedVehicle.setText(bundle.getString("orderSequenceView.panel_general.label_intendedVehicle.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel1.add((Component)this.labelIntendedVehicle, gridBagConstraints);
        this.textFieldIntendedVehicle.setEditable(false);
        this.textFieldIntendedVehicle.setColumns(10);
        this.textFieldIntendedVehicle.setFont(this.textFieldIntendedVehicle.getFont());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        this.jPanel1.add((Component)this.textFieldIntendedVehicle, gridBagConstraints);
        this.labelProcessingVehicle.setFont(this.labelProcessingVehicle.getFont());
        this.labelProcessingVehicle.setText(bundle.getString("orderSequenceView.panel_general.label_processingVehicle.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel1.add((Component)this.labelProcessingVehicle, gridBagConstraints);
        this.textFieldProcessingVehicle.setEditable(false);
        this.textFieldProcessingVehicle.setColumns(10);
        this.textFieldProcessingVehicle.setFont(this.textFieldProcessingVehicle.getFont());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        this.jPanel1.add((Component)this.textFieldProcessingVehicle, gridBagConstraints);
        this.labelType.setFont(this.labelType.getFont());
        this.labelType.setText(bundle.getString("orderSequenceView.panel_general.label_type.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel1.add((Component)this.labelType, gridBagConstraints);
        this.textType.setEditable(false);
        this.textType.setColumns(10);
        this.textType.setFont(this.textType.getFont());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        this.jPanel1.add((Component)this.textType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.5;
        this.generalPanel.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.checkBoxComplete.setText(bundle.getString("orderSequenceView.panel_general.checkBox_complete.text"));
        this.checkBoxComplete.setToolTipText(bundle.getString("orderSequenceView.panel_general.checkBox_complete.tooltipText"));
        this.checkBoxComplete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderSequenceView.this.checkBoxCompleteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.checkBoxComplete, gridBagConstraints);
        this.checkBoxFinished.setText(bundle.getString("orderSequenceView.panel_general.checkBox_finished.text"));
        this.checkBoxFinished.setToolTipText(bundle.getString("orderSequenceView.panel_general.checkBox_finished.tooltipText"));
        this.checkBoxFinished.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.checkBoxFinished, gridBagConstraints);
        this.checkBoxFailureFatal.setText(bundle.getString("orderSequenceView.panel_general.checkBox_failureFatal.text"));
        this.checkBoxFailureFatal.setToolTipText(bundle.getString("orderSequenceView.panel_general.checkBox_failureFatal.tooltipText"));
        this.checkBoxFailureFatal.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.checkBoxFailureFatal, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        this.generalPanel.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        this.add(this.generalPanel, gridBagConstraints);
        this.transportOrdersPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("orderSequenceView.panel_transportOrders.border.title")));
        this.transportOrdersPanel.setLayout(new GridBagLayout());
        this.transportOrdersScrollPane.setPreferredSize(new Dimension(100, 100));
        this.transportOrdersScrollPane.setViewportView(this.transportOrdersTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.transportOrdersPanel.add((Component)this.transportOrdersScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.add(this.transportOrdersPanel, gridBagConstraints);
        this.propertiesPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("orderSequenceView.panel_properties.border.text")));
        this.propertiesPanel.setLayout(new BorderLayout());
        this.propertiesScrollPane.setPreferredSize(new Dimension(150, 100));
        this.propertiesTable.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.propertiesScrollPane.setViewportView(this.propertiesTable);
        this.propertiesPanel.add((Component)this.propertiesScrollPane, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.add(this.propertiesPanel, gridBagConstraints);
        this.historyPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("orderSequenceView.panel_history.border.text")));
        this.historyPanel.setLayout(new BorderLayout());
        this.historyScrollPane.setPreferredSize(new Dimension(150, 100));
        this.historyTable.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.historyScrollPane.setViewportView(this.historyTable);
        this.historyPanel.add((Component)this.historyScrollPane, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.add(this.historyPanel, gridBagConstraints);
    }

    private void checkBoxCompleteActionPerformed(ActionEvent evt) {
        ResourceBundleUtil bundle = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.dialogs.orderSequenceDetail");
        int n = JOptionPane.showConfirmDialog((Component)((Object)this), bundle.getString("orderSequenceView.optionPane_markSequenceCompleteConfirmation.message"), bundle.getString("orderSequenceView.optionPane_markSequenceCompleteConfirmation.title"), 0);
        if (n == 0) {
            try (SharedKernelServicePortal sharedPortal = this.portalProvider.register();){
                sharedPortal.getPortal().getTransportOrderService().markOrderSequenceComplete(this.fOrderSequence.getReference());
                this.checkBoxComplete.setEnabled(false);
            }
            catch (KernelRuntimeException exc) {
                LOG.warn("Exception setting order sequence complete", (Throwable)exc);
            }
        } else {
            this.checkBoxComplete.setSelected(false);
        }
    }

    private static class ToolTipCellRenderer
    extends DefaultTableCellRenderer {
        ToolTipCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            ((JComponent)component).setToolTipText(value.toString());
            return component;
        }
    }
}

