/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.operationsdesk.transport.sequences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.RowFilter;
import org.opentcs.customizations.plantoverview.ApplicationFrame;
import org.opentcs.data.order.OrderSequence;
import org.opentcs.guing.common.components.dialogs.DialogContent;
import org.opentcs.guing.common.components.dialogs.StandardContentDialog;
import org.opentcs.guing.common.util.IconToolkit;
import org.opentcs.operationsdesk.transport.FilterButton;
import org.opentcs.operationsdesk.transport.FilteredRowSorter;
import org.opentcs.operationsdesk.transport.OrdersTable;
import org.opentcs.operationsdesk.transport.orders.TransportViewFactory;
import org.opentcs.operationsdesk.transport.sequences.OrderSequenceTableModel;
import org.opentcs.operationsdesk.transport.sequences.OrderSequenceView;
import org.opentcs.operationsdesk.transport.sequences.OrderSequencesContainer;
import org.opentcs.thirdparty.guing.common.jhotdraw.util.ResourceBundleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderSequencesContainerPanel
extends JPanel {
    private static final String ICON_PATH = "/org/opentcs/guing/res/symbols/panel/";
    private static final Logger LOG = LoggerFactory.getLogger(OrderSequencesContainerPanel.class);
    private final TransportViewFactory transportViewFactory;
    private final Component dialogParent;
    private JTable fTable;
    private OrderSequenceTableModel tableModel;
    private FilteredRowSorter<OrderSequenceTableModel> sorter;
    private final OrderSequencesContainer orderSequencesContainer;

    @Inject
    public OrderSequencesContainerPanel(TransportViewFactory transportViewFactory, @ApplicationFrame Component dialogParent, OrderSequencesContainer orderSequencesContainer) {
        this.transportViewFactory = Objects.requireNonNull(transportViewFactory, "transportViewFactory");
        this.dialogParent = Objects.requireNonNull(dialogParent, "dialogParent");
        this.orderSequencesContainer = Objects.requireNonNull(orderSequencesContainer, "orderSequencesContainer");
        this.initComponents();
    }

    public void initView() {
        this.tableModel.containerInitialized(this.orderSequencesContainer.getOrderSequences());
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.tableModel = new OrderSequenceTableModel();
        this.orderSequencesContainer.addListener(this.tableModel);
        this.fTable = new OrdersTable(this.tableModel);
        this.sorter = new FilteredRowSorter<OrderSequenceTableModel>(this.tableModel);
        for (int i = 0; i < this.fTable.getColumnCount(); ++i) {
            this.sorter.setSortable(i, false);
        }
        this.sorter.setSortsOnUpdates(true);
        this.fTable.setRowSorter(this.sorter);
        JScrollPane scrollPane = new JScrollPane(this.fTable);
        this.add((Component)scrollPane, "Center");
        JToolBar toolBar = this.createToolBar(this.createFilterButtons());
        this.add((Component)toolBar, "North");
        this.fTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getButton() == 1 && evt.getClickCount() == 2) {
                    OrderSequencesContainerPanel.this.showOrderSequence();
                }
                if (evt.getButton() == 3) {
                    OrderSequencesContainerPanel.this.showPopupMenu(evt.getX(), evt.getY());
                }
            }
        });
    }

    private void showOrderSequence() {
        this.getSelectedOrderSequence().ifPresent(os -> {
            OrderSequenceView content = this.transportViewFactory.createOrderSequenceView((OrderSequence)os);
            StandardContentDialog dialog = new StandardContentDialog(this.dialogParent, (DialogContent)content, true, 12);
            dialog.setVisible(true);
        });
    }

    private void showPopupMenu(int x, int y) {
        int row = this.fTable.rowAtPoint(new Point(x, y));
        this.fTable.setRowSelectionInterval(row, row);
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = menu.add(ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.panels.orderSequences").getString("orderSequencesContainerPanel.table_sequences.popupMenuItem_showDetails.text"));
        item.addActionListener(evt -> this.showOrderSequence());
        menu.show(this.fTable, x, y);
    }

    private Optional<OrderSequence> getSelectedOrderSequence() {
        int row = this.fTable.getSelectedRow();
        if (row == -1) {
            return Optional.empty();
        }
        return Optional.of(this.tableModel.getEntryAt(this.fTable.convertRowIndexToModel(row)));
    }

    private List<FilterButton> createFilterButtons() {
        LinkedList<FilterButton> buttons = new LinkedList<FilterButton>();
        FilterButton b1 = new FilterButton(IconToolkit.instance().getImageIconByFullPath("/org/opentcs/guing/res/symbols/panel/filterFinished.16x16.gif"), this.createFilter(), this.sorter);
        buttons.add(b1);
        b1.setToolTipText(ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.panels.orderSequences").getString("orderSequencesContainerPanel.button_filterFinishedOrderSequences.tooltipText"));
        return buttons;
    }

    private RowFilter<Object, Object> createFilter() {
        return new RowFilter<Object, Object>(){

            @Override
            public boolean include(RowFilter.Entry<? extends Object, ? extends Object> entry) {
                OrderSequence os = ((OrderSequenceTableModel)entry.getModel()).getEntryAt((Integer)entry.getIdentifier());
                return os.isComplete();
            }
        };
    }

    private JToolBar createToolBar(List<FilterButton> filterButtons) {
        JToolBar toolBar = new JToolBar();
        for (FilterButton button : filterButtons) {
            toolBar.add(button);
        }
        return toolBar;
    }
}

