/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.operationsdesk.util;

import org.opentcs.components.plantoverview.LocationTheme;
import org.opentcs.components.plantoverview.VehicleTheme;
import org.opentcs.configuration.ConfigurationEntry;
import org.opentcs.configuration.ConfigurationPrefix;

@ConfigurationPrefix(value="plantoverviewapp")
public interface PlantOverviewOperatingApplicationConfiguration {
    public static final String PREFIX = "plantoverviewapp";

    @ConfigurationEntry(type="String", description={"The plant overview application's locale, as a BCP 47 language tag.", "Examples: 'en', 'de', 'zh'"}, orderKey="0_init_0")
    public String locale();

    @ConfigurationEntry(type="Boolean", description={"Whether the GUI window should be maximized on startup."}, orderKey="1_size_0")
    public boolean frameMaximized();

    @ConfigurationEntry(type="Integer", description={"The GUI window's configured width in pixels."}, orderKey="1_size_1")
    public int frameBoundsWidth();

    @ConfigurationEntry(type="Integer", description={"The GUI window's configured height in pixels."}, orderKey="1_size_2")
    public int frameBoundsHeight();

    @ConfigurationEntry(type="Integer", description={"The GUI window's configured x-coordinate on screen in pixels."}, orderKey="1_size_3")
    public int frameBoundsX();

    @ConfigurationEntry(type="Integer", description={"The GUI window's configured y-coordinate on screen in pixels."}, orderKey="1_size_4")
    public int frameBoundsY();

    @ConfigurationEntry(type="Class name", description={"The name of the class to be used for the location theme.", "Must be a class extending org.opentcs.components.plantoverview.LocationTheme"}, orderKey="3_themes_0")
    public Class<? extends LocationTheme> locationThemeClass();

    @ConfigurationEntry(type="Class name", description={"The name of the class to be used for the vehicle theme.", "Must be a class extending org.opentcs.components.plantoverview.VehicleTheme"}, orderKey="3_themes_0")
    public Class<? extends VehicleTheme> vehicleThemeClass();

    @ConfigurationEntry(type="Boolean", description={"Whether reported precise positions should be ignored displaying vehicles."}, orderKey="4_behaviour_0")
    public boolean ignoreVehiclePrecisePosition();

    @ConfigurationEntry(type="Boolean", description={"Whether reported orientation angles should be ignored displaying vehicles."}, orderKey="4_behaviour_1")
    public boolean ignoreVehicleOrientationAngle();

    @ConfigurationEntry(type="Boolean", description={"Whether to enable and show the panel for peripheral jobs."}, orderKey="9_misc")
    public boolean enablePeripheralJobsPanel();
}

