/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.thirdparty.operationsdesk.components.drawing;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.MultipleGradientPaint;
import java.awt.Point;
import java.awt.RadialGradientPaint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.jhotdraw.draw.DefaultDrawingView;
import org.jhotdraw.draw.Figure;
import org.opentcs.guing.base.model.ModelComponent;
import org.opentcs.guing.base.model.elements.PointModel;
import org.opentcs.guing.base.model.elements.VehicleModel;
import org.opentcs.guing.common.application.ApplicationState;
import org.opentcs.guing.common.components.drawing.figures.OriginFigure;
import org.opentcs.guing.common.persistence.ModelManager;
import org.opentcs.operationsdesk.components.drawing.figures.VehicleFigure;
import org.opentcs.thirdparty.guing.common.jhotdraw.components.drawing.AbstractOpenTCSDrawingView;

public class OpenTCSDrawingViewOperating
extends AbstractOpenTCSDrawingView {
    private final List<VehicleModel> fVehicles = new ArrayList<VehicleModel>();
    private VehicleModel fFocusVehicle;

    @Inject
    public OpenTCSDrawingViewOperating(ApplicationState appState, ModelManager modelManager) {
        super(appState, modelManager);
    }

    public void removeAll() {
        this.fVehicles.clear();
        super.removeAll();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getPropertyName().equals("position_changed")) {
            this.scrollTo((Figure)((VehicleFigure)this.getModelManager().getModel().getFigure((ModelComponent)this.fFocusVehicle)));
        }
    }

    public void cutSelectedItems() {
    }

    public void copySelectedItems() {
    }

    public void pasteBufferedItems() {
    }

    public void delete() {
    }

    public void duplicate() {
    }

    public void displayDriveOrders(VehicleModel vehicle, boolean visible) {
        Objects.requireNonNull(vehicle, "vehicle");
        if (visible) {
            if (!this.fVehicles.contains(vehicle)) {
                this.fVehicles.add(vehicle);
            }
        } else {
            this.fVehicles.remove(vehicle);
        }
    }

    public void followVehicle(@Nonnull VehicleModel model) {
        Objects.requireNonNull(model, "model");
        this.stopFollowVehicle();
        this.fFocusVehicle = model;
        this.fFocusVehicle.setViewFollows(true);
        VehicleFigure vFigure = (VehicleFigure)this.getModelManager().getModel().getFigure((ModelComponent)this.fFocusVehicle);
        if (vFigure != null) {
            vFigure.addPropertyChangeListener((PropertyChangeListener)((Object)this));
            this.scrollTo((Figure)vFigure);
        }
    }

    public void stopFollowVehicle() {
        if (this.fFocusVehicle == null) {
            return;
        }
        this.fFocusVehicle.setViewFollows(false);
        VehicleFigure vFigure = (VehicleFigure)this.getModelManager().getModel().getFigure((ModelComponent)this.fFocusVehicle);
        if (vFigure != null) {
            vFigure.removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        this.fFocusVehicle = null;
        this.repaint();
    }

    public void setBlocks(ModelComponent blocks) {
    }

    protected void drawTool(Graphics2D g2d) {
        super.drawTool(g2d);
        if (this.getEditor() == null || this.getEditor().getTool() == null || this.getEditor().getActiveView() != this) {
            return;
        }
        if (this.fFocusVehicle != null) {
            this.highlightVehicle(g2d);
        } else {
            this.highlightFocus(g2d);
        }
    }

    protected DefaultDrawingView.EventHandler createEventHandler() {
        return new ExtendedEventHandler();
    }

    protected Rectangle2D.Double computeBounds(Figure figure) {
        VehicleModel vehicleModel;
        PointModel pointModel;
        Rectangle2D.Double bounds = super.computeBounds(figure);
        if (figure instanceof VehicleFigure && (pointModel = (vehicleModel = ((VehicleFigure)figure).getModel()).getNextPoint()) != null) {
            Figure pointFigure = this.getModelManager().getModel().getFigure((ModelComponent)pointModel);
            bounds.add(pointFigure.getBounds());
        }
        return bounds;
    }

    public void delete(Set<ModelComponent> components) {
    }

    private void highlightVehicle(Graphics2D g2d) {
        if (this.fFocusVehicle == null) {
            return;
        }
        Figure currentVehicleFigure = this.getModelManager().getModel().getFigure((ModelComponent)this.fFocusVehicle);
        if (currentVehicleFigure == null) {
            return;
        }
        Rectangle2D.Double bounds = currentVehicleFigure.getBounds();
        double xCenter = bounds.getCenterX();
        double yCenter = bounds.getCenterY();
        Point2D.Double pCenterView = new Point2D.Double(xCenter, yCenter);
        Point pCenterDrawing = this.drawingToView(pCenterView);
        Point2D.Float center = new Point2D.Float(pCenterDrawing.x, pCenterDrawing.y);
        float radius = 30.0f;
        float[] dist = new float[]{0.0f, 0.7f, 0.8f, 1.0f};
        Color[] colors = new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.0f), new Color(1.0f, 1.0f, 1.0f, 0.0f), new Color(1.0f, 0.0f, 0.0f, 0.7f), new Color(0.0f, 0.0f, 0.0f, 0.0f)};
        RadialGradientPaint paint = new RadialGradientPaint(center, radius, dist, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
        Graphics2D gVehicle = (Graphics2D)g2d.create();
        gVehicle.setPaint(paint);
        gVehicle.fillRect(0, 0, this.getWidth(), this.getHeight());
        gVehicle.dispose();
        PointModel pointModel = this.fFocusVehicle.getNextPoint();
        if (pointModel != null) {
            Figure nextPoint = this.getModelManager().getModel().getFigure((ModelComponent)pointModel);
            bounds = nextPoint.getBounds();
            xCenter = bounds.getCenterX();
            yCenter = bounds.getCenterY();
            pCenterView = new Point2D.Double(xCenter, yCenter);
            pCenterDrawing = this.drawingToView(pCenterView);
            center = new Point2D.Float(pCenterDrawing.x, pCenterDrawing.y);
            radius = 20.0f;
            Color[] colorsGreen = new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.0f), new Color(1.0f, 1.0f, 1.0f, 0.0f), new Color(0.0f, 1.0f, 0.0f, 0.7f), new Color(0.0f, 0.0f, 0.0f, 0.0f)};
            paint = new RadialGradientPaint(center, radius, dist, colorsGreen, MultipleGradientPaint.CycleMethod.NO_CYCLE);
            Graphics2D gNextPosition = (Graphics2D)g2d.create();
            gNextPosition.setPaint(paint);
            gNextPosition.fillRect(0, 0, this.getWidth(), this.getHeight());
            gNextPosition.dispose();
        }
        if ((pointModel = this.fFocusVehicle.getPoint()) != null && this.fFocusVehicle.getPrecisePosition() != null) {
            Figure lastPoint = this.getModelManager().getModel().getFigure((ModelComponent)pointModel);
            bounds = lastPoint.getBounds();
            xCenter = bounds.getCenterX();
            yCenter = bounds.getCenterY();
            pCenterView = new Point2D.Double(xCenter, yCenter);
            pCenterDrawing = this.drawingToView(pCenterView);
            center = new Point2D.Float(pCenterDrawing.x, pCenterDrawing.y);
            radius = 20.0f;
            Color[] colorsBlue = new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.0f), new Color(1.0f, 1.0f, 1.0f, 0.0f), new Color(0.0f, 0.0f, 1.0f, 0.7f), new Color(0.0f, 0.0f, 0.0f, 0.0f)};
            paint = new RadialGradientPaint(center, radius, dist, colorsBlue, MultipleGradientPaint.CycleMethod.NO_CYCLE);
            Graphics2D gCurrentPosition = (Graphics2D)g2d.create();
            gCurrentPosition.setPaint(paint);
            gCurrentPosition.fillRect(0, 0, this.getWidth(), this.getHeight());
            gCurrentPosition.dispose();
        }
        this.loopProofRepaintDrawingArea();
    }

    private class ExtendedEventHandler
    extends AbstractOpenTCSDrawingView.AbstractExtendedEventHandler {
        ExtendedEventHandler() {
            super((AbstractOpenTCSDrawingView)OpenTCSDrawingViewOperating.this);
        }

        protected boolean shouldShowFigure(Figure figure) {
            return !(figure instanceof VehicleFigure) && !(figure instanceof OriginFigure);
        }
    }
}

