/**
 * Copyright (c) The openTCS Authors.
 *
 * This program is free software and subject to the MIT license. (For details,
 * see the licensing information (LICENSE.txt) you should have received with
 * this copy of the software.)
 */
package org.opentcs.guing.common.components.properties.panel;

import javax.swing.JPanel;
import org.opentcs.guing.base.components.properties.type.Property;
import org.opentcs.guing.base.components.properties.type.StringProperty;
import org.opentcs.guing.common.components.dialogs.DetailsDialogContent;
import org.opentcs.guing.common.util.I18nPlantOverview;
import org.opentcs.thirdparty.guing.common.jhotdraw.util.ResourceBundleUtil;

/**
 * A panel that can edit a string property.
 */
public class StringPropertyEditorPanel
    extends JPanel
    implements DetailsDialogContent {

  /**
   * The property that is being edited.
   */
  private StringProperty fProperty;

  /**
   * Creates new form StringPropertyPanel
   */
  public StringPropertyEditorPanel() {
    initComponents();
  }

  @Override // DetailsDialogContent
  public String getTitle() {
    return ResourceBundleUtil.getBundle(I18nPlantOverview.PROPERTIES_PATH)
        .getString("stringPropertyEditorPanel.title");
  }

  /**
   * Initialises the dialog elements.
   */
  public void initFields() {
    textArea.setText(fProperty.getText());
    textArea.setCaretPosition(fProperty.getText().length());
  }

  @Override // DetailsDialogContent
  public void updateValues() {
    fProperty.setText(textArea.getText());
  }

  @Override // DetailsDialogContent
  public void setProperty(Property property) {
    fProperty = (StringProperty) property;
    initFields();
  }

  @Override // DetailsDialogContent
  public Property getProperty() {
    return fProperty;
  }

  // CHECKSTYLE:OFF
  /**
   * This method is called from within the constructor to initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is always
   * regenerated by the Form Editor.
   */
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    textArea = new javax.swing.JTextArea();

    setLayout(new java.awt.BorderLayout());

    textArea.setColumns(20);
    textArea.setFont(new java.awt.Font("Monospaced", 0, 12)); // NOI18N
    textArea.setLineWrap(true);
    textArea.setRows(15);
    textArea.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
    add(textArea, java.awt.BorderLayout.CENTER);
  }// </editor-fold>//GEN-END:initComponents


  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JTextArea textArea;
  // End of variables declaration//GEN-END:variables
  // CHECKSTYLE:ON
}
