/**
 * Copyright (c) The openTCS Authors.
 *
 * This program is free software and subject to the MIT license. (For details,
 * see the licensing information (LICENSE.txt) you should have received with
 * this copy of the software.)
 */
package org.opentcs.guing.common.util;

/**
 * Defines constants regarding internationalization.
 */
public interface I18nPlantOverview {

  /**
   * Path to the resources related the menu bar.
   */
  String MENU_PATH = "i18n.org.opentcs.plantoverview.mainMenu";
  /**
   * Path to miscellaneous resources
   */
  String MISC_PATH = "i18n.org.opentcs.plantoverview.miscellaneous";
  /**
   * Path to the resources related to the system.
   */
  String SYSTEM_PATH = "i18n.org.opentcs.plantoverview.system";
  /**
   * Path to the resources related to toolbars.
   */
  String TOOLBAR_PATH = "i18n.org.opentcs.plantoverview.toolbar";
  /**
   * Path to the resources related to model properties dialog.
   */
  String MODELPROPERTIES_PATH = "i18n.org.opentcs.plantoverview.dialogs.modelProperties";
  /**
   * Path to the resources related to the modelview panel.
   */
  String MODELVIEW_PATH = "i18n.org.opentcs.plantoverview.panels.modelView";
  /**
   * Path to the resources related to the properties panel.
   */
  String PROPERTIES_PATH = "i18n.org.opentcs.plantoverview.panels.propertyEditing";
  /**
   * Path to the resources related to status messages.
   */
  String STATUS_PATH = "i18n.org.opentcs.plantoverview.panels.status";
  /**
   * Path to the resources related to the tree view.
   */
  String TREEVIEW_PATH = "i18n.org.opentcs.plantoverview.panels.componentTrees";
  /**
   * Path to the resources related to layers.
   */
  String LAYERS_PATH = "i18n.org.opentcs.plantoverview.panels.layers";
}
