/*
 * Decompiled with CFR 0.152.
 */
package org.openucx.jucx.ucp;

import java.io.Closeable;
import java.nio.ByteBuffer;
import org.openucx.jucx.UcxCallback;
import org.openucx.jucx.UcxException;
import org.openucx.jucx.UcxNativeStruct;
import org.openucx.jucx.UcxParams;
import org.openucx.jucx.UcxUtils;
import org.openucx.jucx.ucp.UcpConstants;
import org.openucx.jucx.ucp.UcpEndpointErrorHandler;
import org.openucx.jucx.ucp.UcpEndpointParams;
import org.openucx.jucx.ucp.UcpRemoteKey;
import org.openucx.jucx.ucp.UcpRequest;
import org.openucx.jucx.ucp.UcpRequestParams;
import org.openucx.jucx.ucp.UcpWorker;

public class UcpEndpoint
extends UcxNativeStruct
implements Closeable {
    private String paramsString;
    private UcpEndpointErrorHandler errorHandler;

    private UcpEndpoint(long nativeId) {
        this.setNativeId(nativeId);
    }

    public String toString() {
        return "UcpEndpoint(id=" + this.getNativeId() + ", " + this.paramsString + ")";
    }

    public UcpEndpoint(UcpWorker worker, UcpEndpointParams params) {
        if (params.errorHandler == null) {
            params.setErrorHandler((ep, status, errorMsg) -> {
                throw new UcxException("Endpoint " + ep.toString() + " error: " + errorMsg);
            });
        }
        this.errorHandler = params.errorHandler;
        this.paramsString = params.toString();
        this.setNativeId(this.createEndpointNative(params, worker.getNativeId()));
    }

    @Override
    public void close() {
        UcpEndpoint.destroyEndpointNative(this.getNativeId());
        this.setNativeId(null);
    }

    public UcpRemoteKey unpackRemoteKey(ByteBuffer rkeyBuffer) {
        return UcpEndpoint.unpackRemoteKey(this.getNativeId(), UcxUtils.getAddress(rkeyBuffer));
    }

    private void checkRemoteAccessParams(ByteBuffer buf, UcpRemoteKey remoteKey) {
        if (!buf.isDirect()) {
            throw new UcxException("Data buffer must be direct.");
        }
        if (remoteKey.getNativeId() == null) {
            throw new UcxException("Remote key is null.");
        }
    }

    public UcpRequest putNonBlocking(ByteBuffer src, long remoteAddress, UcpRemoteKey remoteKey, UcxCallback callback) {
        this.checkRemoteAccessParams(src, remoteKey);
        return this.putNonBlocking(UcxUtils.getAddress(src), src.remaining(), remoteAddress, remoteKey, callback);
    }

    public UcpRequest putNonBlocking(long localAddress, long size, long remoteAddress, UcpRemoteKey remoteKey, UcxCallback callback) {
        return this.putNonBlocking(localAddress, size, remoteAddress, remoteKey, callback, null);
    }

    public UcpRequest putNonBlocking(long localAddress, long size, long remoteAddress, UcpRemoteKey remoteKey, UcxCallback callback, int memoryType) {
        return this.putNonBlocking(localAddress, size, remoteAddress, remoteKey, callback, new UcpRequestParams().setMemoryType(memoryType));
    }

    public UcpRequest putNonBlocking(long localAddress, long size, long remoteAddress, UcpRemoteKey remoteKey, UcxCallback callback, UcpRequestParams params) {
        return UcpEndpoint.putNonBlockingNative(this.getNativeId(), localAddress, size, remoteAddress, remoteKey.getNativeId(), callback, params);
    }

    public void putNonBlockingImplicit(ByteBuffer src, long remoteAddress, UcpRemoteKey remoteKey) {
        this.checkRemoteAccessParams(src, remoteKey);
        this.putNonBlockingImplicit(UcxUtils.getAddress(src), src.remaining(), remoteAddress, remoteKey);
    }

    public void putNonBlockingImplicit(long localAddress, long size, long remoteAddress, UcpRemoteKey remoteKey) {
        UcpEndpoint.putNonBlockingImplicitNative(this.getNativeId(), localAddress, size, remoteAddress, remoteKey.getNativeId());
    }

    public UcpRequest getNonBlocking(long remoteAddress, UcpRemoteKey remoteKey, ByteBuffer dst, UcxCallback callback) {
        this.checkRemoteAccessParams(dst, remoteKey);
        return this.getNonBlocking(remoteAddress, remoteKey, UcxUtils.getAddress(dst), dst.remaining(), callback);
    }

    public UcpRequest getNonBlocking(long remoteAddress, UcpRemoteKey remoteKey, long localAddress, long size, UcxCallback callback) {
        return this.getNonBlocking(remoteAddress, remoteKey, localAddress, size, callback, null);
    }

    public UcpRequest getNonBlocking(long remoteAddress, UcpRemoteKey remoteKey, long localAddress, long size, UcxCallback callback, int memoryType) {
        return this.getNonBlocking(remoteAddress, remoteKey, localAddress, size, callback, new UcpRequestParams().setMemoryType(memoryType));
    }

    public UcpRequest getNonBlocking(long remoteAddress, UcpRemoteKey remoteKey, long localAddress, long size, UcxCallback callback, UcpRequestParams params) {
        return UcpEndpoint.getNonBlockingNative(this.getNativeId(), remoteAddress, remoteKey.getNativeId(), localAddress, size, callback, params);
    }

    public void getNonBlockingImplicit(long remoteAddress, UcpRemoteKey remoteKey, ByteBuffer dst) {
        this.checkRemoteAccessParams(dst, remoteKey);
        this.getNonBlockingImplicit(remoteAddress, remoteKey, UcxUtils.getAddress(dst), dst.remaining());
    }

    public void getNonBlockingImplicit(long remoteAddress, UcpRemoteKey remoteKey, long localAddress, long size) {
        UcpEndpoint.getNonBlockingImplicitNative(this.getNativeId(), remoteAddress, remoteKey.getNativeId(), localAddress, size);
    }

    public UcpRequest sendTaggedNonBlocking(ByteBuffer sendBuffer, long tag, UcxCallback callback) {
        if (!sendBuffer.isDirect()) {
            throw new UcxException("Send buffer must be direct.");
        }
        return this.sendTaggedNonBlocking(UcxUtils.getAddress(sendBuffer), sendBuffer.remaining(), tag, callback);
    }

    public UcpRequest sendTaggedNonBlocking(long localAddress, long size, long tag, UcxCallback callback) {
        return this.sendTaggedNonBlocking(localAddress, size, tag, callback, null);
    }

    public UcpRequest sendTaggedNonBlocking(long localAddress, long size, long tag, UcxCallback callback, int memoryType) {
        return this.sendTaggedNonBlocking(localAddress, size, tag, callback, new UcpRequestParams().setMemoryType(memoryType));
    }

    public UcpRequest sendTaggedNonBlocking(long localAddress, long size, long tag, UcxCallback callback, UcpRequestParams params) {
        return UcpEndpoint.sendTaggedNonBlockingNative(this.getNativeId(), localAddress, size, tag, callback, params);
    }

    public UcpRequest sendTaggedNonBlocking(ByteBuffer sendBuffer, UcxCallback callback) {
        return this.sendTaggedNonBlocking(sendBuffer, 0L, callback);
    }

    public UcpRequest sendTaggedNonBlocking(long[] localAddresses, long[] sizes, long tag, UcxCallback callback, UcpRequestParams params) {
        UcxParams.checkArraySizes(localAddresses, sizes);
        return UcpEndpoint.sendTaggedIovNonBlockingNative(this.getNativeId(), localAddresses, sizes, tag, callback, params);
    }

    public UcpRequest sendTaggedNonBlocking(long[] localAddresses, long[] sizes, long tag, UcxCallback callback, int memoryType) {
        UcxParams.checkArraySizes(localAddresses, sizes);
        return this.sendTaggedNonBlocking(localAddresses, sizes, tag, callback, new UcpRequestParams().setMemoryType(memoryType));
    }

    public UcpRequest sendTaggedNonBlocking(long[] localAddresses, long[] sizes, long tag, UcxCallback callback) {
        return this.sendTaggedNonBlocking(localAddresses, sizes, tag, callback, null);
    }

    public UcpRequest sendStreamNonBlocking(long localAddress, long size, UcxCallback callback) {
        return this.sendStreamNonBlocking(localAddress, size, callback, null);
    }

    public UcpRequest sendStreamNonBlocking(long localAddress, long size, UcxCallback callback, UcpRequestParams params) {
        return UcpEndpoint.sendStreamNonBlockingNative(this.getNativeId(), localAddress, size, callback, params);
    }

    public UcpRequest sendStreamNonBlocking(long localAddress, long size, UcxCallback callback, int memoryType) {
        return this.sendStreamNonBlocking(localAddress, size, callback, new UcpRequestParams().setMemoryType(memoryType));
    }

    public UcpRequest sendStreamNonBlocking(long[] localAddresses, long[] sizes, UcxCallback callback) {
        UcxParams.checkArraySizes(localAddresses, sizes);
        return this.sendStreamNonBlocking(localAddresses, sizes, callback, null);
    }

    public UcpRequest sendStreamNonBlocking(long[] localAddresses, long[] sizes, UcxCallback callback, UcpRequestParams params) {
        UcxParams.checkArraySizes(localAddresses, sizes);
        return UcpEndpoint.sendStreamIovNonBlockingNative(this.getNativeId(), localAddresses, sizes, callback, params);
    }

    public UcpRequest sendStreamNonBlocking(long[] localAddresses, long[] sizes, UcxCallback callback, int memoryType) {
        UcxParams.checkArraySizes(localAddresses, sizes);
        return this.sendStreamNonBlocking(localAddresses, sizes, callback, new UcpRequestParams().setMemoryType(memoryType));
    }

    public UcpRequest sendStreamNonBlocking(ByteBuffer buffer, UcxCallback callback) {
        return this.sendStreamNonBlocking(UcxUtils.getAddress(buffer), buffer.remaining(), callback);
    }

    public UcpRequest recvStreamNonBlocking(long localAddress, long size, long flags, UcxCallback callback, UcpRequestParams params) {
        return UcpEndpoint.recvStreamNonBlockingNative(this.getNativeId(), localAddress, size, flags, callback, params);
    }

    public UcpRequest recvStreamNonBlocking(long localAddress, long size, long flags, UcxCallback callback, int memoryType) {
        return this.recvStreamNonBlocking(localAddress, size, flags, callback, new UcpRequestParams().setMemoryType(memoryType));
    }

    public UcpRequest recvStreamNonBlocking(long localAddress, long size, long flags, UcxCallback callback) {
        return this.recvStreamNonBlocking(localAddress, size, flags, callback, null);
    }

    public UcpRequest recvStreamNonBlocking(long[] localAddresses, long[] sizes, long flags, UcxCallback callback, UcpRequestParams params) {
        UcxParams.checkArraySizes(localAddresses, sizes);
        return UcpEndpoint.recvStreamIovNonBlockingNative(this.getNativeId(), localAddresses, sizes, flags, callback, params);
    }

    public UcpRequest recvStreamNonBlocking(long[] localAddresses, long[] sizes, long flags, UcxCallback callback, int memoryType) {
        UcxParams.checkArraySizes(localAddresses, sizes);
        return this.recvStreamNonBlocking(localAddresses, sizes, flags, callback, new UcpRequestParams().setMemoryType(memoryType));
    }

    public UcpRequest recvStreamNonBlocking(long[] localAddresses, long[] sizes, long flags, UcxCallback callback) {
        return this.recvStreamNonBlocking(localAddresses, sizes, flags, callback, null);
    }

    public UcpRequest recvStreamNonBlocking(ByteBuffer buffer, long flags, UcxCallback callback) {
        return this.recvStreamNonBlocking(UcxUtils.getAddress(buffer), buffer.remaining(), flags, callback);
    }

    public UcpRequest sendAmNonBlocking(int activeMessageId, long headerAddress, long headerLength, long dataAddress, long dataLength, long flags, UcxCallback callback, UcpRequestParams params) {
        return UcpEndpoint.sendAmNonBlockingNative(this.getNativeId(), activeMessageId, headerAddress, headerLength, dataAddress, dataLength, flags, callback, params);
    }

    public UcpRequest sendAmNonBlocking(int activeMessageId, long headerAddress, long headerLength, long dataAddress, long dataLength, long flags, UcxCallback callback, int memoryType) {
        return this.sendAmNonBlocking(activeMessageId, headerAddress, headerLength, dataAddress, dataLength, flags, callback, new UcpRequestParams().setMemoryType(memoryType));
    }

    public UcpRequest sendAmNonBlocking(int activeMessageId, long headerAddress, long headerLength, long dataAddress, long dataLength, long flags, UcxCallback callback) {
        return this.sendAmNonBlocking(activeMessageId, headerAddress, headerLength, dataAddress, dataLength, flags, callback, null);
    }

    public UcpRequest flushNonBlocking(UcxCallback callback) {
        return UcpEndpoint.flushNonBlockingNative(this.getNativeId(), callback);
    }

    public UcpRequest closeNonBlockingForce() {
        return UcpEndpoint.closeNonBlockingNative(this.getNativeId(), UcpConstants.UCP_EP_CLOSE_FLAG_FORCE);
    }

    public UcpRequest closeNonBlockingFlush() {
        return UcpEndpoint.closeNonBlockingNative(this.getNativeId(), 0);
    }

    private native long createEndpointNative(UcpEndpointParams var1, long var2);

    private static native void destroyEndpointNative(long var0);

    private static native UcpRemoteKey unpackRemoteKey(long var0, long var2);

    private static native UcpRequest putNonBlockingNative(long var0, long var2, long var4, long var6, long var8, UcxCallback var10, UcpRequestParams var11);

    private static native void putNonBlockingImplicitNative(long var0, long var2, long var4, long var6, long var8);

    private static native UcpRequest getNonBlockingNative(long var0, long var2, long var4, long var6, long var8, UcxCallback var10, UcpRequestParams var11);

    private static native void getNonBlockingImplicitNative(long var0, long var2, long var4, long var6, long var8);

    private static native UcpRequest sendTaggedNonBlockingNative(long var0, long var2, long var4, long var6, UcxCallback var8, UcpRequestParams var9);

    private static native UcpRequest sendTaggedIovNonBlockingNative(long var0, long[] var2, long[] var3, long var4, UcxCallback var6, UcpRequestParams var7);

    private static native UcpRequest sendStreamNonBlockingNative(long var0, long var2, long var4, UcxCallback var6, UcpRequestParams var7);

    private static native UcpRequest sendStreamIovNonBlockingNative(long var0, long[] var2, long[] var3, UcxCallback var4, UcpRequestParams var5);

    private static native UcpRequest recvStreamNonBlockingNative(long var0, long var2, long var4, long var6, UcxCallback var8, UcpRequestParams var9);

    private static native UcpRequest recvStreamIovNonBlockingNative(long var0, long[] var2, long[] var3, long var4, UcxCallback var6, UcpRequestParams var7);

    private static native UcpRequest sendAmNonBlockingNative(long var0, int var2, long var3, long var5, long var7, long var9, long var11, UcxCallback var13, UcpRequestParams var14);

    private static native UcpRequest flushNonBlockingNative(long var0, UcxCallback var2);

    private static native UcpRequest closeNonBlockingNative(long var0, int var2);
}

