/*
 * Decompiled with CFR 0.152.
 */
package org.openucx.jucx.ucp;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.openucx.jucx.UcxCallback;
import org.openucx.jucx.UcxException;
import org.openucx.jucx.UcxNativeStruct;
import org.openucx.jucx.UcxParams;
import org.openucx.jucx.UcxUtils;
import org.openucx.jucx.ucp.UcpAmRecvCallback;
import org.openucx.jucx.ucp.UcpContext;
import org.openucx.jucx.ucp.UcpEndpoint;
import org.openucx.jucx.ucp.UcpEndpointParams;
import org.openucx.jucx.ucp.UcpListener;
import org.openucx.jucx.ucp.UcpListenerParams;
import org.openucx.jucx.ucp.UcpRequest;
import org.openucx.jucx.ucp.UcpRequestParams;
import org.openucx.jucx.ucp.UcpTagMessage;
import org.openucx.jucx.ucp.UcpWorkerParams;

public class UcpWorker
extends UcxNativeStruct
implements Closeable {
    private final HashMap<Integer, Object[]> amRecvHandlers = new HashMap();
    private long maxAmHeaderSize = 0L;

    public UcpWorker(UcpContext context, UcpWorkerParams params) {
        this.setNativeId(this.createWorkerNative(params, context.getNativeId()));
    }

    public UcpEndpoint newEndpoint(UcpEndpointParams params) {
        return new UcpEndpoint(this, params);
    }

    public UcpListener newListener(UcpListenerParams params) {
        return new UcpListener(this, params);
    }

    @Override
    public void close() {
        UcpWorker.releaseWorkerNative(this.getNativeId());
        this.setNativeId(null);
        this.amRecvHandlers.clear();
    }

    public long getMaxAmHeaderSize() {
        return this.maxAmHeaderSize;
    }

    public void setAmRecvHandler(int amId, UcpAmRecvCallback callback, long flags) {
        if (callback == null) {
            this.removeAmRecvHandler(amId);
            return;
        }
        Object[] callbackAndWorker = new Object[]{callback, this};
        this.amRecvHandlers.put(amId, callbackAndWorker);
        UcpWorker.setAmRecvHandlerNative(this.getNativeId(), amId, callbackAndWorker, flags);
    }

    public void setAmRecvHandler(int amId, UcpAmRecvCallback callback) {
        this.setAmRecvHandler(amId, callback, 0L);
    }

    public void removeAmRecvHandler(int amId) {
        this.amRecvHandlers.remove(amId);
        UcpWorker.setAmRecvHandlerNative(this.getNativeId(), amId, null, 0L);
    }

    public void amDataRelease(long address) {
        UcpWorker.amDataReleaseNative(this.getNativeId(), address);
    }

    public UcpRequest recvAmDataNonBlocking(long dataDesc, long address, long size, UcxCallback callback, UcpRequestParams params) {
        return UcpWorker.recvAmDataNonBlockingNative(this.getNativeId(), dataDesc, address, size, callback, params);
    }

    public UcpRequest recvAmDataNonBlocking(long dataDesc, long address, long size, UcxCallback callback, int memoryType) {
        return this.recvAmDataNonBlocking(dataDesc, address, size, callback, new UcpRequestParams().setMemoryType(memoryType));
    }

    public int progress() throws Exception {
        return UcpWorker.progressWorkerNative(this.getNativeId());
    }

    public void progressRequest(UcpRequest request) throws Exception {
        while (!request.isCompleted()) {
            this.progress();
        }
    }

    public UcpRequest flushNonBlocking(UcxCallback callback) {
        return UcpWorker.flushNonBlockingNative(this.getNativeId(), callback);
    }

    public void waitForEvents() {
        UcpWorker.waitWorkerNative(this.getNativeId());
    }

    public void signal() {
        UcpWorker.signalWorkerNative(this.getNativeId());
    }

    public void arm() {
        UcpWorker.armWorkerNative(this.getNativeId());
    }

    public int getEventFD() {
        return UcpWorker.getEventFDNative(this.getNativeId());
    }

    public UcpRequest recvTaggedNonBlocking(ByteBuffer recvBuffer, long tag, long tagMask, UcxCallback callback) {
        if (!recvBuffer.isDirect()) {
            throw new UcxException("Recv buffer must be direct.");
        }
        return this.recvTaggedNonBlocking(UcxUtils.getAddress(recvBuffer), recvBuffer.remaining(), tag, tagMask, callback);
    }

    public UcpRequest recvTaggedNonBlocking(long localAddress, long size, long tag, long tagMask, UcxCallback callback) {
        return this.recvTaggedNonBlocking(localAddress, size, tag, tagMask, callback, null);
    }

    public UcpRequest recvTaggedNonBlocking(long localAddress, long size, long tag, long tagMask, UcxCallback callback, int memoryType) {
        return this.recvTaggedNonBlocking(localAddress, size, tag, tagMask, callback, new UcpRequestParams().setMemoryType(memoryType));
    }

    public UcpRequest recvTaggedNonBlocking(long localAddress, long size, long tag, long tagMask, UcxCallback callback, UcpRequestParams params) {
        return UcpWorker.recvTaggedNonBlockingNative(this.getNativeId(), localAddress, size, tag, tagMask, callback, params);
    }

    public UcpRequest recvTaggedNonBlocking(ByteBuffer recvBuffer, UcxCallback callback) {
        return this.recvTaggedNonBlocking(recvBuffer, 0L, 0L, callback);
    }

    public UcpRequest recvTaggedNonBlocking(long[] localAddresses, long[] sizes, long tag, long tagMask, UcxCallback callback) {
        return this.recvTaggedNonBlocking(localAddresses, sizes, tag, tagMask, callback, null);
    }

    public UcpRequest recvTaggedNonBlocking(long[] localAddresses, long[] sizes, long tag, long tagMask, UcxCallback callback, UcpRequestParams params) {
        UcxParams.checkArraySizes(localAddresses, sizes);
        return UcpWorker.recvTaggedIovNonBlockingNative(this.getNativeId(), localAddresses, sizes, tag, tagMask, callback, params);
    }

    public UcpRequest recvTaggedNonBlocking(long[] localAddresses, long[] sizes, long tag, long tagMask, UcxCallback callback, int memoryType) {
        UcxParams.checkArraySizes(localAddresses, sizes);
        return this.recvTaggedNonBlocking(localAddresses, sizes, tag, tagMask, callback, new UcpRequestParams().setMemoryType(memoryType));
    }

    public UcpTagMessage tagProbeNonBlocking(long tag, long tagMask, boolean remove) {
        return UcpWorker.tagProbeNonBlockingNative(this.getNativeId(), tag, tagMask, remove);
    }

    public UcpRequest recvTaggedMessageNonBlocking(long address, long size, UcpTagMessage message, UcxCallback callback, UcpRequestParams params) {
        return UcpWorker.recvTaggedMessageNonBlockingNative(this.getNativeId(), address, size, message.getNativeId(), callback, params);
    }

    public UcpRequest recvTaggedMessageNonBlocking(long address, long size, UcpTagMessage message, UcxCallback callback, int memoryType) {
        return this.recvTaggedMessageNonBlocking(address, size, message, callback, new UcpRequestParams().setMemoryType(memoryType));
    }

    public UcpRequest recvTaggedMessageNonBlocking(long address, long size, UcpTagMessage message, UcxCallback callback) {
        return this.recvTaggedMessageNonBlocking(address, size, message, callback, null);
    }

    public UcpRequest recvTaggedMessageNonBlocking(ByteBuffer buffer, UcpTagMessage message, UcxCallback callback) {
        return this.recvTaggedMessageNonBlocking(UcxUtils.getAddress(buffer), buffer.remaining(), message, callback);
    }

    public void cancelRequest(UcpRequest request) {
        if (request.getNativeId() == null) {
            throw new UcxException("Request is not valid");
        }
        UcpWorker.cancelRequestNative(this.getNativeId(), request.getNativeId());
    }

    public ByteBuffer getAddress() {
        ByteBuffer nativeUcpAddress = UcpWorker.workerGetAddressNative(this.getNativeId());
        ByteBuffer result = ByteBuffer.allocateDirect(nativeUcpAddress.capacity());
        result.put(nativeUcpAddress);
        result.clear();
        UcpWorker.releaseAddressNative(this.getNativeId(), nativeUcpAddress);
        return result;
    }

    private native long createWorkerNative(UcpWorkerParams var1, long var2);

    private static native void releaseWorkerNative(long var0);

    private static native ByteBuffer workerGetAddressNative(long var0);

    private static native void releaseAddressNative(long var0, ByteBuffer var2);

    private static native int progressWorkerNative(long var0) throws Exception;

    private static native UcpRequest flushNonBlockingNative(long var0, UcxCallback var2);

    private static native void waitWorkerNative(long var0);

    private static native void signalWorkerNative(long var0);

    private static native void armWorkerNative(long var0);

    private static native int getEventFDNative(long var0);

    private static native void setAmRecvHandlerNative(long var0, int var2, Object[] var3, long var4);

    private static native UcpRequest recvAmDataNonBlockingNative(long var0, long var2, long var4, long var6, UcxCallback var8, UcpRequestParams var9);

    private static native void amDataReleaseNative(long var0, long var2);

    private static native UcpRequest recvTaggedNonBlockingNative(long var0, long var2, long var4, long var6, long var8, UcxCallback var10, UcpRequestParams var11);

    private static native UcpRequest recvTaggedIovNonBlockingNative(long var0, long[] var2, long[] var3, long var4, long var6, UcxCallback var8, UcpRequestParams var9);

    private static native UcpTagMessage tagProbeNonBlockingNative(long var0, long var2, long var4, boolean var6);

    private static native UcpRequest recvTaggedMessageNonBlockingNative(long var0, long var2, long var4, long var6, UcxCallback var8, UcpRequestParams var9);

    private static native void cancelRequestNative(long var0, long var2);
}

