/*
 * Decompiled with CFR 0.152.
 */
package org.openucx.jucx.ucs;

import org.openucx.jucx.NativeLibs;

public class UcsConstants {
    private static void load() {
        NativeLibs.load();
        UcsConstants.loadConstants();
    }

    private static native void loadConstants();

    static {
        UcsConstants.load();
    }

    public static class MEMORY_TYPE {
        public static int UCS_MEMORY_TYPE_HOST;
        public static int UCS_MEMORY_TYPE_CUDA;
        public static int UCS_MEMORY_TYPE_CUDA_MANAGED;
        public static int UCS_MEMORY_TYPE_ROCM;
        public static int UCS_MEMORY_TYPE_ROCM_MANAGED;
        public static int UCS_MEMORY_TYPE_LAST;
        public static int UCS_MEMORY_TYPE_UNKNOWN;

        public static boolean isMemTypeSupported(long mask, int memoryType) {
            return (1L << memoryType & mask) != 0L;
        }

        static {
            UcsConstants.load();
        }
    }

    public static class STATUS {
        public static int UCS_OK;
        public static int UCS_INPROGRESS;
        public static int UCS_ERR_NO_MESSAGE;
        public static int UCS_ERR_NO_RESOURCE;
        public static int UCS_ERR_IO_ERROR;
        public static int UCS_ERR_NO_MEMORY;
        public static int UCS_ERR_INVALID_PARAM;
        public static int UCS_ERR_UNREACHABLE;
        public static int UCS_ERR_INVALID_ADDR;
        public static int UCS_ERR_NOT_IMPLEMENTED;
        public static int UCS_ERR_MESSAGE_TRUNCATED;
        public static int UCS_ERR_NO_PROGRESS;
        public static int UCS_ERR_BUFFER_TOO_SMALL;
        public static int UCS_ERR_NO_ELEM;
        public static int UCS_ERR_SOME_CONNECTS_FAILED;
        public static int UCS_ERR_NO_DEVICE;
        public static int UCS_ERR_BUSY;
        public static int UCS_ERR_CANCELED;
        public static int UCS_ERR_SHMEM_SEGMENT;
        public static int UCS_ERR_ALREADY_EXISTS;
        public static int UCS_ERR_OUT_OF_RANGE;
        public static int UCS_ERR_TIMED_OUT;
        public static int UCS_ERR_EXCEEDS_LIMIT;
        public static int UCS_ERR_UNSUPPORTED;
        public static int UCS_ERR_REJECTED;
        public static int UCS_ERR_NOT_CONNECTED;
        public static int UCS_ERR_CONNECTION_RESET;
        public static int UCS_ERR_FIRST_LINK_FAILURE;
        public static int UCS_ERR_LAST_LINK_FAILURE;
        public static int UCS_ERR_FIRST_ENDPOINT_FAILURE;
        public static int UCS_ERR_ENDPOINT_TIMEOUT;
        public static int UCS_ERR_LAST_ENDPOINT_FAILURE;
        public static int UCS_ERR_LAST;

        static {
            UcsConstants.load();
        }
    }

    public static class ThreadMode {
        public static int UCS_THREAD_MODE_MULTI;

        static {
            UcsConstants.load();
        }
    }
}

