/*
 * Decompiled with CFR 0.152.
 */
package org.openucx.jucx.examples;

import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.openucx.jucx.UcxException;
import org.openucx.jucx.UcxUtils;
import org.openucx.jucx.examples.UcxBenchmark;
import org.openucx.jucx.ucp.UcpEndpoint;
import org.openucx.jucx.ucp.UcpEndpointParams;
import org.openucx.jucx.ucp.UcpMemory;
import org.openucx.jucx.ucs.UcsConstants;

public class UcxReadBWBenchmarkSender
extends UcxBenchmark {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (!UcxReadBWBenchmarkSender.initializeArguments(args)) {
            return;
        }
        UcxReadBWBenchmarkSender.createContextAndWorker();
        String serverHost = (String)argsMap.get("s");
        UcpEndpoint endpoint = worker.newEndpoint(new UcpEndpointParams().setPeerErrorHandlingMode().setErrorHandler((ep, status, errorMsg) -> {
            if (status == UcsConstants.STATUS.UCS_ERR_CONNECTION_RESET) {
                throw new ConnectException(errorMsg);
            }
            throw new UcxException(errorMsg);
        }).setSocketAddress(new InetSocketAddress(serverHost, serverPort)));
        UcpMemory memory = context.memoryMap(allocationParams);
        resources.push(memory);
        ByteBuffer data = UcxUtils.getByteBufferView(memory.getAddress(), Math.min(Integer.MAX_VALUE, totalSize));
        ByteBuffer rkeyBuffer = memory.getRemoteKeyBuffer();
        ByteBuffer sendData = ByteBuffer.allocateDirect(24 + rkeyBuffer.capacity());
        sendData.putLong(memory.getAddress());
        sendData.putLong(totalSize);
        sendData.putInt(rkeyBuffer.capacity());
        sendData.put(rkeyBuffer);
        sendData.putInt(data.hashCode());
        sendData.clear();
        endpoint.sendTaggedNonBlocking(sendData, null);
        try {
            while (true) {
                if (worker.progress() != 0) {
                    continue;
                }
                worker.waitForEvents();
            }
        }
        catch (ConnectException connectException) {
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
        try {
            worker.progressRequest(endpoint.closeNonBlockingForce());
        }
        catch (Exception exception) {
        }
        finally {
            UcxReadBWBenchmarkSender.closeResources();
        }
    }
}

