package org.openxri.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HeaderElementIterator;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.HttpVersion;
import org.apache.http.impl.cookie.DateParseException;
import org.apache.http.impl.cookie.DateUtils;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.message.BasicHttpResponse;


public class ResolvedHttpResponse {
	private static org.apache.commons.logging.Log log =
		org.apache.commons.logging.LogFactory.getLog(ResolvedHttpResponse.class.getName());

	protected InputStream is;
	
	protected HttpResponse resp;


	/**
	 * constructor for dummy data (creates a fake http response)
	 * @param is
	 */
	public ResolvedHttpResponse(InputStream is) {
		this.resp = constructHttpResponse(HttpVersion.HTTP_1_1, HttpStatus.SC_OK, "OK", new HashMap<String, List<String>>());
		this.is = is;
	}

	/**
	 * Convenience constructor that takes a URL Connection
	 * @param conn
	 * @param is
	 * @throws IOException 
	 */
	public ResolvedHttpResponse(HttpURLConnection conn, InputStream is) throws IOException {
		this.resp = constructHttpResponse(HttpVersion.HTTP_1_1, conn.getResponseCode(), conn.getResponseMessage(), conn.getHeaderFields());
		this.is = is;
	}


	private static HttpResponse constructHttpResponse(HttpVersion httpVersion, int respCode, String respMessage, Map<String, List<String>> fields) {
		HttpResponse resp = new BasicHttpResponse(HttpVersion.HTTP_1_1, respCode, respMessage);
		for (String headerKey: fields.keySet()) {
			if (headerKey == null) // HttpURLConnection uses this to store the status
				continue;
			
			List<String> values = fields.get(headerKey);
			for (String v: values) {
				resp.addHeader(headerKey, v);
			}
		}
		return resp;
	}

	/**
	 * @return the fields
	 */
	/*
	public Map<String, List<String>> getFields() {
		return fields;
	}
	*/

	/**
	 * @return the InputStream
	 */
	public InputStream getInputStream() {
		return is;
	}

	
	public Date getExpires() {
		Header expiresHeader = resp.getFirstHeader("Expires");
		if (expiresHeader == null)
			return null;

		try {
			return DateUtils.parseDate(expiresHeader.getValue());
		} catch (DateParseException e) {
			log.warn("error while parsing Expires header", e);
			return null;
		}
	}
	
	
	public Map<String, Integer> getCacheControl() {
		Map<String, Integer> out = new HashMap<String, Integer>();
		HeaderElementIterator it = new BasicHeaderElementIterator(
				this.resp.headerIterator("Cache-Control"));
		while (it.hasNext()) {
		    HeaderElement elem = it.nextElement();
		    String elemName = elem.getName().toLowerCase();
		    Integer v = null;
		    if (elemName.equals("max-age") || elemName.equals("s-maxage")) {
		    	v = new Integer(elem.getValue());
		    }
		    out.put(elemName, v);
		}
		return out;
	}
	
	// NOTES:
	// - public (if this is present, apply default TTL)
	// - private (if it says this, no caching, even if it only applies to certain part)
	// - no-cache (as above)
	// - no-store (should we care?)
	// - max-age=secs (If a response includes both an Expires header and a max-age
	//   directive, the max-age directive overrides the Expires header, 
	//   even if the Expires header is more restrictive. This rule allows an origin
	//   server to provide a longer expiration time to an HTTP/1.1 cache than to a 1.0 cache
	// - s-maxage=secs (override max-age or Expires)
}
