/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.impl;

import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.channels.AsynchronousSocketChannel;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openziti.Errors;
import org.openziti.ZitiAddress;
import org.openziti.ZitiConnection;
import org.openziti.ZitiContext;
import org.openziti.ZitiException;
import org.openziti.identity.Enroller;
import org.openziti.identity.KeyStoreIdentity;
import org.openziti.identity.UtilKt;
import org.openziti.impl.ZitiContextImpl;
import org.openziti.impl.ZitiImpl;
import org.openziti.net.dns.ZitiDNSManager;
import org.openziti.net.internal.Sockets;
import org.openziti.util.Logged;
import org.openziti.util.Version;
import org.openziti.util.ZitiLog;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010 \n\u0002\b\u000e\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0011\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0004H\u0096\u0001J\u001b\u0010\u001b\u001a\u00020\u001c2\u0010\u0010\u001d\u001a\f\u0012\u0004\u0012\u00020\u00040\u001ej\u0002`\u001fH\u0096\u0001J\u0011\u0010 \u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0004H\u0096\u0001J\u0019\u0010 \u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"H\u0096\u0001J%\u0010 \u001a\u00020\u001c2\b\u0010#\u001a\u0004\u0018\u00010\"2\u0010\u0010\u001d\u001a\f\u0012\u0004\u0012\u00020\u00040\u001ej\u0002`\u001fH\u0096\u0001J\u001b\u0010 \u001a\u00020\u001c2\u0010\u0010\u001d\u001a\f\u0012\u0004\u0012\u00020\u00040\u001ej\u0002`\u001fH\u0096\u0001J\u001e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0004J\u0011\u0010+\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0004H\u0096\u0001J\u001b\u0010+\u001a\u00020\u001c2\u0010\u0010\u001d\u001a\f\u0012\u0004\u0012\u00020\u00040\u001ej\u0002`\u001fH\u0096\u0001J\u001e\u0010,\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u0012J\u001c\u0010,\u001a\b\u0012\u0004\u0012\u00020%022\u0006\u0010&\u001a\u00020'2\u0006\u00101\u001a\u00020\u0012J\b\u00103\u001a\u00020\u001cH\u0002J\u0018\u00104\u001a\u00020\u00122\u0006\u0010&\u001a\u00020'2\u0006\u00105\u001a\u00020\u0004H\u0002J'\u00106\u001a\u00020\u000e2\u0006\u00107\u001a\u00020.2\u0006\u0010/\u001a\u0002002\b\u00105\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b8J\u001f\u00106\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020'2\b\u00105\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b8J\u000e\u00109\u001a\u00020\u001c2\u0006\u0010:\u001a\u00020%J\u0016\u0010;\u001a\u00020\u001c2\u0006\u0010<\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u0004J\u0011\u0010!\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0004H\u0096\u0001J\u001b\u0010!\u001a\u00020\u001c2\u0010\u0010\u001d\u001a\f\u0012\u0004\u0012\u00020\u00040\u001ej\u0002`\u001fH\u0096\u0001J\u0011\u0010>\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0004H\u0096\u0001J\u001b\u0010>\u001a\u00020\u001c2\u0010\u0010\u001d\u001a\f\u0012\u0004\u0012\u00020\u00040\u001ej\u0002`\u001fH\u0096\u0001J\u0011\u0010?\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0004H\u0096\u0001J\u001b\u0010?\u001a\u00020\u001c2\u0010\u0010\u001d\u001a\f\u0012\u0004\u0012\u00020\u00040\u001ej\u0002`\u001fH\u0096\u0001R\u001a\u0010\u0003\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0011\u001a\u00020\u00128@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006@"}, d2={"Lorg/openziti/impl/ZitiImpl;", "Lorg/openziti/util/Logged;", "()V", "appId", "", "getAppId$ziti", "()Ljava/lang/String;", "setAppId$ziti", "(Ljava/lang/String;)V", "appVersion", "getAppVersion$ziti", "setAppVersion$ziti", "contexts", "", "Lorg/openziti/impl/ZitiContextImpl;", "getContexts$ziti", "()Ljava/util/List;", "onAndroid", "", "getOnAndroid$ziti", "()Z", "onAndroid$delegate", "Lkotlin/Lazy;", "connect", "Lorg/openziti/ZitiConnection;", "addr", "Ljava/net/SocketAddress;", "d", "", "msg", "Lkotlin/Function0;", "Lorg/openziti/util/LogMsg;", "e", "t", "", "ex", "enroll", "Lorg/openziti/ZitiContext;", "ks", "Ljava/security/KeyStore;", "jwt", "", "name", "i", "init", "file", "Ljava/io/File;", "pwd", "", "seamless", "", "initInternalNetworking", "isZitiIdentity", "alias", "loadContext", "idFile", "loadContext$ziti", "removeContext", "ctx", "setApplicationInfo", "id", "version", "v", "w", "ziti"})
public final class ZitiImpl
implements Logged {
    @NotNull
    private static final List<ZitiContextImpl> contexts;
    @NotNull
    private static String appId;
    @NotNull
    private static String appVersion;
    @NotNull
    private static final Lazy onAndroid$delegate;
    @NotNull
    public static final ZitiImpl INSTANCE;
    private final /* synthetic */ ZitiLog $$delegate_0;

    @NotNull
    public final List<ZitiContextImpl> getContexts$ziti() {
        return contexts;
    }

    @NotNull
    public final String getAppId$ziti() {
        return appId;
    }

    public final void setAppId$ziti(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        appId = string;
    }

    @NotNull
    public final String getAppVersion$ziti() {
        return appVersion;
    }

    public final void setAppVersion$ziti(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        appVersion = string;
    }

    public final boolean getOnAndroid$ziti() {
        Lazy lazy = onAndroid$delegate;
        ZitiImpl zitiImpl = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    @NotNull
    public final ZitiContextImpl loadContext$ziti(@NotNull KeyStore ks, @Nullable String alias) {
        Intrinsics.checkNotNullParameter((Object)ks, (String)"ks");
        String string = alias;
        if (string == null) {
            string = UtilKt.findIdentityAlias(ks);
        }
        String idName = string;
        KeyStoreIdentity id = new KeyStoreIdentity(ks, idName, null, 4, null);
        ZitiContextImpl zitiContextImpl = new ZitiContextImpl(id, true);
        boolean bl = false;
        boolean bl2 = false;
        ZitiContextImpl it = zitiContextImpl;
        boolean bl3 = false;
        contexts.add(it);
        return zitiContextImpl;
    }

    @NotNull
    public final ZitiContextImpl loadContext$ziti(@NotNull File idFile, @NotNull char[] pwd, @Nullable String alias) {
        Intrinsics.checkNotNullParameter((Object)idFile, (String)"idFile");
        Intrinsics.checkNotNullParameter((Object)pwd, (String)"pwd");
        KeyStore ks = UtilKt.loadKeystore(idFile, pwd);
        return this.loadContext$ziti(ks, alias);
    }

    public final void init(@NotNull File file, @NotNull char[] pwd, boolean seamless) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)pwd, (String)"pwd");
        if (seamless) {
            this.initInternalNetworking();
        }
        ZitiContextImpl ctx = this.loadContext$ziti(file, pwd, null);
        ctx.checkServicesLoaded();
    }

    public final void removeContext(@NotNull ZitiContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Collection collection = contexts;
        boolean bl = false;
        Collection collection2 = collection;
        if (collection2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableCollection<T>");
        }
        TypeIntrinsics.asMutableCollection((Object)collection2).remove(ctx);
        if (ctx instanceof ZitiContextImpl) {
            ctx.destroy();
        }
    }

    @NotNull
    public final List<ZitiContext> init(@NotNull KeyStore ks, boolean seamless) {
        Intrinsics.checkNotNullParameter((Object)ks, (String)"ks");
        if (seamless) {
            this.initInternalNetworking();
        }
        Enumeration<String> enumeration = ks.aliases();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"ks.aliases()");
        Iterator iterator = CollectionsKt.iterator(enumeration);
        while (iterator.hasNext()) {
            String a;
            String string = a = (String)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"a");
            if (!this.isZitiIdentity(ks, string)) continue;
            this.loadContext$ziti(ks, a);
        }
        return contexts;
    }

    private final boolean isZitiIdentity(KeyStore ks, String alias) {
        if (!ks.isKeyEntry(alias)) {
            return false;
        }
        try {
            URI uRI = URI.create(alias);
            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"URI.create(alias)");
            return Intrinsics.areEqual((Object)uRI.getScheme(), (Object)"ziti");
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    private final void initInternalNetworking() {
        Sockets.INSTANCE.init();
    }

    @NotNull
    public final ZitiContext enroll(@NotNull KeyStore ks, @NotNull byte[] jwt, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)ks, (String)"ks");
        Intrinsics.checkNotNullParameter((Object)jwt, (String)"jwt");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        boolean bl = false;
        Enroller enroller = Enroller.Companion.fromJWT(new String(jwt, Charsets.UTF_8));
        String alias = enroller.enroll(null, ks, name);
        return this.loadContext$ziti(ks, alias);
    }

    @NotNull
    public final ZitiConnection connect(@NotNull SocketAddress addr) {
        Intrinsics.checkNotNullParameter((Object)addr, (String)"addr");
        SocketAddress socketAddress = addr;
        if (socketAddress instanceof InetSocketAddress) {
            String serviceId = ZitiDNSManager.INSTANCE.getServiceIdByAddr((InetSocketAddress)addr);
            if (serviceId != null) {
                for (ZitiContextImpl c : contexts) {
                    try {
                        return c.dialById$ziti(serviceId);
                    }
                    catch (Exception ex) {
                        this.d((Function0<String>)((Function0)new Function0<String>(addr, c){
                            final /* synthetic */ SocketAddress $addr;
                            final /* synthetic */ ZitiContextImpl $c;

                            @NotNull
                            public final String invoke() {
                                return "service @[" + this.$addr + "] not available for " + this.$c.name();
                            }
                            {
                                this.$addr = socketAddress;
                                this.$c = zitiContextImpl;
                                super(0);
                            }
                        }));
                    }
                }
            } else {
                for (ZitiContextImpl c : contexts) {
                    try {
                        String string = ((InetSocketAddress)addr).getHostName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"addr.hostName");
                        return c.dial$ziti(string, ((InetSocketAddress)addr).getPort());
                    }
                    catch (Exception ex) {
                        this.d((Function0<String>)((Function0)new Function0<String>(addr, c){
                            final /* synthetic */ SocketAddress $addr;
                            final /* synthetic */ ZitiContextImpl $c;

                            @NotNull
                            public final String invoke() {
                                return "service @[" + this.$addr + "] not available for " + this.$c.name();
                            }
                            {
                                this.$addr = socketAddress;
                                this.$c = zitiContextImpl;
                                super(0);
                            }
                        }));
                    }
                }
            }
            this.e((Function0<String>)((Function0)new Function0<String>(addr){
                final /* synthetic */ SocketAddress $addr;

                @NotNull
                public final String invoke() {
                    return "service @[" + this.$addr + "] not available in any contexts";
                }
                {
                    this.$addr = socketAddress;
                    super(0);
                }
            }));
            throw (Throwable)new ZitiException(Errors.ServiceNotAvailable.INSTANCE, null, 2, null);
        }
        if (socketAddress instanceof ZitiAddress.Dial) {
            for (ZitiContextImpl c : contexts) {
                try {
                    AsynchronousSocketChannel asynchronousSocketChannel = c.open();
                    boolean bl = false;
                    boolean bl2 = false;
                    AsynchronousSocketChannel $this$apply = asynchronousSocketChannel;
                    boolean bl3 = false;
                    $this$apply.connect(addr).get();
                    AsynchronousSocketChannel asynchronousSocketChannel2 = asynchronousSocketChannel;
                    if (asynchronousSocketChannel2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.openziti.ZitiConnection");
                    }
                    return (ZitiConnection)((Object)asynchronousSocketChannel2);
                }
                catch (Exception ex) {
                    this.i((Function0<String>)((Function0)new Function0<String>(addr, c){
                        final /* synthetic */ SocketAddress $addr;
                        final /* synthetic */ ZitiContextImpl $c;

                        @NotNull
                        public final String invoke() {
                            return "service @[" + this.$addr + "] not available for " + this.$c.name();
                        }
                        {
                            this.$addr = socketAddress;
                            this.$c = zitiContextImpl;
                            super(0);
                        }
                    }));
                }
            }
            this.e((Function0<String>)((Function0)new Function0<String>(addr){
                final /* synthetic */ SocketAddress $addr;

                @NotNull
                public final String invoke() {
                    return "service @[" + this.$addr + "] not available in any contexts";
                }
                {
                    this.$addr = socketAddress;
                    super(0);
                }
            }));
            throw (Throwable)new ZitiException(Errors.ServiceNotAvailable.INSTANCE, null, 2, null);
        }
        String string = "unsupported address type";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    public final void setApplicationInfo(@NotNull String id, @NotNull String version2) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        appId = id;
        appVersion = version2;
    }

    private ZitiImpl() {
        this.$$delegate_0 = new ZitiLog();
    }

    static {
        ZitiImpl zitiImpl;
        INSTANCE = zitiImpl = new ZitiImpl();
        boolean bl = false;
        contexts = new ArrayList();
        appId = "";
        appVersion = "";
        onAndroid$delegate = LazyKt.lazy((Function0)onAndroid.2.INSTANCE);
        zitiImpl.i("ZitiSDK version " + Version.INSTANCE.getVersion() + " @" + Version.INSTANCE.getRevision() + '(' + Version.INSTANCE.getBranch() + ')');
    }

    @Override
    public void d(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.$$delegate_0.d(msg);
    }

    @Override
    public void d(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.$$delegate_0.d(msg);
    }

    @Override
    public void e(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.$$delegate_0.e(msg);
    }

    @Override
    public void e(@NotNull String msg, @NotNull Throwable t2) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Intrinsics.checkNotNullParameter((Object)t2, (String)"t");
        this.$$delegate_0.e(msg, t2);
    }

    @Override
    public void e(@Nullable Throwable ex, @NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.$$delegate_0.e(ex, msg);
    }

    @Override
    public void e(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.$$delegate_0.e(msg);
    }

    @Override
    public void i(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.$$delegate_0.i(msg);
    }

    @Override
    public void i(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.$$delegate_0.i(msg);
    }

    @Override
    public void t(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.$$delegate_0.t(msg);
    }

    @Override
    public void t(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.$$delegate_0.t(msg);
    }

    @Override
    public void v(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.$$delegate_0.v(msg);
    }

    @Override
    public void v(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.$$delegate_0.v(msg);
    }

    @Override
    public void w(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.$$delegate_0.w(msg);
    }

    @Override
    public void w(@NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        this.$$delegate_0.w(msg);
    }
}

