/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.net.dns;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.bouncycastle.util.IPAddress;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openziti.api.Service;
import org.openziti.api.ServiceDNS;
import org.openziti.net.dns.DNSResolver;
import org.openziti.net.dns.ServiceMapper;
import org.openziti.net.dns.ZitiDNSManager;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001d\u001a\u00020\nH\u0016J\u0015\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b J\u0017\u0010!\u001a\u0004\u0018\u00010\n2\u0006\u0010\"\u001a\u00020#H\u0000\u00a2\u0006\u0002\b$J\u0012\u0010%\u001a\u0004\u0018\u00010\u00142\u0006\u0010&\u001a\u00020\u000bH\u0016J\u001c\u0010'\u001a\u00020(2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020(0*H\u0016J\u0016\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00100+H\u0016J\u0015\u0010,\u001a\u00020(2\u0006\u0010\"\u001a\u00020#H\u0000\u00a2\u0006\u0002\b-R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R \u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00140\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u0014\u0010\u0016\u001a\u00020\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R \u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\n0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\r\u00a8\u0006."}, d2={"Lorg/openziti/net/dns/ZitiDNSManager;", "Lorg/openziti/net/dns/DNSResolver;", "Lorg/openziti/net/dns/ServiceMapper;", "()V", "PREFIX", "", "getPREFIX$ziti", "()[B", "addr2serviceId", "", "Ljava/net/InetSocketAddress;", "", "getAddr2serviceId$ziti", "()Ljava/util/Map;", "dnsBroadCast", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lorg/openziti/net/dns/DNSResolver$DNSEvent;", "getDnsBroadCast$ziti", "()Lkotlinx/coroutines/flow/MutableSharedFlow;", "host2Ip", "Ljava/net/InetAddress;", "getHost2Ip$ziti", "postfix", "Ljava/util/concurrent/atomic/AtomicInteger;", "getPostfix$ziti", "()Ljava/util/concurrent/atomic/AtomicInteger;", "serviceId2addr", "getServiceId2addr$ziti", "getServiceIdByAddr", "addr", "nextAddr", "dnsname", "nextAddr$ziti", "registerService", "service", "Lorg/openziti/api/Service;", "registerService$ziti", "resolve", "hostname", "subscribe", "", "sub", "Lkotlin/Function1;", "Ljava/util/function/Consumer;", "unregisterService", "unregisterService$ziti", "ziti"})
public final class ZitiDNSManager
implements DNSResolver,
ServiceMapper {
    @NotNull
    private static final byte[] PREFIX;
    @NotNull
    private static final AtomicInteger postfix;
    @NotNull
    private static final Map<String, InetAddress> host2Ip;
    @NotNull
    private static final Map<InetSocketAddress, String> addr2serviceId;
    @NotNull
    private static final Map<String, InetSocketAddress> serviceId2addr;
    @NotNull
    private static final MutableSharedFlow<DNSResolver.DNSEvent> dnsBroadCast;
    @NotNull
    public static final ZitiDNSManager INSTANCE;

    @NotNull
    public final byte[] getPREFIX$ziti() {
        return PREFIX;
    }

    @NotNull
    public final AtomicInteger getPostfix$ziti() {
        return postfix;
    }

    @NotNull
    public final Map<String, InetAddress> getHost2Ip$ziti() {
        return host2Ip;
    }

    @NotNull
    public final Map<InetSocketAddress, String> getAddr2serviceId$ziti() {
        return addr2serviceId;
    }

    @NotNull
    public final Map<String, InetSocketAddress> getServiceId2addr$ziti() {
        return serviceId2addr;
    }

    @NotNull
    public final MutableSharedFlow<DNSResolver.DNSEvent> getDnsBroadCast$ziti() {
        return dnsBroadCast;
    }

    @Nullable
    public final InetSocketAddress registerService$ziti(@NotNull Service service) {
        block9: {
            Intrinsics.checkNotNullParameter((Object)service, (String)"service");
            Object object = service.getDns();
            if (object == null || (object = ((ServiceDNS)object).getHostname()) == null) break block9;
            Object object2 = object;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.getDefault()");
            Locale locale2 = locale;
            boolean bl = false;
            Object object3 = object2;
            boolean bl2 = false;
            Object object4 = object3;
            if (object4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string = ((String)object4).toLowerCase(locale2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toLowerCase(locale)");
            object = string;
            if (string != null) {
                InetAddress inetAddress;
                object2 = object;
                boolean bl3 = false;
                bl = false;
                Object hostname = object2;
                boolean bl4 = false;
                if (IPAddress.isValidIPv4((String)hostname)) {
                    inetAddress = Inet4Address.getByName((String)hostname);
                } else if (IPAddress.isValidIPv6((String)hostname)) {
                    inetAddress = Inet6Address.getByName((String)hostname);
                } else {
                    InetAddress inetAddress2;
                    Map<String, InetAddress> $this$getOrPut$iv = host2Ip;
                    boolean $i$f$getOrPut = false;
                    InetAddress value$iv = $this$getOrPut$iv.get(hostname);
                    if (value$iv == null) {
                        boolean bl5 = false;
                        InetAddress answer$iv = INSTANCE.nextAddr$ziti((String)hostname);
                        $this$getOrPut$iv.put((String)hostname, answer$iv);
                        inetAddress2 = answer$iv;
                    } else {
                        inetAddress2 = value$iv;
                    }
                    inetAddress = inetAddress2;
                }
                InetAddress ip = inetAddress;
                BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((String)hostname, ip, null){
                    int label;
                    final /* synthetic */ String $hostname;
                    final /* synthetic */ InetAddress $ip;

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                MutableSharedFlow<DNSResolver.DNSEvent> mutableSharedFlow = ZitiDNSManager.INSTANCE.getDnsBroadCast$ziti();
                                InetAddress inetAddress = this.$ip;
                                Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"ip");
                                this.label = 1;
                                Object object3 = mutableSharedFlow.emit((Object)new DNSResolver.DNSEvent(this.$hostname, inetAddress, false), (Continuation)this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.$hostname = string;
                        this.$ip = inetAddress;
                        super(2, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                        Intrinsics.checkNotNullParameter(completion, (String)"completion");
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        return function2;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)1, null);
                ServiceDNS serviceDNS = service.getDns();
                if (serviceDNS != null) {
                    int n = serviceDNS.getPort();
                    boolean bl6 = false;
                    boolean bl7 = false;
                    int port = n;
                    boolean bl8 = false;
                    InetSocketAddress addr = new InetSocketAddress(ip, port);
                    addr2serviceId.put(addr, service.getId$ziti());
                    serviceId2addr.put(service.getId$ziti(), addr);
                    return addr;
                }
            }
        }
        return null;
    }

    public final void unregisterService$ziti(@NotNull Service service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        InetSocketAddress addr = serviceId2addr.get(service.getId$ziti());
        if (addr != null) {
            addr2serviceId.remove(addr);
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Job>, Object>(service, addr, null){
                int label;
                final /* synthetic */ Service $service;
                final /* synthetic */ InetSocketAddress $addr;

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            return BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                                int label;
                                final /* synthetic */ unregisterService.1 this$0;

                                /*
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            MutableSharedFlow<DNSResolver.DNSEvent> mutableSharedFlow = ZitiDNSManager.INSTANCE.getDnsBroadCast$ziti();
                                            ServiceDNS serviceDNS = this.this$0.$service.getDns();
                                            String string = serviceDNS != null ? serviceDNS.getHostname() : null;
                                            InetAddress inetAddress = this.this$0.$addr.getAddress();
                                            Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"addr.address");
                                            this.label = 1;
                                            Object object3 = mutableSharedFlow.emit((Object)new DNSResolver.DNSEvent(string, inetAddress, true), (Continuation)this);
                                            if (object3 != object2) return Unit.INSTANCE;
                                            return object2;
                                        }
                                        case 1: {
                                            void $result;
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object3 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(2, continuation);
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                    Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                    return function2;
                                }

                                public final Object invoke(Object object, Object object2) {
                                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null);
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.$service = service;
                    this.$addr = inetSocketAddress;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkNotNullParameter(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Job>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        }
    }

    @Override
    @Nullable
    public InetAddress resolve(@NotNull String hostname) {
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        String string = hostname;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.getDefault()");
        Locale locale2 = locale;
        boolean bl = false;
        String string2 = string;
        boolean bl2 = false;
        String string3 = string2.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
        return host2Ip.get(string3);
    }

    @Override
    public void subscribe(@NotNull Function1<? super DNSResolver.DNSEvent, Unit> sub) {
        Intrinsics.checkNotNullParameter(sub, (String)"sub");
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(sub, null){
            int label;
            final /* synthetic */ Function1 $sub;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$collect$iv;
                        ResultKt.throwOnFailure((Object)object);
                        Flow flow = (Flow)ZitiDNSManager.INSTANCE.getDnsBroadCast$ziti();
                        subscribe.1 var3_4 = this;
                        boolean $i$f$collect = false;
                        this.label = 1;
                        Object object3 = $this$collect$iv.collect((FlowCollector)new FlowCollector<DNSResolver.DNSEvent>(this){
                            final /* synthetic */ subscribe.1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            @Nullable
                            public Object emit(Object value, @NotNull Continuation $completion) {
                                Continuation continuation = $completion;
                                DNSResolver.DNSEvent it = (DNSResolver.DNSEvent)value;
                                boolean bl = false;
                                Object object = this.this$0.$sub.invoke((Object)it);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)var3_4);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$collect = false;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.$sub = function1;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public void subscribe(@NotNull Consumer<DNSResolver.DNSEvent> sub) {
        Intrinsics.checkNotNullParameter(sub, (String)"sub");
        this.subscribe((Function1<? super DNSResolver.DNSEvent, Unit>)((Function1)new Function1<DNSResolver.DNSEvent, Unit>(sub){
            final /* synthetic */ Consumer $sub;

            public final void invoke(@NotNull DNSResolver.DNSEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$sub.accept(it);
            }
            {
                this.$sub = consumer;
                super(1);
            }
        }));
    }

    @Override
    @Nullable
    public String getServiceIdByAddr(@NotNull InetSocketAddress addr) {
        Intrinsics.checkNotNullParameter((Object)addr, (String)"addr");
        return addr2serviceId.get(addr);
    }

    @NotNull
    public final InetAddress nextAddr$ziti(@NotNull String dnsname) {
        Intrinsics.checkNotNullParameter((Object)dnsname, (String)"dnsname");
        int nextPostfix = postfix.incrementAndGet();
        if ((nextPostfix & 0xFF) == 0) {
            nextPostfix = postfix.incrementAndGet();
        }
        byte[] ip = ArraysKt.plus((byte[])PREFIX, (byte[])new byte[]{(byte)(nextPostfix >> 8 & 0xFF), (byte)(nextPostfix & 0xFF)});
        InetAddress inetAddress = InetAddress.getByAddress(dnsname, ip);
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"InetAddress.getByAddress(dnsname, ip)");
        return inetAddress;
    }

    private ZitiDNSManager() {
    }

    static {
        ZitiDNSManager zitiDNSManager;
        INSTANCE = zitiDNSManager = new ZitiDNSManager();
        PREFIX = new byte[]{(byte)169, (byte)254};
        postfix = new AtomicInteger(257);
        boolean bl = false;
        host2Ip = new LinkedHashMap();
        bl = false;
        addr2serviceId = new LinkedHashMap();
        bl = false;
        serviceId2addr = new LinkedHashMap();
        dnsBroadCast = SharedFlowKt.MutableSharedFlow$default((int)0, (int)0, null, (int)7, null);
    }
}

