/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.net.dns;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.bouncycastle.util.IPAddress;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openziti.net.dns.DNSResolver;
import org.openziti.net.dns.ZitiDNSManager;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000eH\u0002J\u0015\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u001cJ\r\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b\u001fJ\u0012\u0010 \u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001b\u001a\u00020\u000eH\u0016J\u001c\u0010!\u001a\u00020\u001e2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001e0#H\u0016J\u0016\u0010!\u001a\u00020\u001e2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0$H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/openziti/net/dns/ZitiDNSManager;", "Lorg/openziti/net/dns/DNSResolver;", "()V", "PREFIX", "", "getPREFIX$ziti", "()[B", "dnsBroadCast", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lorg/openziti/net/dns/DNSResolver$DNSEvent;", "getDnsBroadCast$ziti", "()Lkotlinx/coroutines/flow/MutableSharedFlow;", "host2Ip", "", "", "Ljava/net/InetAddress;", "getHost2Ip$ziti", "()Ljava/util/Map;", "postfix", "Ljava/util/concurrent/atomic/AtomicInteger;", "getPostfix$ziti", "()Ljava/util/concurrent/atomic/AtomicInteger;", "startPostfix", "", "nextAddr", "dnsname", "registerHostname", "hostname", "registerHostname$ziti", "reset", "", "reset$ziti", "resolve", "subscribe", "sub", "Lkotlin/Function1;", "Ljava/util/function/Consumer;", "ziti"})
public final class ZitiDNSManager
implements DNSResolver {
    @NotNull
    private static final byte[] PREFIX;
    public static final int startPostfix = 257;
    @NotNull
    private static final AtomicInteger postfix;
    @NotNull
    private static final Map<String, InetAddress> host2Ip;
    @NotNull
    private static final MutableSharedFlow<DNSResolver.DNSEvent> dnsBroadCast;
    @NotNull
    public static final ZitiDNSManager INSTANCE;

    @NotNull
    public final byte[] getPREFIX$ziti() {
        return PREFIX;
    }

    @NotNull
    public final AtomicInteger getPostfix$ziti() {
        return postfix;
    }

    @NotNull
    public final Map<String, InetAddress> getHost2Ip$ziti() {
        return host2Ip;
    }

    @NotNull
    public final MutableSharedFlow<DNSResolver.DNSEvent> getDnsBroadCast$ziti() {
        return dnsBroadCast;
    }

    @NotNull
    public final InetAddress registerHostname$ziti(@NotNull String hostname) {
        InetAddress inetAddress;
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        if (IPAddress.isValidIPv4((String)hostname)) {
            inetAddress = Inet4Address.getByName(hostname);
        } else if (IPAddress.isValidIPv6((String)hostname)) {
            inetAddress = Inet6Address.getByName(hostname);
        } else {
            InetAddress inetAddress2;
            Map<String, InetAddress> $this$getOrPut$iv = host2Ip;
            boolean $i$f$getOrPut = false;
            InetAddress value$iv = $this$getOrPut$iv.get(hostname);
            if (value$iv == null) {
                boolean bl = false;
                InetAddress answer$iv = INSTANCE.nextAddr(hostname);
                $this$getOrPut$iv.put(hostname, answer$iv);
                inetAddress2 = answer$iv;
            } else {
                inetAddress2 = value$iv;
            }
            inetAddress = inetAddress2;
        }
        InetAddress ip = inetAddress;
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Job>, Object>(hostname, ip, null){
            int label;
            final /* synthetic */ String $hostname;
            final /* synthetic */ InetAddress $ip;

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        return BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                            int label;
                            final /* synthetic */ registerHostname.1 this$0;

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        MutableSharedFlow<DNSResolver.DNSEvent> mutableSharedFlow = ZitiDNSManager.INSTANCE.getDnsBroadCast$ziti();
                                        String string = this.this$0.$hostname;
                                        InetAddress inetAddress = this.this$0.$ip;
                                        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"ip");
                                        this.label = 1;
                                        Object object3 = mutableSharedFlow.emit((Object)new DNSResolver.DNSEvent(string, inetAddress, false), (Continuation)this);
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }
                            {
                                this.this$0 = var1_1;
                                super(2, continuation);
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                return function2;
                            }

                            public final Object invoke(Object object, Object object2) {
                                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.$hostname = string;
                this.$ip = inetAddress;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Job>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        InetAddress inetAddress3 = ip;
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress3, (String)"ip");
        return inetAddress3;
    }

    @Override
    @Nullable
    public InetAddress resolve(@NotNull String hostname) {
        Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
        String string = hostname;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.getDefault()");
        Locale locale2 = locale;
        boolean bl = false;
        String string2 = string;
        boolean bl2 = false;
        String string3 = string2.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
        return host2Ip.get(string3);
    }

    @Override
    public void subscribe(@NotNull Function1<? super DNSResolver.DNSEvent, Unit> sub) {
        Intrinsics.checkNotNullParameter(sub, (String)"sub");
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(sub, null){
            int label;
            final /* synthetic */ Function1 $sub;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$collect$iv;
                        ResultKt.throwOnFailure((Object)object);
                        ZitiDNSManager.INSTANCE.getHost2Ip$ziti().forEach(new BiConsumer<String, InetAddress>(this){
                            final /* synthetic */ subscribe.1 this$0;

                            public final void accept(@NotNull String h, @NotNull InetAddress ip) {
                                Intrinsics.checkNotNullParameter((Object)h, (String)"h");
                                Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
                                this.this$0.$sub.invoke((Object)new DNSResolver.DNSEvent(h, ip, false));
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                        Flow flow = (Flow)ZitiDNSManager.INSTANCE.getDnsBroadCast$ziti();
                        subscribe.1 var3_4 = this;
                        boolean $i$f$collect = false;
                        this.label = 1;
                        Object object3 = $this$collect$iv.collect((FlowCollector)new FlowCollector<DNSResolver.DNSEvent>(this){
                            final /* synthetic */ subscribe.1 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            @Nullable
                            public Object emit(Object value, @NotNull Continuation $completion) {
                                Continuation continuation = $completion;
                                DNSResolver.DNSEvent it = (DNSResolver.DNSEvent)value;
                                boolean bl = false;
                                Object object = this.this$0.$sub.invoke((Object)it);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)var3_4);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$collect = false;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.$sub = function1;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public void subscribe(@NotNull Consumer<DNSResolver.DNSEvent> sub) {
        Intrinsics.checkNotNullParameter(sub, (String)"sub");
        this.subscribe((Function1<? super DNSResolver.DNSEvent, Unit>)((Function1)new Function1<DNSResolver.DNSEvent, Unit>(sub){
            final /* synthetic */ Consumer $sub;

            public final void invoke(@NotNull DNSResolver.DNSEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$sub.accept(it);
            }
            {
                this.$sub = consumer;
                super(1);
            }
        }));
    }

    private final InetAddress nextAddr(String dnsname) {
        int nextPostfix = postfix.incrementAndGet();
        if ((nextPostfix & 0xFF) == 0) {
            nextPostfix = postfix.incrementAndGet();
        }
        byte[] ip = ArraysKt.plus((byte[])PREFIX, (byte[])new byte[]{(byte)(nextPostfix >> 8 & 0xFF), (byte)(nextPostfix & 0xFF)});
        InetAddress inetAddress = InetAddress.getByAddress(dnsname, ip);
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"InetAddress.getByAddress(dnsname, ip)");
        return inetAddress;
    }

    public final void reset$ziti() {
        host2Ip.clear();
        postfix.set(257);
    }

    private ZitiDNSManager() {
    }

    static {
        ZitiDNSManager zitiDNSManager;
        INSTANCE = zitiDNSManager = new ZitiDNSManager();
        PREFIX = new byte[]{(byte)100, (byte)64};
        postfix = new AtomicInteger(257);
        boolean bl = false;
        host2Ip = new LinkedHashMap();
        dnsBroadCast = SharedFlowKt.MutableSharedFlow$default((int)0, (int)0, null, (int)7, null);
    }
}

