/*
 * Decompiled with CFR 0.152.
 */
package org.openziti.util;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openziti.util.CertsKt;
import org.openziti.util.KeyTrustManager;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\r2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f\"\u001c\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0015"}, d2={"cf", "Ljava/security/cert/CertificateFactory;", "kotlin.jvm.PlatformType", "getCf", "()Ljava/security/cert/CertificateFactory;", "getCACerts", "", "Ljava/security/cert/X509Certificate;", "api", "Ljava/net/URI;", "serverKey", "Ljava/security/Key;", "readCerts", "", "pemInput", "Ljava/io/Reader;", "pem", "", "readKey", "Ljava/security/PrivateKey;", "input", "ziti"})
public final class CertsKt {
    private static final CertificateFactory cf = CertificateFactory.getInstance("X.509");

    public static final CertificateFactory getCf() {
        return cf;
    }

    @NotNull
    public static final List<X509Certificate> readCerts(@NotNull String pem) {
        Intrinsics.checkNotNullParameter((Object)pem, (String)"pem");
        return CertsKt.readCerts(new StringReader(pem));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<X509Certificate> readCerts(@NotNull Reader pemInput) {
        List list;
        Intrinsics.checkNotNullParameter((Object)pemInput, (String)"pemInput");
        Closeable closeable = (Closeable)new PemReader(pemInput);
        Throwable throwable = null;
        try {
            PemReader reader = (PemReader)closeable;
            boolean bl = false;
            list = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.generateSequence((Function0)((Function0)new Function0<PemObject>(reader){
                final /* synthetic */ PemReader $reader;
                {
                    this.$reader = $reader;
                    super(0);
                }

                @Nullable
                public final PemObject invoke() {
                    return this.$reader.readPemObject();
                }
            })), (Function1)readCerts.1.2.INSTANCE), (Function1)readCerts.1.3.INSTANCE));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return list;
    }

    @NotNull
    public static final PrivateKey readKey(@NotNull Reader input) {
        PrivateKey privateKey;
        Object po;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        PEMParser parser = new PEMParser(input);
        Object object = po = parser.readObject();
        if (object instanceof PEMKeyPair) {
            privateKey = new JcaPEMKeyConverter().getKeyPair((PEMKeyPair)po).getPrivate();
        } else if (object instanceof PrivateKeyInfo) {
            privateKey = new JcaPEMKeyConverter().getPrivateKey((PrivateKeyInfo)po);
        } else {
            throw new IllegalStateException("unsupported key format".toString());
        }
        PrivateKey pk = privateKey;
        Intrinsics.checkNotNullExpressionValue((Object)pk, (String)"pk");
        return pk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<X509Certificate> getCACerts(@NotNull URI api, @NotNull Key serverKey) {
        void $this$getCACerts_u24lambda_u241;
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        Intrinsics.checkNotNullParameter((Object)serverKey, (String)"serverKey");
        URLConnection uRLConnection = api.resolve("/.well-known/est/cacerts").toURL().openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type javax.net.ssl.HttpsURLConnection");
        HttpsURLConnection con = (HttpsURLConnection)uRLConnection;
        con.setRequestProperty("Accept", "application/pkcs7-mime");
        Object object = SSLContext.getInstance("TLSv1.2");
        HttpsURLConnection httpsURLConnection = con;
        boolean bl = false;
        KeyTrustManager[] keyTrustManagerArray = new KeyTrustManager[]{new KeyTrustManager(serverKey)};
        $this$getCACerts_u24lambda_u241.init(null, keyTrustManagerArray, new SecureRandom());
        httpsURLConnection.setSSLSocketFactory($this$getCACerts_u24lambda_u241.getSocketFactory());
        con.setDoInput(true);
        if (con.getResponseCode() == 200) {
            Closeable closeable = con.getInputStream();
            object = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                byte[] byArray = ByteStreamsKt.readBytes((InputStream)it);
                Charset charset = Charset.defaultCharset();
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset()");
                Charset charset2 = charset;
                String b = new String(byArray, charset2);
                byte[] bytes = Base64.getMimeDecoder().decode(b);
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
                Collection<? extends Certificate> collection = cf.generateCertificates(new ByteArrayInputStream(bytes));
                Intrinsics.checkNotNull(collection, (String)"null cannot be cast to non-null type kotlin.collections.Collection<java.security.cert.X509Certificate>");
                Collection<? extends Certificate> collection2 = collection;
                return collection2;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
        }
        return CollectionsKt.emptyList();
    }
}

