/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.dmn.engine.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.operaton.bpm.dmn.engine.DmnDecisionResult;
import org.operaton.bpm.dmn.engine.DmnDecisionResultEntries;
import org.operaton.bpm.dmn.engine.impl.DmnEngineLogger;
import org.operaton.bpm.dmn.engine.impl.DmnLogger;
import org.operaton.bpm.engine.variable.value.TypedValue;

public class DmnDecisionResultImpl
implements DmnDecisionResult {
    private static final long serialVersionUID = 1L;
    public static final DmnEngineLogger LOG = DmnLogger.ENGINE_LOGGER;
    protected final List<DmnDecisionResultEntries> ruleResults;

    public DmnDecisionResultImpl(List<DmnDecisionResultEntries> ruleResults) {
        this.ruleResults = ruleResults;
    }

    @Override
    public DmnDecisionResultEntries getFirstResult() {
        if (this.size() > 0) {
            return this.get(0);
        }
        return null;
    }

    @Override
    public DmnDecisionResultEntries getSingleResult() {
        if (this.size() == 1) {
            return this.get(0);
        }
        if (this.isEmpty()) {
            return null;
        }
        throw LOG.decisionResultHasMoreThanOneOutput(this);
    }

    @Override
    public <T> List<T> collectEntries(String outputName) {
        ArrayList outputValues = new ArrayList();
        for (DmnDecisionResultEntries ruleResult : this.ruleResults) {
            if (!ruleResult.containsKey(outputName)) continue;
            Object value = ruleResult.get(outputName);
            outputValues.add(value);
        }
        return outputValues;
    }

    @Override
    public List<Map<String, Object>> getResultList() {
        ArrayList<Map<String, Object>> entryMapList = new ArrayList<Map<String, Object>>();
        for (DmnDecisionResultEntries ruleResult : this.ruleResults) {
            Map<String, Object> entryMap = ruleResult.getEntryMap();
            entryMapList.add(entryMap);
        }
        return entryMapList;
    }

    @Override
    public <T> T getSingleEntry() {
        DmnDecisionResultEntries result = this.getSingleResult();
        if (result != null) {
            return result.getSingleEntry();
        }
        return null;
    }

    @Override
    public <T extends TypedValue> T getSingleEntryTyped() {
        DmnDecisionResultEntries result = this.getSingleResult();
        if (result != null) {
            return result.getSingleEntryTyped();
        }
        return null;
    }

    @Override
    public Iterator<DmnDecisionResultEntries> iterator() {
        return this.asUnmodifiableList().iterator();
    }

    @Override
    public int size() {
        return this.ruleResults.size();
    }

    @Override
    public boolean isEmpty() {
        return this.ruleResults.isEmpty();
    }

    @Override
    public DmnDecisionResultEntries get(int index) {
        return this.ruleResults.get(index);
    }

    @Override
    public boolean contains(Object o) {
        return this.ruleResults.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.ruleResults.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.ruleResults.toArray(a);
    }

    @Override
    public boolean add(DmnDecisionResultEntries e) {
        throw new UnsupportedOperationException("decision result is immutable");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("decision result is immutable");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.ruleResults.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends DmnDecisionResultEntries> c) {
        throw new UnsupportedOperationException("decision result is immutable");
    }

    @Override
    public boolean addAll(int index, Collection<? extends DmnDecisionResultEntries> c) {
        throw new UnsupportedOperationException("decision result is immutable");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("decision result is immutable");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("decision result is immutable");
    }

    @Override
    public DmnDecisionResultEntries set(int index, DmnDecisionResultEntries element) {
        throw new UnsupportedOperationException("decision result is immutable");
    }

    @Override
    public void add(int index, DmnDecisionResultEntries element) {
        throw new UnsupportedOperationException("decision result is immutable");
    }

    @Override
    public DmnDecisionResultEntries remove(int index) {
        throw new UnsupportedOperationException("decision result is immutable");
    }

    @Override
    public int indexOf(Object o) {
        return this.ruleResults.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.ruleResults.lastIndexOf(o);
    }

    @Override
    public ListIterator<DmnDecisionResultEntries> listIterator() {
        return this.asUnmodifiableList().listIterator();
    }

    @Override
    public ListIterator<DmnDecisionResultEntries> listIterator(int index) {
        return this.asUnmodifiableList().listIterator(index);
    }

    @Override
    public List<DmnDecisionResultEntries> subList(int fromIndex, int toIndex) {
        return this.asUnmodifiableList().subList(fromIndex, toIndex);
    }

    public String toString() {
        return this.ruleResults.toString();
    }

    protected List<DmnDecisionResultEntries> asUnmodifiableList() {
        return Collections.unmodifiableList(this.ruleResults);
    }
}

