/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.dmn.engine.impl.el;

import org.operaton.bpm.dmn.engine.impl.el.JuelElContextFactory;
import org.operaton.bpm.dmn.engine.impl.el.JuelExpression;
import org.operaton.bpm.dmn.engine.impl.el.VariableContextElResolver;
import org.operaton.bpm.dmn.engine.impl.spi.el.ElExpression;
import org.operaton.bpm.dmn.engine.impl.spi.el.ElProvider;
import org.operaton.bpm.impl.juel.ExpressionFactoryImpl;
import org.operaton.bpm.impl.juel.SimpleContext;
import org.operaton.bpm.impl.juel.TreeValueExpression;
import org.operaton.bpm.impl.juel.jakarta.el.ArrayELResolver;
import org.operaton.bpm.impl.juel.jakarta.el.BeanELResolver;
import org.operaton.bpm.impl.juel.jakarta.el.CompositeELResolver;
import org.operaton.bpm.impl.juel.jakarta.el.ELContext;
import org.operaton.bpm.impl.juel.jakarta.el.ELResolver;
import org.operaton.bpm.impl.juel.jakarta.el.ListELResolver;
import org.operaton.bpm.impl.juel.jakarta.el.MapELResolver;
import org.operaton.bpm.impl.juel.jakarta.el.ResourceBundleELResolver;
import org.operaton.bpm.impl.juel.jakarta.el.ValueExpression;

public class JuelElProvider
implements ElProvider {
    protected final ExpressionFactoryImpl factory;
    protected final JuelElContextFactory elContextFactory;
    protected final ELContext parsingElContext;

    public JuelElProvider() {
        this(new ExpressionFactoryImpl(), new JuelElContextFactory(JuelElProvider.createDefaultResolver()));
    }

    public JuelElProvider(ExpressionFactoryImpl expressionFactory, JuelElContextFactory elContextFactory) {
        this.factory = expressionFactory;
        this.elContextFactory = elContextFactory;
        this.parsingElContext = this.createDefaultParsingElContext();
    }

    protected SimpleContext createDefaultParsingElContext() {
        return new SimpleContext();
    }

    @Override
    public ElExpression createExpression(String expression) {
        TreeValueExpression juelExpr = this.factory.createValueExpression(this.parsingElContext, expression, Object.class);
        return new JuelExpression((ValueExpression)juelExpr, this.elContextFactory);
    }

    public ExpressionFactoryImpl getFactory() {
        return this.factory;
    }

    public JuelElContextFactory getElContextFactory() {
        return this.elContextFactory;
    }

    public ELContext getParsingElContext() {
        return this.parsingElContext;
    }

    protected static ELResolver createDefaultResolver() {
        CompositeELResolver resolver = new CompositeELResolver();
        resolver.add((ELResolver)new VariableContextElResolver());
        resolver.add((ELResolver)new ArrayELResolver(true));
        resolver.add((ELResolver)new ListELResolver(true));
        resolver.add((ELResolver)new MapELResolver(true));
        resolver.add((ELResolver)new ResourceBundleELResolver());
        resolver.add((ELResolver)new BeanELResolver());
        return resolver;
    }
}

