/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.dmn.engine.impl.el;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import org.operaton.bpm.engine.variable.context.VariableContext;
import org.operaton.bpm.engine.variable.value.TypedValue;

public class VariableContextScriptBindings
implements Bindings {
    protected Bindings wrappedBindings;
    protected VariableContext variableContext;

    public VariableContextScriptBindings(Bindings wrappedBindings, VariableContext variableContext) {
        this.wrappedBindings = wrappedBindings;
        this.variableContext = variableContext;
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.wrappedBindings.containsKey(key)) {
            return true;
        }
        if (key instanceof String) {
            return this.variableContext.containsVariable((String)key);
        }
        return false;
    }

    @Override
    public Object get(Object key) {
        Object result = null;
        if (this.wrappedBindings.containsKey(key)) {
            result = this.wrappedBindings.get(key);
        } else if (key instanceof String) {
            TypedValue resolvedValue = this.variableContext.resolve((String)key);
            result = this.unpack(resolvedValue);
        }
        return result;
    }

    @Override
    public Object put(String name, Object value) {
        return this.wrappedBindings.put(name, value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.calculateBindingMap().entrySet();
    }

    @Override
    public Set<String> keySet() {
        return this.calculateBindingMap().keySet();
    }

    @Override
    public int size() {
        return this.calculateBindingMap().size();
    }

    @Override
    public Collection<Object> values() {
        return this.calculateBindingMap().values();
    }

    @Override
    public void putAll(Map<? extends String, ?> toMerge) {
        for (Map.Entry<String, ?> entry : toMerge.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object remove(Object key) {
        return this.wrappedBindings.remove(key);
    }

    @Override
    public void clear() {
        this.wrappedBindings.clear();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.calculateBindingMap().containsValue(value);
    }

    @Override
    public boolean isEmpty() {
        return this.calculateBindingMap().isEmpty();
    }

    protected Map<String, Object> calculateBindingMap() {
        HashMap<String, Object> bindingMap = new HashMap<String, Object>();
        Set keySet = this.variableContext.keySet();
        for (String variableName : keySet) {
            bindingMap.put(variableName, this.unpack(this.variableContext.resolve(variableName)));
        }
        Set wrappedBindingsEntries = this.wrappedBindings.entrySet();
        for (Map.Entry entry : wrappedBindingsEntries) {
            bindingMap.put((String)entry.getKey(), entry.getValue());
        }
        return bindingMap;
    }

    protected Object unpack(TypedValue resolvedValue) {
        if (resolvedValue != null) {
            return resolvedValue.getValue();
        }
        return null;
    }

    public static VariableContextScriptBindings wrap(Bindings wrappedBindings, VariableContext variableContext) {
        return new VariableContextScriptBindings(wrappedBindings, variableContext);
    }
}

