/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.dmn.engine.impl.transform;

import org.operaton.bpm.dmn.engine.impl.spi.transform.DmnElementTransformContext;
import org.operaton.bpm.dmn.engine.impl.spi.type.DmnDataTypeTransformer;
import org.operaton.bpm.dmn.engine.impl.spi.type.DmnTypeDefinition;
import org.operaton.bpm.dmn.engine.impl.type.DefaultTypeDefinition;
import org.operaton.bpm.dmn.engine.impl.type.DmnTypeDefinitionImpl;
import org.operaton.bpm.model.dmn.instance.InformationItem;
import org.operaton.bpm.model.dmn.instance.LiteralExpression;
import org.operaton.bpm.model.dmn.instance.Text;
import org.operaton.bpm.model.dmn.instance.UnaryTests;

public class DmnExpressionTransformHelper {
    public static DmnTypeDefinition createTypeDefinition(DmnElementTransformContext context, LiteralExpression expression) {
        return DmnExpressionTransformHelper.createTypeDefinition(context, expression.getTypeRef());
    }

    public static DmnTypeDefinition createTypeDefinition(DmnElementTransformContext context, InformationItem informationItem) {
        return DmnExpressionTransformHelper.createTypeDefinition(context, informationItem.getTypeRef());
    }

    protected static DmnTypeDefinition createTypeDefinition(DmnElementTransformContext context, String typeRef) {
        if (typeRef != null) {
            DmnDataTypeTransformer transformer = context.getDataTypeTransformerRegistry().getTransformer(typeRef);
            return new DmnTypeDefinitionImpl(typeRef, transformer);
        }
        return new DefaultTypeDefinition();
    }

    public static String getExpressionLanguage(DmnElementTransformContext context, LiteralExpression expression) {
        return DmnExpressionTransformHelper.getExpressionLanguage(context, expression.getExpressionLanguage());
    }

    public static String getExpressionLanguage(DmnElementTransformContext context, UnaryTests expression) {
        return DmnExpressionTransformHelper.getExpressionLanguage(context, expression.getExpressionLanguage());
    }

    protected static String getExpressionLanguage(DmnElementTransformContext context, String expressionLanguage) {
        if (expressionLanguage != null) {
            return expressionLanguage;
        }
        return DmnExpressionTransformHelper.getGlobalExpressionLanguage(context);
    }

    protected static String getGlobalExpressionLanguage(DmnElementTransformContext context) {
        String expressionLanguage = context.getModelInstance().getDefinitions().getExpressionLanguage();
        if (!("http://www.omg.org/spec/FEEL/20140401".equals(expressionLanguage) || "http://www.omg.org/spec/DMN/20180521/FEEL/".equals(expressionLanguage) || "https://www.omg.org/spec/DMN/20191111/FEEL/".equals(expressionLanguage) || "https://www.omg.org/spec/DMN/20211108/FEEL/".equals(expressionLanguage) || "https://www.omg.org/spec/DMN/20230324/FEEL/".equals(expressionLanguage))) {
            return expressionLanguage;
        }
        return null;
    }

    public static String getExpression(LiteralExpression expression) {
        return DmnExpressionTransformHelper.getExpression(expression.getText());
    }

    public static String getExpression(UnaryTests expression) {
        return DmnExpressionTransformHelper.getExpression(expression.getText());
    }

    protected static String getExpression(Text text) {
        String textContent;
        if (text != null && (textContent = text.getTextContent()) != null && !textContent.isEmpty()) {
            return textContent;
        }
        return null;
    }
}

