/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.dmn.engine.impl.evaluation;

import java.util.Collections;
import org.operaton.bpm.dmn.engine.DmnDecision;
import org.operaton.bpm.dmn.engine.DmnDecisionResult;
import org.operaton.bpm.dmn.engine.delegate.DmnDecisionLiteralExpressionEvaluationEvent;
import org.operaton.bpm.dmn.engine.delegate.DmnDecisionLogicEvaluationEvent;
import org.operaton.bpm.dmn.engine.impl.DefaultDmnEngineConfiguration;
import org.operaton.bpm.dmn.engine.impl.DmnDecisionLiteralExpressionImpl;
import org.operaton.bpm.dmn.engine.impl.DmnDecisionResultEntriesImpl;
import org.operaton.bpm.dmn.engine.impl.DmnDecisionResultImpl;
import org.operaton.bpm.dmn.engine.impl.DmnExpressionImpl;
import org.operaton.bpm.dmn.engine.impl.DmnVariableImpl;
import org.operaton.bpm.dmn.engine.impl.delegate.DmnDecisionLiteralExpressionEvaluationEventImpl;
import org.operaton.bpm.dmn.engine.impl.evaluation.DmnDecisionLogicEvaluationHandler;
import org.operaton.bpm.dmn.engine.impl.evaluation.ExpressionEvaluationHandler;
import org.operaton.bpm.engine.variable.context.VariableContext;
import org.operaton.bpm.engine.variable.value.TypedValue;

public class DecisionLiteralExpressionEvaluationHandler
implements DmnDecisionLogicEvaluationHandler {
    protected final ExpressionEvaluationHandler expressionEvaluationHandler;
    protected final String literalExpressionLanguage;

    public DecisionLiteralExpressionEvaluationHandler(DefaultDmnEngineConfiguration configuration) {
        this.expressionEvaluationHandler = new ExpressionEvaluationHandler(configuration);
        this.literalExpressionLanguage = configuration.getDefaultLiteralExpressionLanguage();
    }

    @Override
    public DmnDecisionLogicEvaluationEvent evaluate(DmnDecision decision, VariableContext variableContext) {
        DmnDecisionLiteralExpressionEvaluationEventImpl evaluationResult = new DmnDecisionLiteralExpressionEvaluationEventImpl();
        evaluationResult.setDecision(decision);
        evaluationResult.setExecutedDecisionElements(1L);
        DmnDecisionLiteralExpressionImpl dmnDecisionLiteralExpression = (DmnDecisionLiteralExpressionImpl)decision.getDecisionLogic();
        DmnVariableImpl variable = dmnDecisionLiteralExpression.getVariable();
        DmnExpressionImpl expression = dmnDecisionLiteralExpression.getExpression();
        Object evaluateExpression = this.evaluateLiteralExpression(expression, variableContext);
        TypedValue typedValue = variable.getTypeDefinition().transform(evaluateExpression);
        evaluationResult.setOutputValue(typedValue);
        evaluationResult.setOutputName(variable.getName());
        return evaluationResult;
    }

    protected Object evaluateLiteralExpression(DmnExpressionImpl expression, VariableContext variableContext) {
        String expressionLanguage = expression.getExpressionLanguage();
        if (expressionLanguage == null) {
            expressionLanguage = this.literalExpressionLanguage;
        }
        return this.expressionEvaluationHandler.evaluateExpression(expressionLanguage, expression, variableContext);
    }

    @Override
    public DmnDecisionResult generateDecisionResult(DmnDecisionLogicEvaluationEvent event) {
        DmnDecisionLiteralExpressionEvaluationEvent evaluationEvent = (DmnDecisionLiteralExpressionEvaluationEvent)event;
        DmnDecisionResultEntriesImpl result = new DmnDecisionResultEntriesImpl();
        result.putValue(evaluationEvent.getOutputName(), evaluationEvent.getOutputValue());
        return new DmnDecisionResultImpl(Collections.singletonList(result));
    }
}

