/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.dmn.engine.impl.hitpolicy;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.operaton.bpm.dmn.engine.delegate.DmnDecisionTableEvaluationEvent;
import org.operaton.bpm.dmn.engine.delegate.DmnEvaluatedDecisionRule;
import org.operaton.bpm.dmn.engine.delegate.DmnEvaluatedOutput;
import org.operaton.bpm.dmn.engine.impl.DmnLogger;
import org.operaton.bpm.dmn.engine.impl.delegate.DmnDecisionTableEvaluationEventImpl;
import org.operaton.bpm.dmn.engine.impl.hitpolicy.DmnHitPolicyLogger;
import org.operaton.bpm.dmn.engine.impl.spi.hitpolicy.DmnHitPolicyHandler;
import org.operaton.bpm.engine.variable.Variables;
import org.operaton.bpm.engine.variable.type.ValueType;
import org.operaton.bpm.engine.variable.value.TypedValue;
import org.operaton.bpm.model.dmn.BuiltinAggregator;

public abstract class AbstractCollectNumberHitPolicyHandler
implements DmnHitPolicyHandler {
    public static final DmnHitPolicyLogger LOG = DmnLogger.HIT_POLICY_LOGGER;

    protected abstract BuiltinAggregator getAggregator();

    @Override
    public DmnDecisionTableEvaluationEvent apply(DmnDecisionTableEvaluationEvent decisionTableEvaluationEvent) {
        String resultName = this.getResultName(decisionTableEvaluationEvent);
        TypedValue resultValue = this.getResultValue(decisionTableEvaluationEvent);
        DmnDecisionTableEvaluationEventImpl evaluationEvent = (DmnDecisionTableEvaluationEventImpl)decisionTableEvaluationEvent;
        evaluationEvent.setCollectResultName(resultName);
        evaluationEvent.setCollectResultValue(resultValue);
        return evaluationEvent;
    }

    protected String getResultName(DmnDecisionTableEvaluationEvent decisionTableEvaluationEvent) {
        for (DmnEvaluatedDecisionRule matchingRule : decisionTableEvaluationEvent.getMatchingRules()) {
            Map<String, DmnEvaluatedOutput> outputEntries = matchingRule.getOutputEntries();
            if (outputEntries.isEmpty()) continue;
            return outputEntries.values().iterator().next().getOutputName();
        }
        return null;
    }

    protected TypedValue getResultValue(DmnDecisionTableEvaluationEvent decisionTableEvaluationEvent) {
        List<TypedValue> values = this.collectSingleValues(decisionTableEvaluationEvent);
        return this.aggregateValues(values);
    }

    protected List<TypedValue> collectSingleValues(DmnDecisionTableEvaluationEvent decisionTableEvaluationEvent) {
        ArrayList<TypedValue> values = new ArrayList<TypedValue>();
        for (DmnEvaluatedDecisionRule matchingRule : decisionTableEvaluationEvent.getMatchingRules()) {
            Map<String, DmnEvaluatedOutput> outputEntries = matchingRule.getOutputEntries();
            if (outputEntries.size() > 1) {
                throw LOG.aggregationNotApplicableOnCompoundOutput(this.getAggregator(), outputEntries);
            }
            if (outputEntries.size() != 1) continue;
            TypedValue typedValue = outputEntries.values().iterator().next().getValue();
            values.add(typedValue);
        }
        return values;
    }

    protected TypedValue aggregateValues(List<TypedValue> values) {
        if (!values.isEmpty()) {
            return this.aggregateNumberValues(values);
        }
        return null;
    }

    protected TypedValue aggregateNumberValues(List<TypedValue> values) {
        try {
            List<Integer> intValues = this.convertValuesToInteger(values);
            return Variables.integerValue((Integer)this.aggregateIntegerValues(intValues));
        }
        catch (IllegalArgumentException intValues) {
            try {
                List<Long> longValues = this.convertValuesToLong(values);
                return Variables.longValue((Long)this.aggregateLongValues(longValues));
            }
            catch (IllegalArgumentException longValues) {
                try {
                    List<Double> doubleValues = this.convertValuesToDouble(values);
                    return Variables.doubleValue((Double)this.aggregateDoubleValues(doubleValues));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw LOG.unableToConvertValuesToAggregatableTypes(values, Integer.class, Long.class, Double.class);
                }
            }
        }
    }

    protected abstract Integer aggregateIntegerValues(List<Integer> var1);

    protected abstract Long aggregateLongValues(List<Long> var1);

    protected abstract Double aggregateDoubleValues(List<Double> var1);

    protected List<Integer> convertValuesToInteger(List<TypedValue> typedValues) throws IllegalArgumentException {
        ArrayList<Integer> intValues = new ArrayList<Integer>();
        for (TypedValue typedValue : typedValues) {
            if (ValueType.INTEGER.equals(typedValue.getType())) {
                intValues.add((Integer)typedValue.getValue());
                continue;
            }
            if (typedValue.getType() == null) {
                Object value = typedValue.getValue();
                if (value instanceof Integer) {
                    Integer integerValue = (Integer)value;
                    intValues.add(integerValue);
                    continue;
                }
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException();
        }
        return intValues;
    }

    protected List<Long> convertValuesToLong(List<TypedValue> typedValues) throws IllegalArgumentException {
        ArrayList<Long> longValues = new ArrayList<Long>();
        for (TypedValue typedValue : typedValues) {
            if (ValueType.LONG.equals(typedValue.getType())) {
                longValues.add((Long)typedValue.getValue());
                continue;
            }
            if (typedValue.getType() == null) {
                Object value = typedValue.getValue();
                if (value instanceof Long) {
                    Long longValue = (Long)value;
                    longValues.add(longValue);
                    continue;
                }
                Long longValue = Long.valueOf(value.toString());
                longValues.add(longValue);
                continue;
            }
            throw new IllegalArgumentException();
        }
        return longValues;
    }

    protected List<Double> convertValuesToDouble(List<TypedValue> typedValues) throws IllegalArgumentException {
        ArrayList<Double> doubleValues = new ArrayList<Double>();
        for (TypedValue typedValue : typedValues) {
            if (ValueType.DOUBLE.equals(typedValue.getType())) {
                doubleValues.add((Double)typedValue.getValue());
                continue;
            }
            if (typedValue.getType() == null) {
                Object value = typedValue.getValue();
                if (value instanceof Double) {
                    Double doubleValue = (Double)value;
                    doubleValues.add(doubleValue);
                    continue;
                }
                Double doubleValue = Double.valueOf(value.toString());
                doubleValues.add(doubleValue);
                continue;
            }
            throw new IllegalArgumentException();
        }
        return doubleValues;
    }
}

