/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.dmn.feel.impl.juel;

import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.operaton.bpm.dmn.feel.impl.FeelEngine;
import org.operaton.bpm.dmn.feel.impl.FeelEngineFactory;
import org.operaton.bpm.dmn.feel.impl.juel.FeelEngineImpl;
import org.operaton.bpm.dmn.feel.impl.juel.FeelEngineLogger;
import org.operaton.bpm.dmn.feel.impl.juel.FeelLogger;
import org.operaton.bpm.dmn.feel.impl.juel.TransformExpressionCacheKey;
import org.operaton.bpm.dmn.feel.impl.juel.el.ElContextFactory;
import org.operaton.bpm.dmn.feel.impl.juel.el.FeelElContextFactory;
import org.operaton.bpm.dmn.feel.impl.juel.el.FeelTypeConverter;
import org.operaton.bpm.dmn.feel.impl.juel.transform.FeelToJuelFunctionTransformer;
import org.operaton.bpm.dmn.feel.impl.juel.transform.FeelToJuelTransform;
import org.operaton.bpm.dmn.feel.impl.juel.transform.FeelToJuelTransformImpl;
import org.operaton.bpm.impl.juel.ExpressionFactoryImpl;
import org.operaton.bpm.impl.juel.TypeConverter;
import org.operaton.bpm.impl.juel.jakarta.el.ELException;
import org.operaton.bpm.impl.juel.jakarta.el.ExpressionFactory;
import org.operaton.commons.utils.cache.Cache;
import org.operaton.commons.utils.cache.ConcurrentLruCache;

public class FeelEngineFactoryImpl
implements FeelEngineFactory {
    public static final FeelEngineLogger LOG = FeelLogger.ENGINE_LOGGER;
    public static final int DEFAULT_EXPRESSION_CACHE_SIZE = 1000;
    protected final FeelEngine feelEngine;
    protected final int expressionCacheSize;
    protected final List<FeelToJuelFunctionTransformer> customFunctionTransformers;

    public FeelEngineFactoryImpl() {
        this(1000);
    }

    public FeelEngineFactoryImpl(int expressionCacheSize) {
        this(expressionCacheSize, Collections.emptyList());
    }

    public FeelEngineFactoryImpl(List<FeelToJuelFunctionTransformer> customFunctionTransformers) {
        this(1000, customFunctionTransformers);
    }

    public FeelEngineFactoryImpl(int expressionCacheSize, List<FeelToJuelFunctionTransformer> customFunctionTransformers) {
        this.expressionCacheSize = expressionCacheSize;
        this.customFunctionTransformers = customFunctionTransformers;
        this.feelEngine = this.createFeelEngine();
    }

    public FeelEngine createInstance() {
        return this.feelEngine;
    }

    protected FeelEngine createFeelEngine() {
        FeelToJuelTransform transform = this.createFeelToJuelTransform();
        ExpressionFactory expressionFactory = this.createExpressionFactory();
        ElContextFactory elContextFactory = this.createElContextFactory();
        Cache<TransformExpressionCacheKey, String> transformExpressionCache = this.createTransformExpressionCache();
        return new FeelEngineImpl(transform, expressionFactory, elContextFactory, transformExpressionCache);
    }

    protected FeelToJuelTransform createFeelToJuelTransform() {
        FeelToJuelTransformImpl transformer = new FeelToJuelTransformImpl();
        for (FeelToJuelFunctionTransformer functionTransformer : this.customFunctionTransformers) {
            transformer.addCustomFunctionTransformer(functionTransformer);
        }
        return transformer;
    }

    protected ExpressionFactory createExpressionFactory() {
        Properties properties = new Properties();
        properties.put("org.operaton.bpm.impl.juel.jakarta.el.cacheSize", String.valueOf(this.expressionCacheSize));
        try {
            return new ExpressionFactoryImpl(properties, (TypeConverter)this.createTypeConverter());
        }
        catch (ELException e) {
            throw LOG.unableToInitializeFeelEngine(e);
        }
    }

    protected FeelTypeConverter createTypeConverter() {
        return new FeelTypeConverter();
    }

    protected ElContextFactory createElContextFactory() {
        FeelElContextFactory factory = new FeelElContextFactory();
        for (FeelToJuelFunctionTransformer functionTransformer : this.customFunctionTransformers) {
            factory.addCustomFunction(functionTransformer.getName(), functionTransformer.getMethod());
        }
        return factory;
    }

    protected Cache<TransformExpressionCacheKey, String> createTransformExpressionCache() {
        return new ConcurrentLruCache(this.expressionCacheSize);
    }
}

