/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.dmn.feel.impl.juel;

import org.operaton.bpm.dmn.feel.impl.FeelEngine;
import org.operaton.bpm.dmn.feel.impl.juel.FeelConvertException;
import org.operaton.bpm.dmn.feel.impl.juel.FeelEngineLogger;
import org.operaton.bpm.dmn.feel.impl.juel.FeelLogger;
import org.operaton.bpm.dmn.feel.impl.juel.FeelMethodInvocationException;
import org.operaton.bpm.dmn.feel.impl.juel.FeelMissingFunctionException;
import org.operaton.bpm.dmn.feel.impl.juel.FeelMissingVariableException;
import org.operaton.bpm.dmn.feel.impl.juel.TransformExpressionCacheKey;
import org.operaton.bpm.dmn.feel.impl.juel.el.ElContextFactory;
import org.operaton.bpm.dmn.feel.impl.juel.transform.FeelToJuelTransform;
import org.operaton.bpm.engine.variable.context.VariableContext;
import org.operaton.bpm.impl.juel.jakarta.el.ELContext;
import org.operaton.bpm.impl.juel.jakarta.el.ELException;
import org.operaton.bpm.impl.juel.jakarta.el.ExpressionFactory;
import org.operaton.bpm.impl.juel.jakarta.el.ValueExpression;
import org.operaton.commons.utils.cache.Cache;

public class FeelEngineImpl
implements FeelEngine {
    public static final FeelEngineLogger LOG = FeelLogger.ENGINE_LOGGER;
    protected FeelToJuelTransform transform;
    protected ExpressionFactory expressionFactory;
    protected ElContextFactory elContextFactory;
    protected Cache<TransformExpressionCacheKey, String> transformExpressionCache;

    public FeelEngineImpl(FeelToJuelTransform transform, ExpressionFactory expressionFactory, ElContextFactory elContextFactory, Cache<TransformExpressionCacheKey, String> transformExpressionCache) {
        this.transform = transform;
        this.expressionFactory = expressionFactory;
        this.elContextFactory = elContextFactory;
        this.transformExpressionCache = transformExpressionCache;
    }

    public <T> T evaluateSimpleExpression(String simpleExpression, VariableContext variableContext) {
        throw LOG.simpleExpressionNotSupported();
    }

    public boolean evaluateSimpleUnaryTests(String simpleUnaryTests, String inputName, VariableContext variableContext) {
        try {
            ELContext elContext = this.createContext(variableContext);
            ValueExpression valueExpression = this.transformSimpleUnaryTests(simpleUnaryTests, inputName, elContext);
            return (Boolean)valueExpression.getValue(elContext);
        }
        catch (FeelMissingFunctionException e) {
            throw LOG.unknownFunction(simpleUnaryTests, e);
        }
        catch (FeelMissingVariableException e) {
            if (inputName.equals(e.getVariable())) {
                throw LOG.unableToEvaluateExpressionAsNotInputIsSet(simpleUnaryTests, e);
            }
            throw LOG.unknownVariable(simpleUnaryTests, e);
        }
        catch (FeelConvertException e) {
            throw LOG.unableToConvertValue(simpleUnaryTests, e);
        }
        catch (ELException e) {
            if (e.getCause() instanceof FeelMethodInvocationException) {
                throw LOG.unableToInvokeMethod(simpleUnaryTests, (FeelMethodInvocationException)((Object)e.getCause()));
            }
            throw LOG.unableToEvaluateExpression(simpleUnaryTests, e);
        }
    }

    protected ELContext createContext(VariableContext variableContext) {
        return this.elContextFactory.createContext(this.expressionFactory, variableContext);
    }

    protected ValueExpression transformSimpleUnaryTests(String simpleUnaryTests, String inputName, ELContext elContext) {
        String juelExpression = this.transformToJuelExpression(simpleUnaryTests, inputName);
        try {
            return this.expressionFactory.createValueExpression(elContext, juelExpression, Object.class);
        }
        catch (ELException e) {
            throw LOG.invalidExpression(simpleUnaryTests, e);
        }
    }

    protected String transformToJuelExpression(String simpleUnaryTests, String inputName) {
        TransformExpressionCacheKey cacheKey = new TransformExpressionCacheKey(simpleUnaryTests, inputName);
        String juelExpression = (String)this.transformExpressionCache.get((Object)cacheKey);
        if (juelExpression == null) {
            juelExpression = this.transform.transformSimpleUnaryTests(simpleUnaryTests, inputName);
            this.transformExpressionCache.put((Object)cacheKey, (Object)juelExpression);
        }
        return juelExpression;
    }
}

