/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.dmn.feel.impl.juel.el;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.operaton.bpm.dmn.feel.impl.juel.FeelEngineLogger;
import org.operaton.bpm.dmn.feel.impl.juel.FeelLogger;
import org.operaton.bpm.impl.juel.TypeConverterImpl;
import org.operaton.bpm.impl.juel.jakarta.el.ELException;

public class FeelTypeConverter
extends TypeConverterImpl {
    public static final FeelEngineLogger LOG = FeelLogger.ENGINE_LOGGER;

    protected Boolean coerceToBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw LOG.unableToConvertValue(value, Boolean.class);
    }

    protected BigDecimal coerceToBigDecimal(Object value) {
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        if (value instanceof Number) {
            return new BigDecimal(((Number)value).doubleValue());
        }
        throw LOG.unableToConvertValue(value, BigDecimal.class);
    }

    protected BigInteger coerceToBigInteger(Object value) {
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toBigInteger();
        }
        if (value instanceof Number) {
            return BigInteger.valueOf(((Number)value).longValue());
        }
        throw LOG.unableToConvertValue(value, BigInteger.class);
    }

    protected Double coerceToDouble(Object value) {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        throw LOG.unableToConvertValue(value, Double.class);
    }

    protected Long coerceToLong(Object value) {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number && this.isLong((Number)value)) {
            return ((Number)value).longValue();
        }
        throw LOG.unableToConvertValue(value, Long.class);
    }

    protected String coerceToString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        throw LOG.unableToConvertValue(value, String.class);
    }

    public <T> T convert(Object value, Class<T> type) throws ELException {
        try {
            return (T)super.convert(value, type);
        }
        catch (ELException e) {
            throw LOG.unableToConvertValue(value, type, e);
        }
    }

    protected boolean isLong(Number value) {
        double doubleValue = value.doubleValue();
        return doubleValue == (double)((long)doubleValue);
    }
}

