/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.dmn.feel.impl.juel.transform;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.operaton.bpm.dmn.feel.impl.juel.FeelEngineLogger;
import org.operaton.bpm.dmn.feel.impl.juel.FeelLogger;
import org.operaton.bpm.dmn.feel.impl.juel.transform.FeelToJuelTransform;
import org.operaton.bpm.dmn.feel.impl.juel.transform.FeelToJuelTransformer;

public class ComparisonTransformer
implements FeelToJuelTransformer {
    public static final FeelEngineLogger LOG = FeelLogger.ENGINE_LOGGER;
    public static final Pattern COMPARISON_PATTERN = Pattern.compile("^(<=|>=|<|>)([^=].*)$");

    @Override
    public boolean canTransform(String feelExpression) {
        return feelExpression.startsWith("<=") || feelExpression.startsWith("<") || feelExpression.startsWith(">=") || feelExpression.startsWith(">");
    }

    @Override
    public String transform(FeelToJuelTransform transform, String feelExpression, String inputName) {
        Matcher matcher = COMPARISON_PATTERN.matcher(feelExpression);
        if (matcher.matches()) {
            return this.transformComparison(transform, matcher.group(1), matcher.group(2), inputName);
        }
        throw LOG.invalidComparisonExpression(feelExpression);
    }

    protected String transformComparison(FeelToJuelTransform transform, String operator, String endpoint, String inputName) {
        String juelEndpoint = transform.transformEndpoint(endpoint, inputName);
        return String.format("%s %s %s", inputName, operator, juelEndpoint);
    }
}

