/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.dmn.feel.impl.juel.transform;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.operaton.bpm.dmn.feel.impl.juel.FeelEngineLogger;
import org.operaton.bpm.dmn.feel.impl.juel.FeelLogger;
import org.operaton.bpm.dmn.feel.impl.juel.transform.FeelToJuelTransform;
import org.operaton.bpm.dmn.feel.impl.juel.transform.FeelToJuelTransformer;

public class IntervalTransformer
implements FeelToJuelTransformer {
    public static final FeelEngineLogger LOG = FeelLogger.ENGINE_LOGGER;
    public static final Pattern INTERVAL_PATTERN = Pattern.compile("^(\\(|\\[|\\])(.*[^\\.])\\.\\.(.+)(\\)|\\]|\\[)$");

    @Override
    public boolean canTransform(String feelExpression) {
        return feelExpression.startsWith("(") || feelExpression.startsWith("[") || feelExpression.startsWith("]");
    }

    @Override
    public String transform(FeelToJuelTransform transform, String feelExpression, String inputName) {
        Matcher matcher = INTERVAL_PATTERN.matcher(feelExpression);
        if (matcher.matches()) {
            return this.transformInterval(transform, matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4), inputName);
        }
        throw LOG.invalidIntervalExpression(feelExpression);
    }

    public String transformInterval(FeelToJuelTransform transform, String startIntervalSymbol, String lowerEndpoint, String upperEndpoint, String stopIntervalSymbol, String inputName) {
        String juelLowerEndpoint = transform.transformEndpoint(lowerEndpoint, inputName);
        String juelUpperEndpoint = transform.transformEndpoint(upperEndpoint, inputName);
        String lowerEndpointComparator = this.transformLowerEndpointComparator(startIntervalSymbol);
        String upperEndpointComparator = this.transformUpperEndpointComparator(stopIntervalSymbol);
        return String.format("%s %s %s && %s %s %s", inputName, lowerEndpointComparator, juelLowerEndpoint, inputName, upperEndpointComparator, juelUpperEndpoint);
    }

    protected String transformLowerEndpointComparator(String startIntervalSymbol) {
        if (startIntervalSymbol.equals("[")) {
            return ">=";
        }
        return ">";
    }

    protected String transformUpperEndpointComparator(String stopIntervalSymbol) {
        if (stopIntervalSymbol.equals("]")) {
            return "<=";
        }
        return "<";
    }
}

