/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.dmn.feel.impl.scala.function.builder;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.operaton.bpm.dmn.feel.impl.scala.ScalaFeelLogger;
import org.operaton.bpm.dmn.feel.impl.scala.function.CustomFunction;
import org.operaton.bpm.dmn.feel.impl.scala.function.builder.CustomFunctionBuilder;

public class CustomFunctionBuilderImpl
implements CustomFunctionBuilder {
    protected static final ScalaFeelLogger LOGGER = ScalaFeelLogger.LOGGER;
    protected CustomFunction customFunction = new CustomFunction();
    protected int functionCount = 0;

    @Override
    public CustomFunctionBuilder setParams(String ... params) {
        List<String> paramList = Arrays.asList(params);
        this.customFunction.setParams(paramList);
        return this;
    }

    @Override
    public CustomFunctionBuilder enableVarargs() {
        this.customFunction.setHasVarargs(true);
        return this;
    }

    @Override
    public CustomFunctionBuilder setReturnValue(Object returnValue) {
        ++this.functionCount;
        this.customFunction.setFunction(args -> returnValue);
        return this;
    }

    @Override
    public CustomFunctionBuilder setFunction(Function<List<Object>, Object> function) {
        ++this.functionCount;
        this.customFunction.setFunction(function);
        return this;
    }

    @Override
    public CustomFunction build() {
        this.checkHasFunction();
        return this.customFunction;
    }

    protected void checkHasFunction() {
        if (this.functionCount > 1) {
            throw LOGGER.functionCountExceededException();
        }
    }
}

