/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.impl.juel;

import jakarta.el.ELException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.operaton.bpm.impl.juel.LocalMessages;
import org.operaton.bpm.impl.juel.TypeConverter;

public class NumberOperations {
    private static final Long LONG_ZERO = 0L;

    private static final boolean isDotEe(String value) {
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            switch (value.charAt(i)) {
                case '.': 
                case 'E': 
                case 'e': {
                    return true;
                }
            }
        }
        return false;
    }

    private static final boolean isDotEe(Object value) {
        String stringValue;
        return value instanceof String && NumberOperations.isDotEe(stringValue = (String)value);
    }

    private static final boolean isFloatOrDouble(Object value) {
        return value instanceof Float || value instanceof Double;
    }

    private static final boolean isFloatOrDoubleOrDotEe(Object value) {
        return NumberOperations.isFloatOrDouble(value) || NumberOperations.isDotEe(value);
    }

    private static final boolean isBigDecimalOrBigInteger(Object value) {
        return value instanceof BigDecimal || value instanceof BigInteger;
    }

    private static final boolean isBigDecimalOrFloatOrDoubleOrDotEe(Object value) {
        return value instanceof BigDecimal || NumberOperations.isFloatOrDoubleOrDotEe(value);
    }

    public static final Number add(TypeConverter converter, Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return LONG_ZERO;
        }
        if (o1 instanceof BigDecimal || o2 instanceof BigDecimal) {
            return converter.convert(o1, BigDecimal.class).add(converter.convert(o2, BigDecimal.class));
        }
        if (NumberOperations.isFloatOrDoubleOrDotEe(o1) || NumberOperations.isFloatOrDoubleOrDotEe(o2)) {
            if (o1 instanceof BigInteger || o2 instanceof BigInteger) {
                return converter.convert(o1, BigDecimal.class).add(converter.convert(o2, BigDecimal.class));
            }
            return converter.convert(o1, Double.class) + converter.convert(o2, Double.class);
        }
        if (o1 instanceof BigInteger || o2 instanceof BigInteger) {
            return converter.convert(o1, BigInteger.class).add(converter.convert(o2, BigInteger.class));
        }
        return converter.convert(o1, Long.class) + converter.convert(o2, Long.class);
    }

    public static final Number sub(TypeConverter converter, Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return LONG_ZERO;
        }
        if (o1 instanceof BigDecimal || o2 instanceof BigDecimal) {
            return converter.convert(o1, BigDecimal.class).subtract(converter.convert(o2, BigDecimal.class));
        }
        if (NumberOperations.isFloatOrDoubleOrDotEe(o1) || NumberOperations.isFloatOrDoubleOrDotEe(o2)) {
            if (o1 instanceof BigInteger || o2 instanceof BigInteger) {
                return converter.convert(o1, BigDecimal.class).subtract(converter.convert(o2, BigDecimal.class));
            }
            return converter.convert(o1, Double.class) - converter.convert(o2, Double.class);
        }
        if (o1 instanceof BigInteger || o2 instanceof BigInteger) {
            return converter.convert(o1, BigInteger.class).subtract(converter.convert(o2, BigInteger.class));
        }
        return converter.convert(o1, Long.class) - converter.convert(o2, Long.class);
    }

    public static final Number mul(TypeConverter converter, Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return LONG_ZERO;
        }
        if (o1 instanceof BigDecimal || o2 instanceof BigDecimal) {
            return converter.convert(o1, BigDecimal.class).multiply(converter.convert(o2, BigDecimal.class));
        }
        if (NumberOperations.isFloatOrDoubleOrDotEe(o1) || NumberOperations.isFloatOrDoubleOrDotEe(o2)) {
            if (o1 instanceof BigInteger || o2 instanceof BigInteger) {
                return converter.convert(o1, BigDecimal.class).multiply(converter.convert(o2, BigDecimal.class));
            }
            return converter.convert(o1, Double.class) * converter.convert(o2, Double.class);
        }
        if (o1 instanceof BigInteger || o2 instanceof BigInteger) {
            return converter.convert(o1, BigInteger.class).multiply(converter.convert(o2, BigInteger.class));
        }
        return converter.convert(o1, Long.class) * converter.convert(o2, Long.class);
    }

    public static final Number div(TypeConverter converter, Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return LONG_ZERO;
        }
        if (NumberOperations.isBigDecimalOrBigInteger(o1) || NumberOperations.isBigDecimalOrBigInteger(o2)) {
            return converter.convert(o1, BigDecimal.class).divide(converter.convert(o2, BigDecimal.class), RoundingMode.HALF_UP);
        }
        return converter.convert(o1, Double.class) / converter.convert(o2, Double.class);
    }

    public static final Number mod(TypeConverter converter, Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return LONG_ZERO;
        }
        if (NumberOperations.isBigDecimalOrFloatOrDoubleOrDotEe(o1) || NumberOperations.isBigDecimalOrFloatOrDoubleOrDotEe(o2)) {
            return converter.convert(o1, Double.class) % converter.convert(o2, Double.class);
        }
        if (o1 instanceof BigInteger || o2 instanceof BigInteger) {
            return converter.convert(o1, BigInteger.class).remainder(converter.convert(o2, BigInteger.class));
        }
        return converter.convert(o1, Long.class) % converter.convert(o2, Long.class);
    }

    public static final Number neg(TypeConverter converter, Object value) {
        if (value == null) {
            return LONG_ZERO;
        }
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)value;
            return bigDecimal.negate();
        }
        if (value instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)value;
            return bigInteger.negate();
        }
        if (value instanceof Double) {
            Double doubleValue = (Double)value;
            return -doubleValue.doubleValue();
        }
        if (value instanceof Float) {
            Float floatValue = (Float)value;
            return Float.valueOf(-floatValue.floatValue());
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            if (NumberOperations.isDotEe(stringValue)) {
                return -converter.convert(value, Double.class).doubleValue();
            }
            return -converter.convert(value, Long.class).longValue();
        }
        if (value instanceof Long) {
            Long longValue = (Long)value;
            return -longValue.longValue();
        }
        if (value instanceof Integer) {
            Integer integerValue = (Integer)value;
            return -integerValue.intValue();
        }
        if (value instanceof Short) {
            Short shortValue = (Short)value;
            return -shortValue.shortValue();
        }
        if (value instanceof Byte) {
            Byte byteValue = (Byte)value;
            return -byteValue.byteValue();
        }
        throw new ELException(LocalMessages.get("error.negate", value.getClass()));
    }
}

