/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.impl.juel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.operaton.bpm.impl.juel.AstBinary;
import org.operaton.bpm.impl.juel.AstBoolean;
import org.operaton.bpm.impl.juel.AstBracket;
import org.operaton.bpm.impl.juel.AstChoice;
import org.operaton.bpm.impl.juel.AstComposite;
import org.operaton.bpm.impl.juel.AstDot;
import org.operaton.bpm.impl.juel.AstEval;
import org.operaton.bpm.impl.juel.AstFunction;
import org.operaton.bpm.impl.juel.AstIdentifier;
import org.operaton.bpm.impl.juel.AstMethod;
import org.operaton.bpm.impl.juel.AstNested;
import org.operaton.bpm.impl.juel.AstNode;
import org.operaton.bpm.impl.juel.AstNull;
import org.operaton.bpm.impl.juel.AstNumber;
import org.operaton.bpm.impl.juel.AstParameters;
import org.operaton.bpm.impl.juel.AstProperty;
import org.operaton.bpm.impl.juel.AstString;
import org.operaton.bpm.impl.juel.AstText;
import org.operaton.bpm.impl.juel.AstUnary;
import org.operaton.bpm.impl.juel.Builder;
import org.operaton.bpm.impl.juel.FunctionNode;
import org.operaton.bpm.impl.juel.IdentifierNode;
import org.operaton.bpm.impl.juel.LocalMessages;
import org.operaton.bpm.impl.juel.Scanner;
import org.operaton.bpm.impl.juel.Tree;

public class Parser {
    private static final String EXPR_FIRST = Scanner.Symbol.IDENTIFIER + "|" + Scanner.Symbol.STRING + "|" + Scanner.Symbol.FLOAT + "|" + Scanner.Symbol.INTEGER + "|" + Scanner.Symbol.TRUE + "|" + Scanner.Symbol.FALSE + "|" + Scanner.Symbol.NULL + "|" + Scanner.Symbol.MINUS + "|" + Scanner.Symbol.NOT + "|" + Scanner.Symbol.EMPTY + "|" + Scanner.Symbol.LPAREN;
    protected final Builder context;
    protected final Scanner scanner;
    private List<IdentifierNode> identifiers = Collections.emptyList();
    private List<FunctionNode> functions = Collections.emptyList();
    private List<LookaheadToken> lookahead = Collections.emptyList();
    private Scanner.Token token;
    private int position;
    protected Map<Scanner.ExtensionToken, ExtensionHandler> extensions = Collections.emptyMap();

    public Parser(Builder context, String input) {
        this.context = context;
        this.scanner = this.createScanner(input);
    }

    protected Scanner createScanner(String expression) {
        return new Scanner(expression);
    }

    public void putExtensionHandler(Scanner.ExtensionToken token, ExtensionHandler extension) {
        if (this.extensions.isEmpty()) {
            this.extensions = new HashMap<Scanner.ExtensionToken, ExtensionHandler>(16);
        }
        this.extensions.put(token, extension);
    }

    protected ExtensionHandler getExtensionHandler(Scanner.Token token) {
        return this.extensions.get(token);
    }

    protected Number parseInteger(String string) throws ParseException {
        try {
            return Long.valueOf(string);
        }
        catch (NumberFormatException e) {
            this.fail(Scanner.Symbol.INTEGER);
            return null;
        }
    }

    protected Number parseFloat(String string) throws ParseException {
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException e) {
            this.fail(Scanner.Symbol.FLOAT);
            return null;
        }
    }

    protected AstBinary createAstBinary(AstNode left, AstNode right, AstBinary.Operator operator) {
        return new AstBinary(left, right, operator);
    }

    protected AstBracket createAstBracket(AstNode base, AstNode property, boolean lvalue, boolean strict) {
        return new AstBracket(base, property, lvalue, strict);
    }

    protected AstChoice createAstChoice(AstNode question, AstNode yes, AstNode no) {
        return new AstChoice(question, yes, no);
    }

    protected AstComposite createAstComposite(List<AstNode> nodes) {
        return new AstComposite(nodes);
    }

    protected AstDot createAstDot(AstNode base, String property, boolean lvalue) {
        return new AstDot(base, property, lvalue);
    }

    protected AstFunction createAstFunction(String name, int index, AstParameters params) {
        return new AstFunction(name, index, params, this.context.isEnabled(Builder.Feature.VARARGS));
    }

    protected AstIdentifier createAstIdentifier(String name, int index) {
        return new AstIdentifier(name, index);
    }

    protected AstMethod createAstMethod(AstProperty property, AstParameters params) {
        return new AstMethod(property, params);
    }

    protected AstUnary createAstUnary(AstNode child, AstUnary.Operator operator) {
        return new AstUnary(child, operator);
    }

    protected final List<FunctionNode> getFunctions() {
        return this.functions;
    }

    protected final List<IdentifierNode> getIdentifiers() {
        return this.identifiers;
    }

    protected final Scanner.Token getToken() {
        return this.token;
    }

    protected void fail(String expected) throws ParseException {
        throw new ParseException(this.position, "'" + this.token.getImage() + "'", expected);
    }

    protected void fail(Scanner.Symbol expected) throws ParseException {
        this.fail(expected.toString());
    }

    protected final Scanner.Token lookahead(int index) throws Scanner.ScanException, ParseException {
        if (this.lookahead.isEmpty()) {
            this.lookahead = new LinkedList<LookaheadToken>();
        }
        while (index >= this.lookahead.size()) {
            this.lookahead.add(new LookaheadToken(this.scanner.next(), this.scanner.getPosition()));
        }
        return this.lookahead.get((int)index).token;
    }

    protected final Scanner.Token consumeToken() throws Scanner.ScanException, ParseException {
        Scanner.Token result = this.token;
        if (this.lookahead.isEmpty()) {
            this.token = this.scanner.next();
            this.position = this.scanner.getPosition();
        } else {
            LookaheadToken next = this.lookahead.remove(0);
            this.token = next.token;
            this.position = next.position;
        }
        return result;
    }

    protected final Scanner.Token consumeToken(Scanner.Symbol expected) throws Scanner.ScanException, ParseException {
        if (this.token.getSymbol() != expected) {
            this.fail(expected);
        }
        return this.consumeToken();
    }

    public Tree tree() throws Scanner.ScanException, ParseException {
        this.consumeToken();
        AstNode t = this.text();
        if (this.token.getSymbol() == Scanner.Symbol.EOF) {
            if (t == null) {
                t = new AstText("");
            }
            return new Tree(t, this.functions, this.identifiers, false);
        }
        AstEval e = this.eval();
        if (this.token.getSymbol() == Scanner.Symbol.EOF && t == null) {
            return new Tree(e, this.functions, this.identifiers, e.isDeferred());
        }
        ArrayList<AstNode> list = new ArrayList<AstNode>();
        if (t != null) {
            list.add(t);
        }
        list.add(e);
        t = this.text();
        if (t != null) {
            list.add(t);
        }
        while (this.token.getSymbol() != Scanner.Symbol.EOF) {
            if (e.isDeferred()) {
                list.add(this.eval(true, true));
            } else {
                list.add(this.eval(true, false));
            }
            if ((t = this.text()) == null) continue;
            list.add(t);
        }
        return new Tree(this.createAstComposite(list), this.functions, this.identifiers, e.isDeferred());
    }

    protected AstNode text() throws Scanner.ScanException, ParseException {
        AstText v = null;
        if (this.token.getSymbol() == Scanner.Symbol.TEXT) {
            v = new AstText(this.token.getImage());
            this.consumeToken();
        }
        return v;
    }

    protected AstEval eval() throws Scanner.ScanException, ParseException {
        AstEval e = this.eval(false, false);
        if (e == null && (e = this.eval(false, true)) == null) {
            this.fail(Scanner.Symbol.START_EVAL_DEFERRED + "|" + Scanner.Symbol.START_EVAL_DYNAMIC);
        }
        return e;
    }

    protected AstEval eval(boolean required, boolean deferred) throws Scanner.ScanException, ParseException {
        Scanner.Symbol start_eval;
        AstEval v = null;
        Scanner.Symbol symbol = start_eval = deferred ? Scanner.Symbol.START_EVAL_DEFERRED : Scanner.Symbol.START_EVAL_DYNAMIC;
        if (this.token.getSymbol() == start_eval) {
            this.consumeToken();
            v = new AstEval(this.expr(true), deferred);
            this.consumeToken(Scanner.Symbol.END_EVAL);
        } else if (required) {
            this.fail(start_eval);
        }
        return v;
    }

    protected AstNode expr(boolean required) throws Scanner.ScanException, ParseException {
        AstNode v = this.or(required);
        if (v == null) {
            return null;
        }
        if (this.token.getSymbol() == Scanner.Symbol.QUESTION) {
            this.consumeToken();
            AstNode a = this.expr(true);
            this.consumeToken(Scanner.Symbol.COLON);
            AstNode b = this.expr(true);
            v = this.createAstChoice(v, a, b);
        }
        return v;
    }

    protected AstNode or(boolean required) throws Scanner.ScanException, ParseException {
        AstNode v = this.and(required);
        if (v == null) {
            return null;
        }
        block4: while (true) {
            switch (this.token.getSymbol()) {
                case OR: {
                    this.consumeToken();
                    v = this.createAstBinary(v, this.and(true), AstBinary.OR);
                    continue block4;
                }
                case EXTENSION: {
                    if (this.getExtensionHandler(this.token).getExtensionPoint() != ExtensionPoint.OR) break block4;
                    v = this.getExtensionHandler(this.consumeToken()).createAstNode(v, this.and(true));
                    continue block4;
                }
            }
            break;
        }
        return v;
    }

    protected AstNode and(boolean required) throws Scanner.ScanException, ParseException {
        AstNode v = this.eq(required);
        if (v == null) {
            return null;
        }
        block4: while (true) {
            switch (this.token.getSymbol()) {
                case AND: {
                    this.consumeToken();
                    v = this.createAstBinary(v, this.eq(true), AstBinary.AND);
                    continue block4;
                }
                case EXTENSION: {
                    if (this.getExtensionHandler(this.token).getExtensionPoint() != ExtensionPoint.AND) break block4;
                    v = this.getExtensionHandler(this.consumeToken()).createAstNode(v, this.eq(true));
                    continue block4;
                }
            }
            break;
        }
        return v;
    }

    protected AstNode eq(boolean required) throws Scanner.ScanException, ParseException {
        AstNode v = this.cmp(required);
        if (v == null) {
            return null;
        }
        block5: while (true) {
            switch (this.token.getSymbol()) {
                case EQ: {
                    this.consumeToken();
                    v = this.createAstBinary(v, this.cmp(true), AstBinary.EQ);
                    continue block5;
                }
                case NE: {
                    this.consumeToken();
                    v = this.createAstBinary(v, this.cmp(true), AstBinary.NE);
                    continue block5;
                }
                case EXTENSION: {
                    if (this.getExtensionHandler(this.token).getExtensionPoint() != ExtensionPoint.EQ) break block5;
                    v = this.getExtensionHandler(this.consumeToken()).createAstNode(v, this.cmp(true));
                    continue block5;
                }
            }
            break;
        }
        return v;
    }

    protected AstNode cmp(boolean required) throws Scanner.ScanException, ParseException {
        AstNode v = this.add(required);
        if (v == null) {
            return null;
        }
        block7: while (true) {
            switch (this.token.getSymbol()) {
                case LT: {
                    this.consumeToken();
                    v = this.createAstBinary(v, this.add(true), AstBinary.LT);
                    continue block7;
                }
                case LE: {
                    this.consumeToken();
                    v = this.createAstBinary(v, this.add(true), AstBinary.LE);
                    continue block7;
                }
                case GE: {
                    this.consumeToken();
                    v = this.createAstBinary(v, this.add(true), AstBinary.GE);
                    continue block7;
                }
                case GT: {
                    this.consumeToken();
                    v = this.createAstBinary(v, this.add(true), AstBinary.GT);
                    continue block7;
                }
                case EXTENSION: {
                    if (this.getExtensionHandler(this.token).getExtensionPoint() != ExtensionPoint.CMP) break block7;
                    v = this.getExtensionHandler(this.consumeToken()).createAstNode(v, this.add(true));
                    continue block7;
                }
            }
            break;
        }
        return v;
    }

    protected AstNode add(boolean required) throws Scanner.ScanException, ParseException {
        AstNode v = this.mul(required);
        if (v == null) {
            return null;
        }
        block5: while (true) {
            switch (this.token.getSymbol()) {
                case PLUS: {
                    this.consumeToken();
                    v = this.createAstBinary(v, this.mul(true), AstBinary.ADD);
                    continue block5;
                }
                case MINUS: {
                    this.consumeToken();
                    v = this.createAstBinary(v, this.mul(true), AstBinary.SUB);
                    continue block5;
                }
                case EXTENSION: {
                    if (this.getExtensionHandler(this.token).getExtensionPoint() != ExtensionPoint.ADD) break block5;
                    v = this.getExtensionHandler(this.consumeToken()).createAstNode(v, this.mul(true));
                    continue block5;
                }
            }
            break;
        }
        return v;
    }

    protected AstNode mul(boolean required) throws Scanner.ScanException, ParseException {
        AstNode v = this.unary(required);
        if (v == null) {
            return null;
        }
        block6: while (true) {
            switch (this.token.getSymbol()) {
                case MUL: {
                    this.consumeToken();
                    v = this.createAstBinary(v, this.unary(true), AstBinary.MUL);
                    continue block6;
                }
                case DIV: {
                    this.consumeToken();
                    v = this.createAstBinary(v, this.unary(true), AstBinary.DIV);
                    continue block6;
                }
                case MOD: {
                    this.consumeToken();
                    v = this.createAstBinary(v, this.unary(true), AstBinary.MOD);
                    continue block6;
                }
                case EXTENSION: {
                    if (this.getExtensionHandler(this.token).getExtensionPoint() != ExtensionPoint.MUL) break block6;
                    v = this.getExtensionHandler(this.consumeToken()).createAstNode(v, this.unary(true));
                    continue block6;
                }
            }
            break;
        }
        return v;
    }

    protected AstNode unary(boolean required) throws Scanner.ScanException, ParseException {
        AstNode v = null;
        switch (this.token.getSymbol()) {
            case NOT: {
                this.consumeToken();
                v = this.createAstUnary(this.unary(true), AstUnary.NOT);
                break;
            }
            case MINUS: {
                this.consumeToken();
                v = this.createAstUnary(this.unary(true), AstUnary.NEG);
                break;
            }
            case EMPTY: {
                this.consumeToken();
                v = this.createAstUnary(this.unary(true), AstUnary.EMPTY);
                break;
            }
            case EXTENSION: {
                if (this.getExtensionHandler(this.token).getExtensionPoint() == ExtensionPoint.UNARY) {
                    v = this.getExtensionHandler(this.consumeToken()).createAstNode(this.unary(true));
                    break;
                }
            }
            default: {
                v = this.value();
            }
        }
        if (v == null && required) {
            this.fail(EXPR_FIRST);
        }
        return v;
    }

    protected AstNode value() throws Scanner.ScanException, ParseException {
        boolean lvalue = true;
        AstNode v = this.nonliteral();
        if (v == null) {
            v = this.literal();
            if (v == null) {
                return null;
            }
            lvalue = false;
        }
        block4: while (true) {
            switch (this.token.getSymbol()) {
                case DOT: {
                    this.consumeToken();
                    String name = this.consumeToken(Scanner.Symbol.IDENTIFIER).getImage();
                    AstDot dot = this.createAstDot(v, name, lvalue);
                    if (this.token.getSymbol() == Scanner.Symbol.LPAREN && this.context.isEnabled(Builder.Feature.METHOD_INVOCATIONS)) {
                        v = this.createAstMethod(dot, this.params());
                        continue block4;
                    }
                    v = dot;
                    continue block4;
                }
                case LBRACK: {
                    this.consumeToken();
                    AstNode property = this.expr(true);
                    boolean strict = !this.context.isEnabled(Builder.Feature.NULL_PROPERTIES);
                    this.consumeToken(Scanner.Symbol.RBRACK);
                    AstBracket bracket = this.createAstBracket(v, property, lvalue, strict);
                    if (this.token.getSymbol() == Scanner.Symbol.LPAREN && this.context.isEnabled(Builder.Feature.METHOD_INVOCATIONS)) {
                        v = this.createAstMethod(bracket, this.params());
                        continue block4;
                    }
                    v = bracket;
                    continue block4;
                }
            }
            break;
        }
        return v;
    }

    protected AstNode nonliteral() throws Scanner.ScanException, ParseException {
        AstNode v = null;
        switch (this.token.getSymbol()) {
            case IDENTIFIER: {
                Object name = this.consumeToken().getImage();
                if (this.token.getSymbol() == Scanner.Symbol.COLON && this.lookahead(0).getSymbol() == Scanner.Symbol.IDENTIFIER && this.lookahead(1).getSymbol() == Scanner.Symbol.LPAREN) {
                    this.consumeToken();
                    name = (String)name + ":" + this.token.getImage();
                    this.consumeToken();
                }
                if (this.token.getSymbol() == Scanner.Symbol.LPAREN) {
                    v = this.function((String)name, this.params());
                    break;
                }
                v = this.identifier((String)name);
                break;
            }
            case LPAREN: {
                this.consumeToken();
                v = this.expr(true);
                this.consumeToken(Scanner.Symbol.RPAREN);
                v = new AstNested(v);
            }
        }
        return v;
    }

    protected AstParameters params() throws Scanner.ScanException, ParseException {
        this.consumeToken(Scanner.Symbol.LPAREN);
        List<AstNode> l = Collections.emptyList();
        AstNode v = this.expr(false);
        if (v != null) {
            l = new ArrayList();
            l.add(v);
            while (this.token.getSymbol() == Scanner.Symbol.COMMA) {
                this.consumeToken();
                l.add(this.expr(true));
            }
        }
        this.consumeToken(Scanner.Symbol.RPAREN);
        return new AstParameters(l);
    }

    protected AstNode literal() throws Scanner.ScanException, ParseException {
        AstNode v = null;
        switch (this.token.getSymbol()) {
            case TRUE: {
                v = new AstBoolean(true);
                this.consumeToken();
                break;
            }
            case FALSE: {
                v = new AstBoolean(false);
                this.consumeToken();
                break;
            }
            case STRING: {
                v = new AstString(this.token.getImage());
                this.consumeToken();
                break;
            }
            case INTEGER: {
                v = new AstNumber(this.parseInteger(this.token.getImage()));
                this.consumeToken();
                break;
            }
            case FLOAT: {
                v = new AstNumber(this.parseFloat(this.token.getImage()));
                this.consumeToken();
                break;
            }
            case NULL: {
                v = new AstNull();
                this.consumeToken();
                break;
            }
            case EXTENSION: {
                if (this.getExtensionHandler(this.token).getExtensionPoint() != ExtensionPoint.LITERAL) break;
                v = this.getExtensionHandler(this.consumeToken()).createAstNode(new AstNode[0]);
            }
        }
        return v;
    }

    protected final AstFunction function(String name, AstParameters params) {
        if (this.functions.isEmpty()) {
            this.functions = new ArrayList<FunctionNode>(4);
        }
        AstFunction function = this.createAstFunction(name, this.functions.size(), params);
        this.functions.add(function);
        return function;
    }

    protected final AstIdentifier identifier(String name) {
        if (this.identifiers.isEmpty()) {
            this.identifiers = new ArrayList<IdentifierNode>(4);
        }
        AstIdentifier identifier = this.createAstIdentifier(name, this.identifiers.size());
        this.identifiers.add(identifier);
        return identifier;
    }

    public static abstract class ExtensionHandler {
        private final ExtensionPoint point;

        public ExtensionHandler(ExtensionPoint point) {
            this.point = point;
        }

        public ExtensionPoint getExtensionPoint() {
            return this.point;
        }

        public abstract AstNode createAstNode(AstNode ... var1);
    }

    public static class ParseException
    extends Exception {
        final int position;
        final String encountered;
        final String expected;

        public ParseException(int position, String encountered, String expected) {
            super(LocalMessages.get("error.parse", position, encountered, expected));
            this.position = position;
            this.encountered = encountered;
            this.expected = expected;
        }
    }

    private static final class LookaheadToken {
        final Scanner.Token token;
        final int position;

        LookaheadToken(Scanner.Token token, int position) {
            this.token = token;
            this.position = position;
        }
    }

    public static enum ExtensionPoint {
        OR,
        AND,
        EQ,
        CMP,
        ADD,
        MUL,
        UNARY,
        LITERAL;

    }
}

