/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.impl.juel;

import org.operaton.bpm.impl.juel.Tree;
import org.operaton.bpm.impl.juel.TreeBuilder;
import org.operaton.bpm.impl.juel.TreeBuilderException;
import org.operaton.bpm.impl.juel.TreeCache;

public class TreeStore {
    private final TreeCache cache;
    private final TreeBuilder builder;

    public TreeStore(TreeBuilder builder, TreeCache cache) {
        this.builder = builder;
        this.cache = cache;
    }

    public TreeBuilder getBuilder() {
        return this.builder;
    }

    public Tree get(String expression) throws TreeBuilderException {
        if (this.cache == null) {
            return this.builder.build(expression);
        }
        Tree tree = this.cache.get(expression);
        if (tree == null) {
            tree = this.builder.build(expression);
            this.cache.put(expression, tree);
        }
        return tree;
    }
}

