/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.impl.juel;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.MethodInfo;
import jakarta.el.MethodNotFoundException;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.ValueReference;
import org.operaton.bpm.impl.juel.AstNode;
import org.operaton.bpm.impl.juel.AstParameters;
import org.operaton.bpm.impl.juel.AstProperty;
import org.operaton.bpm.impl.juel.Bindings;
import org.operaton.bpm.impl.juel.LocalMessages;
import org.operaton.bpm.impl.juel.Node;

public class AstMethod
extends AstNode {
    private final AstProperty property;
    private final AstParameters params;

    public AstMethod(AstProperty property, AstParameters params) {
        this.property = property;
        this.params = params;
    }

    @Override
    public boolean isLiteralText() {
        return false;
    }

    @Override
    public Class<?> getType(Bindings bindings, ELContext context) {
        return null;
    }

    @Override
    public boolean isReadOnly(Bindings bindings, ELContext context) {
        return true;
    }

    @Override
    public void setValue(Bindings bindings, ELContext context, Object value) {
        throw new ELException(LocalMessages.get("error.value.set.rvalue", this.getStructuralId(bindings)));
    }

    @Override
    public MethodInfo getMethodInfo(Bindings bindings, ELContext context, Class<?> returnType, Class<?>[] paramTypes) {
        return null;
    }

    @Override
    public boolean isLeftValue() {
        return false;
    }

    @Override
    public boolean isMethodInvocation() {
        return true;
    }

    @Override
    public final ValueReference getValueReference(Bindings bindings, ELContext context) {
        return null;
    }

    @Override
    public void appendStructure(StringBuilder builder, Bindings bindings) {
        this.property.appendStructure(builder, bindings);
        this.params.appendStructure(builder, bindings);
    }

    @Override
    public Object eval(Bindings bindings, ELContext context) {
        return this.invoke(bindings, context, null, null, null);
    }

    @Override
    public Object invoke(Bindings bindings, ELContext context, Class<?> returnType, Class<?>[] paramTypes, Object[] paramValues) {
        Object base = this.property.getPrefix().eval(bindings, context);
        if (base == null) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.base.null", this.property.getPrefix()));
        }
        Object method = this.property.getProperty(bindings, context);
        if (method == null) {
            throw new PropertyNotFoundException(LocalMessages.get("error.property.method.notfound", "null", base));
        }
        String name = bindings.convert(method, String.class);
        paramValues = this.params.eval(bindings, context);
        context.setPropertyResolved(false);
        Object result = context.getELResolver().invoke(context, base, (Object)name, (Class[])paramTypes, paramValues);
        if (!context.isPropertyResolved()) {
            throw new MethodNotFoundException(LocalMessages.get("error.property.method.notfound", name, base.getClass()));
        }
        return result;
    }

    @Override
    public int getCardinality() {
        return 2;
    }

    @Override
    public Node getChild(int i) {
        return switch (i) {
            case 0 -> this.property;
            case 1 -> this.params;
            default -> null;
        };
    }

    public String toString() {
        return "<method>";
    }
}

