/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.impl.juel;

import jakarta.el.ELException;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.operaton.bpm.impl.juel.LocalMessages;
import org.operaton.bpm.impl.juel.TypeConverter;

public class TypeConverterImpl
implements TypeConverter {
    private static final long serialVersionUID = 1L;
    private static final String ERROR_COERCE_TYPE = "error.coerce.type";
    private static final String ERROR_COERCE_VALUE = "error.coerce.value";

    protected Boolean coerceToBoolean(Object value) {
        if (value == null || "".equals(value)) {
            return Boolean.FALSE;
        }
        if (value instanceof Boolean) {
            Boolean isBoolean = (Boolean)value;
            return isBoolean;
        }
        if (value instanceof String) {
            String string = (String)value;
            return Boolean.valueOf(string);
        }
        throw new ELException(LocalMessages.get(ERROR_COERCE_TYPE, value.getClass(), Boolean.class));
    }

    protected Character coerceToCharacter(Object value) {
        if (value == null || "".equals(value)) {
            return Character.valueOf('\u0000');
        }
        if (value instanceof Character) {
            Character character = (Character)value;
            return character;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return Character.valueOf((char)number.shortValue());
        }
        if (value instanceof String) {
            String string = (String)value;
            return Character.valueOf(string.charAt(0));
        }
        throw new ELException(LocalMessages.get(ERROR_COERCE_TYPE, value.getClass(), Character.class));
    }

    protected BigDecimal coerceToBigDecimal(Object value) {
        if (value == null || "".equals(value)) {
            return BigDecimal.valueOf(0L);
        }
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)value;
            return bigDecimal;
        }
        if (value instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)value;
            return new BigDecimal(bigInteger);
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return BigDecimal.valueOf(number.doubleValue());
        }
        if (value instanceof String) {
            String string = (String)value;
            try {
                return new BigDecimal(string);
            }
            catch (NumberFormatException e) {
                throw new ELException(LocalMessages.get(ERROR_COERCE_VALUE, value, BigDecimal.class));
            }
        }
        if (value instanceof Character) {
            Character character = (Character)value;
            return BigDecimal.valueOf((short)character.charValue());
        }
        throw new ELException(LocalMessages.get(ERROR_COERCE_TYPE, value.getClass(), BigDecimal.class));
    }

    protected BigInteger coerceToBigInteger(Object value) {
        if (value == null || "".equals(value)) {
            return BigInteger.valueOf(0L);
        }
        if (value instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)value;
            return bigInteger;
        }
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)value;
            return bigDecimal.toBigInteger();
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return BigInteger.valueOf(number.longValue());
        }
        if (value instanceof String) {
            String string = (String)value;
            try {
                return new BigInteger(string);
            }
            catch (NumberFormatException e) {
                throw new ELException(LocalMessages.get(ERROR_COERCE_VALUE, value, BigInteger.class));
            }
        }
        if (value instanceof Character) {
            Character character = (Character)value;
            return BigInteger.valueOf((short)character.charValue());
        }
        throw new ELException(LocalMessages.get(ERROR_COERCE_TYPE, value.getClass(), BigInteger.class));
    }

    protected Double coerceToDouble(Object value) {
        if (value == null || "".equals(value)) {
            return 0.0;
        }
        if (value instanceof Double) {
            Double doubleValue = (Double)value;
            return doubleValue;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.doubleValue();
        }
        if (value instanceof String) {
            String string = (String)value;
            try {
                return Double.valueOf(string);
            }
            catch (NumberFormatException e) {
                throw new ELException(LocalMessages.get(ERROR_COERCE_VALUE, value, Double.class));
            }
        }
        if (value instanceof Character) {
            Character character = (Character)value;
            return (short)character.charValue();
        }
        throw new ELException(LocalMessages.get(ERROR_COERCE_TYPE, value.getClass(), Double.class));
    }

    protected Float coerceToFloat(Object value) {
        if (value == null || "".equals(value)) {
            return Float.valueOf(0.0f);
        }
        if (value instanceof Float) {
            Float floatValue = (Float)value;
            return floatValue;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return Float.valueOf(number.floatValue());
        }
        if (value instanceof String) {
            String string = (String)value;
            try {
                return Float.valueOf(string);
            }
            catch (NumberFormatException e) {
                throw new ELException(LocalMessages.get(ERROR_COERCE_VALUE, value, Float.class));
            }
        }
        if (value instanceof Character) {
            Character character = (Character)value;
            return Float.valueOf((short)character.charValue());
        }
        throw new ELException(LocalMessages.get(ERROR_COERCE_TYPE, value.getClass(), Float.class));
    }

    protected Long coerceToLong(Object value) {
        if (value == null || "".equals(value)) {
            return 0L;
        }
        if (value instanceof Long) {
            Long longValue = (Long)value;
            return longValue;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.longValue();
        }
        if (value instanceof String) {
            String string = (String)value;
            try {
                return Long.valueOf(string);
            }
            catch (NumberFormatException e) {
                throw new ELException(LocalMessages.get(ERROR_COERCE_VALUE, value, Long.class));
            }
        }
        if (value instanceof Character) {
            Character character = (Character)value;
            return (short)character.charValue();
        }
        throw new ELException(LocalMessages.get(ERROR_COERCE_TYPE, value.getClass(), Long.class));
    }

    protected Integer coerceToInteger(Object value) {
        if (value == null || "".equals(value)) {
            return 0;
        }
        if (value instanceof Integer) {
            Integer integerValue = (Integer)value;
            return integerValue;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.intValue();
        }
        if (value instanceof String) {
            String string = (String)value;
            try {
                return Integer.valueOf(string);
            }
            catch (NumberFormatException e) {
                throw new ELException(LocalMessages.get(ERROR_COERCE_VALUE, value, Integer.class));
            }
        }
        if (value instanceof Character) {
            Character character = (Character)value;
            return (short)character.charValue();
        }
        throw new ELException(LocalMessages.get(ERROR_COERCE_TYPE, value.getClass(), Integer.class));
    }

    protected Short coerceToShort(Object value) {
        if (value == null || "".equals(value)) {
            return (short)0;
        }
        if (value instanceof Short) {
            Short shortValue = (Short)value;
            return shortValue;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.shortValue();
        }
        if (value instanceof String) {
            String string = (String)value;
            try {
                return Short.valueOf(string);
            }
            catch (NumberFormatException e) {
                throw new ELException(LocalMessages.get(ERROR_COERCE_VALUE, value, Short.class));
            }
        }
        if (value instanceof Character) {
            Character character = (Character)value;
            return (short)character.charValue();
        }
        throw new ELException(LocalMessages.get(ERROR_COERCE_TYPE, value.getClass(), Short.class));
    }

    protected Byte coerceToByte(Object value) {
        if (value == null || "".equals(value)) {
            return (byte)0;
        }
        if (value instanceof Byte) {
            Byte byteValue = (Byte)value;
            return byteValue;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.byteValue();
        }
        if (value instanceof String) {
            String string = (String)value;
            try {
                return Byte.valueOf(string);
            }
            catch (NumberFormatException e) {
                throw new ELException(LocalMessages.get(ERROR_COERCE_VALUE, value, Byte.class));
            }
        }
        if (value instanceof Character) {
            Character character = (Character)value;
            return Short.valueOf((short)character.charValue()).byteValue();
        }
        throw new ELException(LocalMessages.get(ERROR_COERCE_TYPE, value.getClass(), Byte.class));
    }

    protected String coerceToString(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            String string = (String)value;
            return string;
        }
        if (value instanceof Enum) {
            Enum enumValue = (Enum)value;
            return enumValue.name();
        }
        return value.toString();
    }

    protected <T extends Enum<T>> T coerceToEnum(Object value, Class<T> type) {
        if (value == null || "".equals(value)) {
            return null;
        }
        if (type.isInstance(value)) {
            return (T)((Enum)value);
        }
        if (value instanceof String) {
            String string = (String)value;
            try {
                return Enum.valueOf(type, string);
            }
            catch (IllegalArgumentException e) {
                throw new ELException(LocalMessages.get(ERROR_COERCE_VALUE, value, type));
            }
        }
        throw new ELException(LocalMessages.get(ERROR_COERCE_TYPE, value.getClass(), type));
    }

    protected Object coerceStringToType(String value, Class<?> type) {
        PropertyEditor editor = PropertyEditorManager.findEditor(type);
        if (editor == null) {
            if ("".equals(value)) {
                return null;
            }
            throw new ELException(LocalMessages.get(ERROR_COERCE_TYPE, String.class, type));
        }
        if ("".equals(value)) {
            try {
                editor.setAsText(value);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        try {
            editor.setAsText(value);
        }
        catch (IllegalArgumentException e) {
            throw new ELException(LocalMessages.get(ERROR_COERCE_VALUE, value, type));
        }
        return editor.getValue();
    }

    protected Object coerceToType(Object value, Class<?> type) {
        if (type == String.class) {
            return this.coerceToString(value);
        }
        if (type == Long.class || type == Long.TYPE) {
            return this.coerceToLong(value);
        }
        if (type == Double.class || type == Double.TYPE) {
            return this.coerceToDouble(value);
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return this.coerceToBoolean(value);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return this.coerceToInteger(value);
        }
        if (type == Float.class || type == Float.TYPE) {
            return this.coerceToFloat(value);
        }
        if (type == Short.class || type == Short.TYPE) {
            return this.coerceToShort(value);
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return this.coerceToByte(value);
        }
        if (type == Character.class || type == Character.TYPE) {
            return this.coerceToCharacter(value);
        }
        if (type == BigDecimal.class) {
            return this.coerceToBigDecimal(value);
        }
        if (type == BigInteger.class) {
            return this.coerceToBigInteger(value);
        }
        if (type.getSuperclass() == Enum.class) {
            return this.coerceToEnum(value, type);
        }
        if (value == null || value.getClass() == type || type.isInstance(value)) {
            return value;
        }
        if (value instanceof String) {
            String string = (String)value;
            return this.coerceStringToType(string, type);
        }
        throw new ELException(LocalMessages.get(ERROR_COERCE_TYPE, value.getClass(), type));
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(this.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public <T> T convert(Object value, Class<T> type) throws ELException {
        return (T)this.coerceToType(value, type);
    }
}

