/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.model.bpmn.impl.instance;

import java.util.ArrayList;
import java.util.Collection;
import org.operaton.bpm.model.bpmn.impl.instance.BpmnModelElementInstanceImpl;
import org.operaton.bpm.model.bpmn.instance.BaseElement;
import org.operaton.bpm.model.bpmn.instance.Documentation;
import org.operaton.bpm.model.bpmn.instance.ExtensionElements;
import org.operaton.bpm.model.bpmn.instance.di.DiagramElement;
import org.operaton.bpm.model.xml.ModelBuilder;
import org.operaton.bpm.model.xml.impl.instance.ModelTypeInstanceContext;
import org.operaton.bpm.model.xml.instance.ModelElementInstance;
import org.operaton.bpm.model.xml.type.ModelElementType;
import org.operaton.bpm.model.xml.type.ModelElementTypeBuilder;
import org.operaton.bpm.model.xml.type.attribute.Attribute;
import org.operaton.bpm.model.xml.type.child.ChildElement;
import org.operaton.bpm.model.xml.type.child.ChildElementCollection;
import org.operaton.bpm.model.xml.type.child.SequenceBuilder;
import org.operaton.bpm.model.xml.type.reference.Reference;

public abstract class BaseElementImpl
extends BpmnModelElementInstanceImpl
implements BaseElement {
    protected static Attribute<String> idAttribute;
    protected static ChildElementCollection<Documentation> documentationCollection;
    protected static ChildElement<ExtensionElements> extensionElementsChild;

    public static void registerType(ModelBuilder bpmnModelBuilder) {
        ModelElementTypeBuilder typeBuilder = bpmnModelBuilder.defineType(BaseElement.class, "baseElement").namespaceUri("http://www.omg.org/spec/BPMN/20100524/MODEL").abstractType();
        idAttribute = typeBuilder.stringAttribute("id").idAttribute().build();
        SequenceBuilder sequenceBuilder = typeBuilder.sequence();
        documentationCollection = sequenceBuilder.elementCollection(Documentation.class).build();
        extensionElementsChild = sequenceBuilder.element(ExtensionElements.class).build();
        typeBuilder.build();
    }

    public BaseElementImpl(ModelTypeInstanceContext instanceContext) {
        super(instanceContext);
    }

    @Override
    public String getId() {
        return (String)idAttribute.getValue((ModelElementInstance)this);
    }

    @Override
    public void setId(String id) {
        idAttribute.setValue((ModelElementInstance)this, (Object)id);
    }

    @Override
    public Collection<Documentation> getDocumentations() {
        return documentationCollection.get((ModelElementInstance)this);
    }

    @Override
    public ExtensionElements getExtensionElements() {
        return (ExtensionElements)extensionElementsChild.getChild((ModelElementInstance)this);
    }

    @Override
    public void setExtensionElements(ExtensionElements extensionElements) {
        extensionElementsChild.setChild((ModelElementInstance)this, (ModelElementInstance)extensionElements);
    }

    @Override
    public DiagramElement getDiagramElement() {
        Collection<Reference> incomingReferences = this.getIncomingReferencesByType(DiagramElement.class);
        for (Reference reference : incomingReferences) {
            for (ModelElementInstance sourceElement : reference.findReferenceSourceElements((ModelElementInstance)this)) {
                String referenceIdentifier = reference.getReferenceIdentifier(sourceElement);
                if (referenceIdentifier == null || !referenceIdentifier.equals(this.getId())) continue;
                return (DiagramElement)sourceElement;
            }
        }
        return null;
    }

    public Collection<Reference> getIncomingReferencesByType(Class<? extends ModelElementInstance> referenceSourceTypeClass) {
        ArrayList<Reference> references = new ArrayList<Reference>();
        for (Reference reference : idAttribute.getIncomingReferences()) {
            ModelElementType sourceElementType = reference.getReferenceSourceElementType();
            Class sourceInstanceType = sourceElementType.getInstanceType();
            if (!referenceSourceTypeClass.isAssignableFrom(sourceInstanceType)) continue;
            references.add(reference);
        }
        return references;
    }
}

