/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.model.bpmn.builder;

import java.util.Collection;
import org.operaton.bpm.model.bpmn.BpmnModelException;
import org.operaton.bpm.model.bpmn.BpmnModelInstance;
import org.operaton.bpm.model.bpmn.builder.AbstractBpmnModelElementBuilder;
import org.operaton.bpm.model.bpmn.instance.Activity;
import org.operaton.bpm.model.bpmn.instance.Association;
import org.operaton.bpm.model.bpmn.instance.BaseElement;
import org.operaton.bpm.model.bpmn.instance.BpmnModelElementInstance;
import org.operaton.bpm.model.bpmn.instance.CompensateEventDefinition;
import org.operaton.bpm.model.bpmn.instance.Definitions;
import org.operaton.bpm.model.bpmn.instance.Documentation;
import org.operaton.bpm.model.bpmn.instance.Error;
import org.operaton.bpm.model.bpmn.instance.ErrorEventDefinition;
import org.operaton.bpm.model.bpmn.instance.Escalation;
import org.operaton.bpm.model.bpmn.instance.EscalationEventDefinition;
import org.operaton.bpm.model.bpmn.instance.Event;
import org.operaton.bpm.model.bpmn.instance.ExclusiveGateway;
import org.operaton.bpm.model.bpmn.instance.ExtensionElements;
import org.operaton.bpm.model.bpmn.instance.FlowElement;
import org.operaton.bpm.model.bpmn.instance.FlowNode;
import org.operaton.bpm.model.bpmn.instance.Gateway;
import org.operaton.bpm.model.bpmn.instance.Message;
import org.operaton.bpm.model.bpmn.instance.MessageEventDefinition;
import org.operaton.bpm.model.bpmn.instance.SequenceFlow;
import org.operaton.bpm.model.bpmn.instance.Signal;
import org.operaton.bpm.model.bpmn.instance.SignalEventDefinition;
import org.operaton.bpm.model.bpmn.instance.SubProcess;
import org.operaton.bpm.model.bpmn.instance.TimeCycle;
import org.operaton.bpm.model.bpmn.instance.TimeDate;
import org.operaton.bpm.model.bpmn.instance.TimeDuration;
import org.operaton.bpm.model.bpmn.instance.TimerEventDefinition;
import org.operaton.bpm.model.bpmn.instance.bpmndi.BpmnEdge;
import org.operaton.bpm.model.bpmn.instance.bpmndi.BpmnPlane;
import org.operaton.bpm.model.bpmn.instance.bpmndi.BpmnShape;
import org.operaton.bpm.model.bpmn.instance.dc.Bounds;
import org.operaton.bpm.model.bpmn.instance.di.Waypoint;
import org.operaton.bpm.model.xml.instance.ModelElementInstance;

public abstract class AbstractBaseElementBuilder<B extends AbstractBaseElementBuilder<B, E>, E extends BaseElement>
extends AbstractBpmnModelElementBuilder<B, E> {
    public static final double SPACE = 50.0;

    protected AbstractBaseElementBuilder(BpmnModelInstance modelInstance, E element, Class<?> selfType) {
        super(modelInstance, element, selfType);
    }

    protected <T extends BpmnModelElementInstance> T createInstance(Class<T> typeClass) {
        return (T)((BpmnModelElementInstance)this.modelInstance.newInstance(typeClass));
    }

    protected <T extends BaseElement> T createInstance(Class<T> typeClass, String identifier) {
        BaseElement instance = (BaseElement)this.createInstance(typeClass);
        if (identifier != null) {
            instance.setId(identifier);
            if (instance instanceof FlowElement) {
                FlowElement flowElement = (FlowElement)instance;
                flowElement.setName(identifier);
            }
        }
        return (T)instance;
    }

    protected <T extends BpmnModelElementInstance> T createChild(Class<T> typeClass) {
        return this.createChild(this.element, typeClass);
    }

    protected <T extends BaseElement> T createChild(Class<T> typeClass, String identifier) {
        return this.createChild(this.element, typeClass, identifier);
    }

    protected <T extends BpmnModelElementInstance> T createChild(BpmnModelElementInstance parent, Class<T> typeClass) {
        T instance = this.createInstance(typeClass);
        parent.addChildElement((ModelElementInstance)instance);
        return instance;
    }

    protected <T extends BaseElement> T createChild(BpmnModelElementInstance parent, Class<T> typeClass, String identifier) {
        T instance = this.createInstance(typeClass, identifier);
        parent.addChildElement((ModelElementInstance)instance);
        return instance;
    }

    protected <T extends BpmnModelElementInstance> T createSibling(Class<T> typeClass) {
        T instance = this.createInstance(typeClass);
        ((BaseElement)this.element).getParentElement().addChildElement(instance);
        return instance;
    }

    protected <T extends BaseElement> T createSibling(Class<T> typeClass, String identifier) {
        T instance = this.createInstance(typeClass, identifier);
        ((BaseElement)this.element).getParentElement().addChildElement(instance);
        return instance;
    }

    protected <T extends BpmnModelElementInstance> T getCreateSingleChild(Class<T> typeClass) {
        return this.getCreateSingleChild(this.element, typeClass);
    }

    protected <T extends BpmnModelElementInstance> T getCreateSingleChild(BpmnModelElementInstance parent, Class<T> typeClass) {
        Collection childrenOfType = parent.getChildElementsByType(typeClass);
        if (childrenOfType.isEmpty()) {
            return this.createChild(parent, typeClass);
        }
        if (childrenOfType.size() > 1) {
            throw new BpmnModelException("Element " + String.valueOf(parent) + " of type " + parent.getElementType().getTypeName() + " has more than one child element of type " + typeClass.getName());
        }
        return (T)((BpmnModelElementInstance)childrenOfType.iterator().next());
    }

    protected <T extends BpmnModelElementInstance> T getCreateSingleExtensionElement(Class<T> typeClass) {
        ExtensionElements extensionElements = this.getCreateSingleChild(ExtensionElements.class);
        return this.getCreateSingleChild(extensionElements, typeClass);
    }

    protected Message findMessageForName(String messageName) {
        Message message2;
        Collection messages = this.modelInstance.getModelElementsByType(Message.class);
        for (Message message2 : messages) {
            if (!messageName.equals(message2.getName())) continue;
            return message2;
        }
        Definitions definitions = this.modelInstance.getDefinitions();
        message2 = this.createChild(definitions, Message.class);
        message2.setName(messageName);
        return message2;
    }

    protected MessageEventDefinition createMessageEventDefinition(String messageName) {
        Message message = this.findMessageForName(messageName);
        MessageEventDefinition messageEventDefinition = this.createInstance(MessageEventDefinition.class);
        messageEventDefinition.setMessage(message);
        return messageEventDefinition;
    }

    protected MessageEventDefinition createEmptyMessageEventDefinition() {
        return this.createInstance(MessageEventDefinition.class);
    }

    protected Signal findSignalForName(String signalName) {
        Signal signal2;
        Collection signals = this.modelInstance.getModelElementsByType(Signal.class);
        for (Signal signal2 : signals) {
            if (!signalName.equals(signal2.getName())) continue;
            return signal2;
        }
        Definitions definitions = this.modelInstance.getDefinitions();
        signal2 = this.createChild(definitions, Signal.class);
        signal2.setName(signalName);
        return signal2;
    }

    protected SignalEventDefinition createSignalEventDefinition(String signalName) {
        Signal signal = this.findSignalForName(signalName);
        SignalEventDefinition signalEventDefinition = this.createInstance(SignalEventDefinition.class);
        signalEventDefinition.setSignal(signal);
        return signalEventDefinition;
    }

    protected ErrorEventDefinition findErrorDefinitionForCode(String errorCode) {
        Collection definitions = this.modelInstance.getModelElementsByType(ErrorEventDefinition.class);
        for (ErrorEventDefinition definition : definitions) {
            Error error = definition.getError();
            if (error == null || !error.getErrorCode().equals(errorCode)) continue;
            return definition;
        }
        return null;
    }

    protected Error findErrorForNameAndCode(String errorCode) {
        return this.findErrorForNameAndCode(errorCode, null);
    }

    protected Error findErrorForNameAndCode(String errorCode, String errorMessage) {
        Error error2;
        Collection errors = this.modelInstance.getModelElementsByType(Error.class);
        for (Error error2 : errors) {
            if (!errorCode.equals(error2.getErrorCode())) continue;
            return error2;
        }
        Definitions definitions = this.modelInstance.getDefinitions();
        error2 = this.createChild(definitions, Error.class);
        error2.setErrorCode(errorCode);
        if (errorMessage != null && !"".equals(errorMessage)) {
            error2.setOperatonErrorMessage(errorMessage);
        }
        return error2;
    }

    protected ErrorEventDefinition createEmptyErrorEventDefinition() {
        return this.createInstance(ErrorEventDefinition.class);
    }

    protected ErrorEventDefinition createErrorEventDefinition(String errorCode) {
        return this.createErrorEventDefinition(errorCode, null);
    }

    protected ErrorEventDefinition createErrorEventDefinition(String errorCode, String errorMessage) {
        Error error = this.findErrorForNameAndCode(errorCode, errorMessage);
        ErrorEventDefinition errorEventDefinition = this.createInstance(ErrorEventDefinition.class);
        errorEventDefinition.setError(error);
        return errorEventDefinition;
    }

    protected Escalation findEscalationForCode(String escalationCode) {
        Escalation escalation2;
        Collection escalations = this.modelInstance.getModelElementsByType(Escalation.class);
        for (Escalation escalation2 : escalations) {
            if (!escalationCode.equals(escalation2.getEscalationCode())) continue;
            return escalation2;
        }
        Definitions definitions = this.modelInstance.getDefinitions();
        escalation2 = this.createChild(definitions, Escalation.class);
        escalation2.setEscalationCode(escalationCode);
        return escalation2;
    }

    protected EscalationEventDefinition createEscalationEventDefinition(String escalationCode) {
        Escalation escalation = this.findEscalationForCode(escalationCode);
        EscalationEventDefinition escalationEventDefinition = this.createInstance(EscalationEventDefinition.class);
        escalationEventDefinition.setEscalation(escalation);
        return escalationEventDefinition;
    }

    protected CompensateEventDefinition createCompensateEventDefinition() {
        return this.createInstance(CompensateEventDefinition.class);
    }

    public B id(String identifier) {
        ((BaseElement)this.element).setId(identifier);
        return (B)((AbstractBaseElementBuilder)this.myself);
    }

    public B documentation(String documentation) {
        Documentation child = this.createChild(this.element, Documentation.class);
        child.setTextContent(documentation);
        return (B)((AbstractBaseElementBuilder)this.myself);
    }

    public B addExtensionElement(BpmnModelElementInstance extensionElement) {
        ExtensionElements extensionElements = this.getCreateSingleChild(ExtensionElements.class);
        extensionElements.addChildElement(extensionElement);
        return (B)((AbstractBaseElementBuilder)this.myself);
    }

    public BpmnShape createBpmnShape(FlowNode node) {
        BpmnPlane bpmnPlane = this.findBpmnPlane();
        if (bpmnPlane != null) {
            BpmnShape bpmnShape = this.createInstance(BpmnShape.class);
            bpmnShape.setBpmnElement(node);
            Bounds nodeBounds = this.createInstance(Bounds.class);
            if (node instanceof SubProcess) {
                bpmnShape.setExpanded(true);
                nodeBounds.setWidth(350.0);
                nodeBounds.setHeight(200.0);
            } else if (node instanceof Activity) {
                nodeBounds.setWidth(100.0);
                nodeBounds.setHeight(80.0);
            } else if (node instanceof Event) {
                nodeBounds.setWidth(36.0);
                nodeBounds.setHeight(36.0);
            } else if (node instanceof Gateway) {
                nodeBounds.setWidth(50.0);
                nodeBounds.setHeight(50.0);
                if (node instanceof ExclusiveGateway) {
                    bpmnShape.setMarkerVisible(true);
                }
            }
            nodeBounds.setX(0.0);
            nodeBounds.setY(0.0);
            bpmnShape.addChildElement(nodeBounds);
            bpmnPlane.addChildElement(bpmnShape);
            return bpmnShape;
        }
        return null;
    }

    protected void setCoordinates(BpmnShape shape) {
        BpmnShape source = this.findBpmnShape((BaseElement)this.element);
        Bounds shapeBounds = shape.getBounds();
        double x = 0.0;
        double y = 0.0;
        if (source != null) {
            Bounds sourceBounds = source.getBounds();
            double sourceX = sourceBounds.getX();
            double sourceWidth = sourceBounds.getWidth();
            x = sourceX + sourceWidth + 50.0;
            BpmnModelElementInstance bpmnModelElementInstance = this.element;
            if (bpmnModelElementInstance instanceof FlowNode) {
                FlowNode flowNode = (FlowNode)bpmnModelElementInstance;
                Collection<SequenceFlow> outgoing = flowNode.getOutgoing();
                if (outgoing.isEmpty()) {
                    double sourceY = sourceBounds.getY();
                    double sourceHeight = sourceBounds.getHeight();
                    double targetHeight = shapeBounds.getHeight();
                    y = sourceY + sourceHeight / 2.0 - targetHeight / 2.0;
                } else {
                    SequenceFlow[] sequenceFlows = outgoing.toArray(new SequenceFlow[outgoing.size()]);
                    SequenceFlow last = sequenceFlows[outgoing.size() - 1];
                    BpmnShape targetShape = this.findBpmnShape(last.getTarget());
                    if (targetShape != null) {
                        Bounds targetBounds = targetShape.getBounds();
                        double lastY = targetBounds.getY();
                        double lastHeight = targetBounds.getHeight();
                        y = lastY + lastHeight + 50.0;
                    }
                }
            }
        }
        shapeBounds.setX(x);
        shapeBounds.setY(y);
    }

    @Deprecated(forRemoval=true, since="1.0")
    public BpmnEdge createBpmnEdge(SequenceFlow sequenceFlow) {
        return this.createEdge(sequenceFlow);
    }

    public BpmnEdge createEdge(BaseElement baseElement) {
        BpmnPlane bpmnPlane = this.findBpmnPlane();
        if (bpmnPlane != null) {
            BpmnEdge edge = this.createInstance(BpmnEdge.class);
            edge.setBpmnElement(baseElement);
            this.setWaypoints(edge);
            bpmnPlane.addChildElement(edge);
            return edge;
        }
        return null;
    }

    protected void setWaypoints(BpmnEdge edge) {
        FlowNode edgeTarget;
        FlowNode edgeSource;
        BaseElement bpmnElement = edge.getBpmnElement();
        if (bpmnElement instanceof SequenceFlow) {
            SequenceFlow sequenceFlow = (SequenceFlow)bpmnElement;
            edgeSource = sequenceFlow.getSource();
            edgeTarget = sequenceFlow.getTarget();
        } else if (bpmnElement instanceof Association) {
            Association association = (Association)bpmnElement;
            edgeSource = (FlowNode)association.getSource();
            edgeTarget = (FlowNode)association.getTarget();
        } else {
            throw new RuntimeException("Bpmn element type not supported");
        }
        this.setWaypointsWithSourceAndTarget(edge, edgeSource, edgeTarget);
    }

    protected void setWaypointsWithSourceAndTarget(BpmnEdge edge, FlowNode edgeSource, FlowNode edgeTarget) {
        BpmnShape source = this.findBpmnShape(edgeSource);
        BpmnShape target = this.findBpmnShape(edgeTarget);
        if (source != null && target != null) {
            Bounds sourceBounds = source.getBounds();
            Bounds targetBounds = target.getBounds();
            double sourceX = sourceBounds.getX();
            double sourceY = sourceBounds.getY();
            double sourceWidth = sourceBounds.getWidth();
            double sourceHeight = sourceBounds.getHeight();
            double targetX = targetBounds.getX();
            double targetY = targetBounds.getY();
            double targetHeight = targetBounds.getHeight();
            Waypoint w1 = this.createInstance(Waypoint.class);
            if (edgeSource.getOutgoing().size() == 1) {
                w1.setX(sourceX + sourceWidth);
                w1.setY(sourceY + sourceHeight / 2.0);
                edge.addChildElement(w1);
            } else {
                w1.setX(sourceX + sourceWidth / 2.0);
                w1.setY(sourceY + sourceHeight);
                edge.addChildElement(w1);
                Waypoint w2 = this.createInstance(Waypoint.class);
                w2.setX(sourceX + sourceWidth / 2.0);
                w2.setY(targetY + targetHeight / 2.0);
                edge.addChildElement(w2);
            }
            Waypoint w3 = this.createInstance(Waypoint.class);
            w3.setX(targetX);
            w3.setY(targetY + targetHeight / 2.0);
            edge.addChildElement(w3);
        }
    }

    protected BpmnPlane findBpmnPlane() {
        Collection planes = this.modelInstance.getModelElementsByType(BpmnPlane.class);
        return (BpmnPlane)planes.iterator().next();
    }

    protected BpmnShape findBpmnShape(BaseElement node) {
        Collection allShapes = this.modelInstance.getModelElementsByType(BpmnShape.class);
        for (BpmnShape shape : allShapes) {
            if (!shape.getBpmnElement().equals(node)) continue;
            return shape;
        }
        return null;
    }

    protected BpmnEdge findBpmnEdge(BaseElement sequenceFlow) {
        Collection allEdges = this.modelInstance.getModelElementsByType(BpmnEdge.class);
        for (BpmnEdge edge : allEdges) {
            if (!edge.getBpmnElement().equals(sequenceFlow)) continue;
            return edge;
        }
        return null;
    }

    protected void resizeSubProcess(BpmnShape innerShape) {
        SubProcess subProcess;
        BpmnShape subProcessShape;
        BaseElement innerElement = innerShape.getBpmnElement();
        Bounds innerShapeBounds = innerShape.getBounds();
        ModelElementInstance parent = innerElement.getParentElement();
        while (parent instanceof SubProcess && (subProcessShape = this.findBpmnShape(subProcess = (SubProcess)parent)) != null) {
            Bounds subProcessBounds = subProcessShape.getBounds();
            double innerX = innerShapeBounds.getX();
            double innerWidth = innerShapeBounds.getWidth();
            double innerY = innerShapeBounds.getY();
            double innerHeight = innerShapeBounds.getHeight();
            double subProcessY = subProcessBounds.getY();
            double subProcessHeight = subProcessBounds.getHeight();
            double subProcessX = subProcessBounds.getX();
            double subProcessWidth = subProcessBounds.getWidth();
            double tmpWidth = innerX + innerWidth + 50.0;
            double tmpHeight = innerY + innerHeight + 50.0;
            if (innerY == subProcessY) {
                subProcessBounds.setY(subProcessY - 50.0);
                subProcessBounds.setHeight(subProcessHeight + 50.0);
            }
            if (tmpWidth >= subProcessX + subProcessWidth) {
                double newWidth = tmpWidth - subProcessX;
                subProcessBounds.setWidth(newWidth);
            }
            if (tmpHeight >= subProcessY + subProcessHeight) {
                double newHeight = tmpHeight - subProcessY;
                subProcessBounds.setHeight(newHeight);
            }
            innerElement = (SubProcess)parent;
            innerShapeBounds = subProcessBounds;
            parent = innerElement.getParentElement();
        }
    }

    protected TimerEventDefinition createTimeCycle(String timerCycle) {
        TimeCycle timeCycle = this.createInstance(TimeCycle.class);
        timeCycle.setTextContent(timerCycle);
        TimerEventDefinition timerDefinition = this.createInstance(TimerEventDefinition.class);
        timerDefinition.setTimeCycle(timeCycle);
        return timerDefinition;
    }

    protected TimerEventDefinition createTimeDate(String timerDate) {
        TimeDate timeDate = this.createInstance(TimeDate.class);
        timeDate.setTextContent(timerDate);
        TimerEventDefinition timerDefinition = this.createInstance(TimerEventDefinition.class);
        timerDefinition.setTimeDate(timeDate);
        return timerDefinition;
    }

    protected TimerEventDefinition createTimeDuration(String timerDuration) {
        TimeDuration timeDuration = this.createInstance(TimeDuration.class);
        timeDuration.setTextContent(timerDuration);
        TimerEventDefinition timerDefinition = this.createInstance(TimerEventDefinition.class);
        timerDefinition.setTimeDuration(timeDuration);
        return timerDefinition;
    }
}

