/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.model.xml.impl.type.reference;

import org.operaton.bpm.model.xml.Model;
import org.operaton.bpm.model.xml.ModelException;
import org.operaton.bpm.model.xml.impl.type.ModelElementTypeImpl;
import org.operaton.bpm.model.xml.impl.type.attribute.AttributeImpl;
import org.operaton.bpm.model.xml.impl.type.child.ChildElementCollectionImpl;
import org.operaton.bpm.model.xml.impl.type.reference.ElementReferenceCollectionImpl;
import org.operaton.bpm.model.xml.instance.ModelElementInstance;
import org.operaton.bpm.model.xml.type.reference.ElementReferenceCollection;
import org.operaton.bpm.model.xml.type.reference.ElementReferenceCollectionBuilder;

public class ElementReferenceCollectionBuilderImpl<Target extends ModelElementInstance, Source extends ModelElementInstance>
implements ElementReferenceCollectionBuilder<Target, Source> {
    private final Class<Source> childElementType;
    private final Class<Target> referenceTargetClass;
    protected ElementReferenceCollectionImpl<Target, Source> elementReferenceCollectionImpl;

    public ElementReferenceCollectionBuilderImpl(Class<Source> childElementType, Class<Target> referenceTargetClass, ChildElementCollectionImpl<Source> collection) {
        this.childElementType = childElementType;
        this.referenceTargetClass = referenceTargetClass;
        this.elementReferenceCollectionImpl = new ElementReferenceCollectionImpl(collection);
    }

    @Override
    public ElementReferenceCollection<Target, Source> build() {
        return this.elementReferenceCollectionImpl;
    }

    @Override
    public void performModelBuild(Model model) {
        ModelElementTypeImpl referenceTargetType = (ModelElementTypeImpl)model.getType(this.referenceTargetClass);
        ModelElementTypeImpl referenceSourceType = (ModelElementTypeImpl)model.getType(this.childElementType);
        this.elementReferenceCollectionImpl.setReferenceTargetElementType(referenceTargetType);
        this.elementReferenceCollectionImpl.setReferenceSourceElementType(referenceSourceType);
        AttributeImpl idAttribute = (AttributeImpl)referenceTargetType.getAttribute("id");
        if (idAttribute == null) {
            throw new ModelException("Unable to find id attribute of " + this.referenceTargetClass);
        }
        idAttribute.registerIncoming(this.elementReferenceCollectionImpl);
        this.elementReferenceCollectionImpl.setReferenceTargetAttribute(idAttribute);
    }
}

