/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.model.xml.impl.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.operaton.bpm.model.xml.impl.util.ModelIoException;
import org.operaton.bpm.model.xml.instance.DomDocument;

public final class IoUtil {
    public static void closeSilently(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getStringFromInputStream(InputStream inputStream) throws IOException {
        return IoUtil.getStringFromInputStream(inputStream, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStringFromInputStream(InputStream inputStream, boolean trim) throws IOException {
        BufferedReader bufferedReader = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line;
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = bufferedReader.readLine()) != null) {
                if (trim) {
                    stringBuilder.append(line.trim());
                    continue;
                }
                stringBuilder.append(line).append("\n");
            }
        }
        catch (Throwable throwable) {
            IoUtil.closeSilently(bufferedReader);
            throw throwable;
        }
        IoUtil.closeSilently(bufferedReader);
        return stringBuilder.toString();
    }

    public static InputStream convertOutputStreamToInputStream(OutputStream outputStream) {
        byte[] data = ((ByteArrayOutputStream)outputStream).toByteArray();
        return new ByteArrayInputStream(data);
    }

    public static String convertXmlDocumentToString(DomDocument document) {
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        IoUtil.transformDocumentToXml(document, result);
        return stringWriter.toString();
    }

    public static void writeDocumentToOutputStream(DomDocument document, OutputStream outputStream) {
        StreamResult result = new StreamResult(outputStream);
        IoUtil.transformDocumentToXml(document, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transformDocumentToXml(DomDocument document, StreamResult result) {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DomDocument domDocument = document;
            synchronized (domDocument) {
                transformer.transform(document.getDomSource(), result);
            }
        }
        catch (TransformerConfigurationException e) {
            throw new ModelIoException("Unable to create a transformer for the model", e);
        }
        catch (TransformerException e) {
            throw new ModelIoException("Unable to transform model to xml", e);
        }
    }
}

