/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.model.xml.impl.util;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URISyntaxException;
import java.net.URL;
import org.operaton.bpm.model.xml.ModelException;

public abstract class ReflectUtil {
    public static InputStream getResourceAsStream(String name) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream resourceStream = classLoader.getResourceAsStream(name);
        if (resourceStream == null) {
            classLoader = ReflectUtil.class.getClassLoader();
            resourceStream = classLoader.getResourceAsStream(name);
        }
        return resourceStream;
    }

    public static URL getResource(String name) {
        return ReflectUtil.getResource(name, null);
    }

    public static URL getResource(String name, ClassLoader classLoader) {
        URL url;
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if ((url = classLoader.getResource(name)) == null) {
            classLoader = ReflectUtil.class.getClassLoader();
            url = classLoader.getResource(name);
        }
        return url;
    }

    public static File getResourceAsFile(String path) {
        URL resource = ReflectUtil.getResource(path);
        try {
            return new File(resource.toURI());
        }
        catch (URISyntaxException e) {
            throw new ModelException("Exception while loading resource file " + path, e);
        }
    }

    public static <T> T createInstance(Class<T> type, Object ... parameters) {
        Class[] parameterTypes = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Object parameter = parameters[i];
            parameterTypes[i] = parameter.getClass();
        }
        try {
            Constructor<T> constructor = type.getConstructor(parameterTypes);
            return constructor.newInstance(parameters);
        }
        catch (Exception e) {
            throw new ModelException("Exception while creating an instance of type " + type, e);
        }
    }
}

