/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.model.xml.test.assertions;

import org.assertj.core.api.AbstractAssert;
import org.operaton.bpm.model.xml.instance.ModelElementInstance;
import org.operaton.bpm.model.xml.type.ModelElementType;
import org.operaton.bpm.model.xml.type.child.ChildElementCollection;

public class ChildElementAssert
extends AbstractAssert<ChildElementAssert, ChildElementCollection<?>> {
    private final Class<? extends ModelElementInstance> typeClass;

    protected ChildElementAssert(ChildElementCollection<?> actual) {
        super(actual, ChildElementAssert.class);
        this.typeClass = actual.getChildElementTypeClass();
    }

    public ChildElementAssert occursMinimal(int minOccurs) {
        this.isNotNull();
        int actualMinOccurs = ((ChildElementCollection)this.actual).getMinOccurs();
        if (actualMinOccurs != minOccurs) {
            this.failWithMessage("Expected child element <%s> to have a min occurs of <%s> but was <%s>", new Object[]{this.typeClass, minOccurs, actualMinOccurs});
        }
        return this;
    }

    public ChildElementAssert occursMaximal(int maxOccurs) {
        this.isNotNull();
        int actualMaxOccurs = ((ChildElementCollection)this.actual).getMaxOccurs();
        if (actualMaxOccurs != maxOccurs) {
            this.failWithMessage("Expected child element <%s> to have a max occurs of <%s> but was <%s>", new Object[]{this.typeClass, maxOccurs, actualMaxOccurs});
        }
        return this;
    }

    public ChildElementAssert isOptional() {
        this.isNotNull();
        int actualMinOccurs = ((ChildElementCollection)this.actual).getMinOccurs();
        if (actualMinOccurs != 0) {
            this.failWithMessage("Expected child element <%s> to be optional but has min occurs of <%s>", new Object[]{this.typeClass, actualMinOccurs});
        }
        return this;
    }

    public ChildElementAssert isUnbounded() {
        this.isNotNull();
        int actualMaxOccurs = ((ChildElementCollection)this.actual).getMaxOccurs();
        if (actualMaxOccurs != -1) {
            this.failWithMessage("Expected child element <%s> to be unbounded but has a max occurs of <%s>", new Object[]{this.typeClass, actualMaxOccurs});
        }
        return this;
    }

    public ChildElementAssert isMutable() {
        this.isNotNull();
        boolean actualImmutable = ((ChildElementCollection)this.actual).isImmutable();
        if (actualImmutable) {
            this.failWithMessage("Expected child element <%s> to be mutable but was not", new Object[]{this.typeClass});
        }
        return this;
    }

    public ChildElementAssert isImmutable() {
        this.isNotNull();
        boolean actualImmutable = ((ChildElementCollection)this.actual).isImmutable();
        if (!actualImmutable) {
            this.failWithMessage("Expected child element <%s> to be immutable but was not", new Object[]{this.typeClass});
        }
        return this;
    }

    public ChildElementAssert containsType(Class<? extends ModelElementInstance> childElementTypeClass) {
        this.isNotNull();
        Class actualChildElementTypeClass = ((ChildElementCollection)this.actual).getChildElementTypeClass();
        if (!childElementTypeClass.equals(actualChildElementTypeClass)) {
            this.failWithMessage("Expected child element <%s> to contain elements of type <%s> but contains elements of type <%s>", new Object[]{this.typeClass, childElementTypeClass, actualChildElementTypeClass});
        }
        return this;
    }

    public ChildElementAssert hasParentElementType(ModelElementType parentElementType) {
        this.isNotNull();
        ModelElementType actualParentElementType = ((ChildElementCollection)this.actual).getParentElementType();
        if (!parentElementType.equals(actualParentElementType)) {
            this.failWithMessage("Expected child element <%s> to have parent element type <%s> but has <%s>", new Object[]{this.typeClass, parentElementType.getTypeName(), actualParentElementType.getTypeName()});
        }
        return this;
    }

    public ChildElementAssert isNotEmpty(ModelElementInstance instance) {
        this.isNotNull();
        int actualNumberOfChildElements = ((ChildElementCollection)this.actual).get(instance).size();
        if (actualNumberOfChildElements == 0) {
            this.failWithMessage("Expected child element <%s> to contain elements but was not", new Object[]{this.typeClass});
        }
        return this;
    }

    public ChildElementAssert hasSize(ModelElementInstance instance, int numberOfChildElements) {
        this.isNotNull();
        int actualNumberOfChildElements = ((ChildElementCollection)this.actual).get(instance).size();
        if (actualNumberOfChildElements != numberOfChildElements) {
            this.failWithMessage("Expected child element <%s> to contain <%s> elements but has <%s>", new Object[]{this.typeClass, numberOfChildElements, actualNumberOfChildElements});
        }
        return this;
    }

    public ChildElementAssert isEmpty(ModelElementInstance instance) {
        this.isNotNull();
        int actualNumberOfChildElements = ((ChildElementCollection)this.actual).get(instance).size();
        if (actualNumberOfChildElements > 0) {
            this.failWithMessage("Expected child element <%s> to contain no elements but contains <%s> elements", new Object[]{this.typeClass, actualNumberOfChildElements});
        }
        return this;
    }
}

