/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.model.xml.impl.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.operaton.bpm.model.xml.Model;
import org.operaton.bpm.model.xml.ModelException;
import org.operaton.bpm.model.xml.ModelInstance;
import org.operaton.bpm.model.xml.impl.ModelImpl;
import org.operaton.bpm.model.xml.impl.ModelInstanceImpl;
import org.operaton.bpm.model.xml.impl.instance.ModelTypeInstanceContext;
import org.operaton.bpm.model.xml.impl.util.ModelTypeException;
import org.operaton.bpm.model.xml.impl.util.ModelUtil;
import org.operaton.bpm.model.xml.instance.DomDocument;
import org.operaton.bpm.model.xml.instance.DomElement;
import org.operaton.bpm.model.xml.instance.ModelElementInstance;
import org.operaton.bpm.model.xml.type.ModelElementType;
import org.operaton.bpm.model.xml.type.ModelElementTypeBuilder;
import org.operaton.bpm.model.xml.type.attribute.Attribute;
import org.operaton.bpm.model.xml.type.child.ChildElementCollection;

public class ModelElementTypeImpl
implements ModelElementType {
    private final ModelImpl model;
    private final String typeName;
    private final Class<? extends ModelElementInstance> instanceType;
    private String typeNamespace;
    private ModelElementTypeImpl baseType;
    private final List<ModelElementType> extendingTypes = new ArrayList<ModelElementType>();
    private final List<Attribute<?>> attributes = new ArrayList();
    private final List<ModelElementType> childElementTypes = new ArrayList<ModelElementType>();
    private final List<ChildElementCollection<?>> childElementCollections = new ArrayList();
    private ModelElementTypeBuilder.ModelTypeInstanceProvider<?> instanceProvider;
    private boolean isAbstract;

    public ModelElementTypeImpl(ModelImpl model, String name, Class<? extends ModelElementInstance> instanceType) {
        this.model = model;
        this.typeName = name;
        this.instanceType = instanceType;
    }

    @Override
    public ModelElementInstance newInstance(ModelInstance modelInstance) {
        ModelInstanceImpl modelInstanceImpl = (ModelInstanceImpl)modelInstance;
        DomDocument document = modelInstanceImpl.getDocument();
        DomElement domElement = document.createElement(this.typeNamespace, this.typeName);
        return this.newInstance(modelInstanceImpl, domElement);
    }

    public ModelElementInstance newInstance(ModelInstanceImpl modelInstance, DomElement domElement) {
        ModelTypeInstanceContext modelTypeInstanceContext = new ModelTypeInstanceContext(domElement, modelInstance, this);
        return this.createModelElementInstance(modelTypeInstanceContext);
    }

    public void registerAttribute(Attribute<?> attribute) {
        if (!this.attributes.contains(attribute)) {
            this.attributes.add(attribute);
        }
    }

    public void registerChildElementType(ModelElementType childElementType) {
        if (!this.childElementTypes.contains(childElementType)) {
            this.childElementTypes.add(childElementType);
        }
    }

    public void registerChildElementCollection(ChildElementCollection<?> childElementCollection) {
        if (!this.childElementCollections.contains(childElementCollection)) {
            this.childElementCollections.add(childElementCollection);
        }
    }

    public void registerExtendingType(ModelElementType modelType) {
        if (!this.extendingTypes.contains(modelType)) {
            this.extendingTypes.add(modelType);
        }
    }

    protected ModelElementInstance createModelElementInstance(ModelTypeInstanceContext instanceContext) {
        if (this.isAbstract) {
            throw new ModelTypeException("Model element type " + this.getTypeName() + " is abstract and no instances can be created.");
        }
        return this.instanceProvider.newInstance(instanceContext);
    }

    @Override
    public final List<Attribute<?>> getAttributes() {
        return this.attributes;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public Class<? extends ModelElementInstance> getInstanceType() {
        return this.instanceType;
    }

    public void setTypeNamespace(String typeNamespace) {
        this.typeNamespace = typeNamespace;
    }

    @Override
    public String getTypeNamespace() {
        return this.typeNamespace;
    }

    public void setBaseType(ModelElementTypeImpl baseType) {
        if (this.baseType == null) {
            this.baseType = baseType;
        } else if (!this.baseType.equals(baseType)) {
            throw new ModelException("Type can not have multiple base types. " + String.valueOf(this.getClass()) + " already extends type " + String.valueOf(this.baseType.getClass()) + " and can not also extend type " + String.valueOf(baseType.getClass()));
        }
    }

    public void setInstanceProvider(ModelElementTypeBuilder.ModelTypeInstanceProvider<?> instanceProvider) {
        this.instanceProvider = instanceProvider;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    @Override
    public Collection<ModelElementType> getExtendingTypes() {
        return Collections.unmodifiableCollection(this.extendingTypes);
    }

    @Override
    public Collection<ModelElementType> getAllExtendingTypes() {
        HashSet<ModelElementType> result = new HashSet<ModelElementType>();
        result.add(this);
        this.resolveExtendingTypes(result);
        return result;
    }

    public void resolveExtendingTypes(Set<ModelElementType> allExtendingTypes) {
        for (ModelElementType modelElementType : this.extendingTypes) {
            ModelElementTypeImpl modelElementTypeImpl = (ModelElementTypeImpl)modelElementType;
            if (allExtendingTypes.contains(modelElementTypeImpl)) continue;
            allExtendingTypes.add(modelElementType);
            modelElementTypeImpl.resolveExtendingTypes(allExtendingTypes);
        }
    }

    public void resolveBaseTypes(List<ModelElementType> baseTypes) {
        if (this.baseType != null) {
            baseTypes.add(this.baseType);
            this.baseType.resolveBaseTypes(baseTypes);
        }
    }

    @Override
    public ModelElementType getBaseType() {
        return this.baseType;
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public List<ModelElementType> getChildElementTypes() {
        return this.childElementTypes;
    }

    @Override
    public List<ModelElementType> getAllChildElementTypes() {
        ArrayList<ModelElementType> allChildElementTypes = new ArrayList<ModelElementType>();
        if (this.baseType != null) {
            allChildElementTypes.addAll(this.baseType.getAllChildElementTypes());
        }
        allChildElementTypes.addAll(this.childElementTypes);
        return allChildElementTypes;
    }

    public List<ChildElementCollection<?>> getChildElementCollections() {
        return this.childElementCollections;
    }

    public List<ChildElementCollection<?>> getAllChildElementCollections() {
        ArrayList allChildElementCollections = new ArrayList();
        if (this.baseType != null) {
            allChildElementCollections.addAll(this.baseType.getAllChildElementCollections());
        }
        allChildElementCollections.addAll(this.childElementCollections);
        return allChildElementCollections;
    }

    @Override
    public Collection<ModelElementInstance> getInstances(ModelInstance modelInstance) {
        ModelInstanceImpl modelInstanceImpl = (ModelInstanceImpl)modelInstance;
        DomDocument document = modelInstanceImpl.getDocument();
        List<DomElement> elements = this.getElementsByNameNs(document, this.typeNamespace);
        ArrayList<ModelElementInstance> resultList = new ArrayList<ModelElementInstance>();
        for (DomElement element : elements) {
            resultList.add(ModelUtil.getModelElement(element, modelInstanceImpl, this));
        }
        return resultList;
    }

    protected List<DomElement> getElementsByNameNs(DomDocument document, String namespaceURI) {
        Set<String> alternativeNamespaces;
        List<DomElement> elements = document.getElementsByNameNs(namespaceURI, this.typeName);
        if (elements.isEmpty() && (alternativeNamespaces = this.getModel().getAlternativeNamespaces(namespaceURI)) != null) {
            Iterator<String> namespaceIt = alternativeNamespaces.iterator();
            while (elements.isEmpty() && namespaceIt.hasNext()) {
                elements = this.getElementsByNameNs(document, namespaceIt.next());
            }
        }
        return elements;
    }

    public boolean isBaseTypeOf(ModelElementType elementType) {
        if (this.equals(elementType)) {
            return true;
        }
        Collection<ModelElementType> baseTypes = ModelUtil.calculateAllBaseTypes(elementType);
        return baseTypes.contains(this);
    }

    public Collection<Attribute<?>> getAllAttributes() {
        ArrayList allAttributes = new ArrayList();
        allAttributes.addAll(this.getAttributes());
        Collection<ModelElementType> baseTypes = ModelUtil.calculateAllBaseTypes(this);
        for (ModelElementType type : baseTypes) {
            allAttributes.addAll(type.getAttributes());
        }
        return allAttributes;
    }

    @Override
    public Attribute<?> getAttribute(String attributeName) {
        for (Attribute<?> attribute : this.getAllAttributes()) {
            if (!attribute.getAttributeName().equals(attributeName)) continue;
            return attribute;
        }
        return null;
    }

    public ChildElementCollection<?> getChildElementCollection(ModelElementType childElementType) {
        for (ChildElementCollection<?> childElementCollection : this.getChildElementCollections()) {
            if (!childElementType.equals(childElementCollection.getChildElementType(this.model))) continue;
            return childElementCollection;
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.model == null ? 0 : this.model.hashCode());
        result = prime * result + (this.typeName == null ? 0 : this.typeName.hashCode());
        return prime * result + (this.typeNamespace == null ? 0 : this.typeNamespace.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModelElementTypeImpl other = (ModelElementTypeImpl)obj;
        if (this.model == null ? other.model != null : !this.model.equals(other.model)) {
            return false;
        }
        if (this.typeName == null ? other.typeName != null : !this.typeName.equals(other.typeName)) {
            return false;
        }
        return !(this.typeNamespace == null ? other.typeNamespace != null : !this.typeNamespace.equals(other.typeNamespace));
    }
}

