/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.model.xml.impl.type.attribute;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.operaton.bpm.model.xml.impl.type.reference.ReferenceImpl;
import org.operaton.bpm.model.xml.instance.ModelElementInstance;
import org.operaton.bpm.model.xml.type.ModelElementType;
import org.operaton.bpm.model.xml.type.attribute.Attribute;
import org.operaton.bpm.model.xml.type.reference.Reference;

public abstract class AttributeImpl<T>
implements Attribute<T> {
    private String attributeName;
    private String namespaceUri;
    private T defaultValue;
    private boolean isRequired;
    private boolean isIdAttribute;
    private final List<Reference<?>> outgoingReferences = new ArrayList();
    private final List<Reference<?>> incomingReferences = new ArrayList();
    private final ModelElementType owningElementType;

    AttributeImpl(ModelElementType owningElementType) {
        this.owningElementType = owningElementType;
    }

    protected abstract T convertXmlValueToModelValue(String var1);

    protected abstract String convertModelValueToXmlValue(T var1);

    @Override
    public ModelElementType getOwningElementType() {
        return this.owningElementType;
    }

    @Override
    public T getValue(ModelElementInstance modelElement) {
        String value;
        if (this.namespaceUri == null) {
            value = modelElement.getAttributeValue(this.attributeName);
        } else {
            Set<String> alternativeNamespaces;
            value = modelElement.getAttributeValueNs(this.namespaceUri, this.attributeName);
            if (value == null && (alternativeNamespaces = this.owningElementType.getModel().getAlternativeNamespaces(this.namespaceUri)) != null) {
                Iterator<String> namespaceIt = alternativeNamespaces.iterator();
                while (value == null && namespaceIt.hasNext()) {
                    value = modelElement.getAttributeValueNs(namespaceIt.next(), this.attributeName);
                }
            }
        }
        if (value == null && this.defaultValue != null) {
            return this.defaultValue;
        }
        return this.convertXmlValueToModelValue(value);
    }

    @Override
    public void setValue(ModelElementInstance modelElement, T value) {
        this.setValue(modelElement, value, true);
    }

    @Override
    public void setValue(ModelElementInstance modelElement, T value, boolean withReferenceUpdate) {
        String xmlValue = this.convertModelValueToXmlValue(value);
        if (this.namespaceUri == null) {
            modelElement.setAttributeValue(this.attributeName, xmlValue, this.isIdAttribute, withReferenceUpdate);
        } else {
            modelElement.setAttributeValueNs(this.namespaceUri, this.attributeName, xmlValue, this.isIdAttribute, withReferenceUpdate);
        }
    }

    public void updateIncomingReferences(ModelElementInstance modelElement, String newIdentifier, String oldIdentifier) {
        if (!this.incomingReferences.isEmpty()) {
            for (Reference<?> incomingReference : this.incomingReferences) {
                ((ReferenceImpl)incomingReference).referencedElementUpdated(modelElement, oldIdentifier, newIdentifier);
            }
        }
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    public void setRequired(boolean required) {
        this.isRequired = required;
    }

    public void setNamespaceUri(String namespaceUri) {
        this.namespaceUri = namespaceUri;
    }

    @Override
    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    @Override
    public boolean isIdAttribute() {
        return this.isIdAttribute;
    }

    public void setId() {
        this.isIdAttribute = true;
    }

    @Override
    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    @Override
    public void removeAttribute(ModelElementInstance modelElement) {
        if (this.namespaceUri == null) {
            modelElement.removeAttribute(this.attributeName);
        } else {
            modelElement.removeAttributeNs(this.namespaceUri, this.attributeName);
        }
    }

    public void unlinkReference(ModelElementInstance modelElement, Object referenceIdentifier) {
        if (!this.incomingReferences.isEmpty()) {
            for (Reference<?> incomingReference : this.incomingReferences) {
                ((ReferenceImpl)incomingReference).referencedElementRemoved(modelElement, referenceIdentifier);
            }
        }
    }

    @Override
    public List<Reference<?>> getIncomingReferences() {
        return this.incomingReferences;
    }

    @Override
    public List<Reference<?>> getOutgoingReferences() {
        return this.outgoingReferences;
    }

    public void registerOutgoingReference(Reference<?> ref) {
        this.outgoingReferences.add(ref);
    }

    public void registerIncoming(Reference<?> ref) {
        this.incomingReferences.add(ref);
    }
}

