/*
 * Decompiled with CFR 0.152.
 */
package org.operaton.bpm.model.xml.impl.type.reference;

import org.operaton.bpm.model.xml.Model;
import org.operaton.bpm.model.xml.ModelException;
import org.operaton.bpm.model.xml.impl.type.ModelElementTypeImpl;
import org.operaton.bpm.model.xml.impl.type.attribute.AttributeImpl;
import org.operaton.bpm.model.xml.impl.type.child.ChildElementCollectionImpl;
import org.operaton.bpm.model.xml.impl.type.reference.ElementReferenceCollectionImpl;
import org.operaton.bpm.model.xml.instance.ModelElementInstance;
import org.operaton.bpm.model.xml.type.reference.ElementReferenceCollection;
import org.operaton.bpm.model.xml.type.reference.ElementReferenceCollectionBuilder;

public class ElementReferenceCollectionBuilderImpl<TARGET extends ModelElementInstance, SOURCE extends ModelElementInstance>
implements ElementReferenceCollectionBuilder<TARGET, SOURCE> {
    private final Class<SOURCE> childElementType;
    private final Class<TARGET> referenceTargetClass;
    protected ElementReferenceCollectionImpl<TARGET, SOURCE> elementReferenceCollectionImpl;

    public ElementReferenceCollectionBuilderImpl(Class<SOURCE> childElementType, Class<TARGET> referenceTargetClass, ChildElementCollectionImpl<SOURCE> collection) {
        this.childElementType = childElementType;
        this.referenceTargetClass = referenceTargetClass;
        this.elementReferenceCollectionImpl = new ElementReferenceCollectionImpl(collection);
    }

    @Override
    public ElementReferenceCollection<TARGET, SOURCE> build() {
        return this.elementReferenceCollectionImpl;
    }

    @Override
    public void performModelBuild(Model model) {
        ModelElementTypeImpl referenceTargetType = (ModelElementTypeImpl)model.getType(this.referenceTargetClass);
        ModelElementTypeImpl referenceSourceType = (ModelElementTypeImpl)model.getType(this.childElementType);
        this.elementReferenceCollectionImpl.setReferenceTargetElementType(referenceTargetType);
        this.elementReferenceCollectionImpl.setReferenceSourceElementType(referenceSourceType);
        AttributeImpl idAttribute = (AttributeImpl)referenceTargetType.getAttribute("id");
        if (idAttribute == null) {
            throw new ModelException("Unable to find id attribute of " + String.valueOf(this.referenceTargetClass));
        }
        idAttribute.registerIncoming(this.elementReferenceCollectionImpl);
        this.elementReferenceCollectionImpl.setReferenceTargetAttribute(idAttribute);
    }
}

